/******************************** (C) COPYRIGHT 2015 Seven ********************************
* @Function:    FIFO  For STM8
* @Author:      Seven
* @Data:        2016/01/21
* @Version Log:
* -----------------------------------------------------------------------------------------
* 2016/01/21  V1.0  Seven  
******************************************************************************************/
#ifndef __FIFO_H
#define __FIFO_H

/****************************************************************************
* @Description:Head files
*****************************************************************************/
#include "stm8s.h"

#define UINT8_T             1
#define UINT16_T            2
#define UINT32_T            3
#define FLOAT               4
#define DOUBLE              5

/******************************************************************************************
* @Description:FIFO struct define
*******************************************************************************************/
typedef struct
{
    uint8_t* BaseAddr;    //ָ򻺴ʼַ
    uint8_t* Write;        //дָ
    uint8_t* Read;        //ָ
    uint32_t Size;        //С
    uint32_t Remain;    //ʣռ
}FIFO_TypeDef;

/******************************************************************************************
* @Description:FIFO API
*******************************************************************************************/
uint8_t FIFO_Create(FIFO_TypeDef* Buff, uint8_t* BuffAddr, uint32_t Max);
//uint8_t FIFO_Delete(FIFO_TypeDef* Buff);
uint8_t FIFO_In(FIFO_TypeDef* FIFO, void* dat, uint8_t Type);
uint8_t FIFO_Out(FIFO_TypeDef* FIFO, void* dat, uint8_t Type);

#endif

/******************************** (C) COPYRIGHT 2015 Seven ********************************/
