/******************************** (C) COPYRIGHT 2015 Seven ********************************
* @Function:    FIFO  For STM8
* @Author:      Seven
* @Data:        2016/01/21
* @Version Log:
* -----------------------------------------------------------------------------------------
* 2016/01/21  V1.0  Seven  
******************************************************************************************/
#include "fifo.h"

/****************************************************************************
* @Description: Debug option
*****************************************************************************/
//#define FIFO_DEBUG_ENABLE
#ifdef  FIFO_DEBUG_ENABLE
#define FIFO_DEBUGF(format,...) //rt_kprintf(""__FILE__",%d -> "format" \n",__LINE__,##__VA_ARGS__)
#define FIFO_DEBUG(format,...)  //rt_kprintf(format,##__VA_ARGS__)
#else
#define FIFO_DEBUG(format,...)
#endif

/******************************************************************************************
* @Function:    Create a FIFO
* @Parameter:   [FIFO struct pointer][FIFO size]
* @Return:      [Status]
* @Description:
*******************************************************************************************/
uint8_t FIFO_Create(FIFO_TypeDef* Buff, uint8_t* BuffAddr, uint32_t Max)
{
    Buff->BaseAddr = BuffAddr;
    if (Buff->BaseAddr == 0)
    {
        FIFO_DEBUG("FIFO Create Fail \r\n");
        return 1;    //ʧ
    }
    else
    {
        Buff->Size = Max;    //ֵ
        Buff->Remain = Max;  //ʣռ
        Buff->Write = Buff->Read = Buff->BaseAddr;  //ʼʱָ򻺳 0
        FIFO_DEBUG("FIFO Size= %d, BaseAddr=0x%08X \r\n", Buff->Size, Buff->BaseAddr);
        return 0;
    }
}

/******************************************************************************************
* @Function:    Free a FIFO
* @Parameter:   [FIFO struct pointer]
* @Return:      [Status]
* @Description:
*******************************************************************************************/
uint8_t FIFO_Delete(FIFO_TypeDef* Buff)
{
    //free(Buff->BaseAddr);    //ͷŻ
    Buff->Size = 0;    //գֹҰָ
    Buff->Remain = 0;  //գֹҰָ
    Buff->Write = Buff->Read = Buff->BaseAddr = 0;  //գֹҰָ
    return 0;
}

/******************************************************************************************
* @Function:    FIFO In
* @Parameter:   [FIFO struct pointer][Data Pointer][Data Type]
* @Return:      [Status]
* @Description:
*******************************************************************************************/
uint8_t FIFO_In(FIFO_TypeDef* FIFO, void* dat, uint8_t Type)
{
    uint8_t* pDat = (uint8_t*)dat;
    uint8_t type,i;
    //;һдֽڣĬ1
    switch(Type)
    {
        case UINT8_T :type = 1;break;
        case UINT16_T:type = 2;break;
        case UINT32_T:type = 4;break;
        case FLOAT   :type = 4;break;
        case DOUBLE  :type = 8;break;
        default      :type = 1;break;
    }
    
    //дһ
    if (FIFO->Remain < type)
    {
        FIFO_DEBUG("Error:FIFO Full\n");
        return 1;
    }
    //д˻ͷ
    if (FIFO->Write == (FIFO->BaseAddr + FIFO->Size))
    {
        FIFO_DEBUG("FIFO Tail\n");
        FIFO->Write = FIFO->BaseAddr;
    }
    for(i = 0; i < type; i++)
    {
        //FIFO_DEBUG("0x%02X ", *pDat);
        *(FIFO->Write)++ = *pDat++;
        FIFO->Remain--;
    }
    #ifdef  FIFO_DEBUG_ENABLE
        pDat -= type;
        if(Type == UINT8_T)
        {
            FIFO_DEBUG("FIFO in:0x%02X,%d \n", *(uint8_t*)pDat, *(uint8_t*)pDat);
        }
        else if(Type == UINT16_T)
        {
            FIFO_DEBUG("FIFO in:0x%04X,%d \n", *(uint16_t*)pDat, *(uint16_t*)pDat);
        }
        else if(Type == UINT32_T)
        {
            FIFO_DEBUG("FIFO in:0x%08X,%d \n", *(uint32_t*)pDat, *(uint32_t*)pDat);
        }
        else if(Type == FLOAT)
        {
            //FIFO_DEBUG("FIFO in:%f \n", *(float*)pDat);
            char str[30];
            sprintf(str,"FIFO in:%f\n", *(float*)pDat);
            FIFO_DEBUG(str);
        }
        else if(Type == DOUBLE)
        {
            //FIFO_DEBUG("FIFO in:%f \n", *(double*)pDat);
            char str[30];
            sprintf(str,"FIFO in:%f\n", *(double*)pDat);
            FIFO_DEBUG(str);
        }
    #endif
    return 0;
}

/******************************************************************************************
* @Function:    FIFO Out
* @Parameter:   [FIFO struct pointer][Data][Data Type]
* @Return:      [Status]
* @Description:
*******************************************************************************************/
uint8_t FIFO_Out(FIFO_TypeDef* FIFO, void* dat, uint8_t Type)
{
    uint8_t* pDat = (uint8_t*)dat;
    uint8_t type,i;
    //;һζȡֽڣĬ1
    switch(Type)
    {
        case UINT8_T :type = 1;break;
        case UINT16_T:type = 2;break;
        case UINT32_T:type = 4;break;
        case FLOAT   :type = 4;break;
        case DOUBLE  :type = 8;break;
        default      :type = 1;break;
    }

    //Ϊ
    if (FIFO->Remain == FIFO->Size)
    {
        FIFO_DEBUG("Error:FIFO Empty\n");
        return 1;
    }
    
    //ʣݲǸ͵
    if ( (FIFO->Size - FIFO->Remain) < type)
    {
        FIFO_DEBUG("Error:Data Mismatch This Type \n");
        return 1;
    }
    
    //ӻȡ
    for(i = 0; i < type; i++)
    {
        *(uint8_t*)pDat++ = *(uint8_t*)FIFO->Read++;
    }
    FIFO_DEBUG("FIFO double\n");
    #ifdef  FIFO_DEBUG_ENABLE
        pDat--;
        pDat -= type;
        if(Type == UINT8_T)
        {
            FIFO_DEBUG("FIFO Out:0x%02X,%d \n", *(uint8_t*)pDat, *(uint8_t*)pDat);
        }
        else if(Type == UINT16_T)
        {
            FIFO_DEBUG("FIFO Out:0x%04X,%d \n", *(uint16_t*)pDat, *(uint16_t*)pDat);
        }
        else if(Type == UINT32_T)
        {
            FIFO_DEBUG("FIFO Out:0x%08X,%d \n", *(uint32_t*)pDat, *(uint32_t*)pDat);
        }
        else if(Type == FLOAT)
        {
            //FIFO_DEBUG("FIFO Out:%f \n", *(float*)pDat);
            char str[60];
            sprintf(str,"FIFO Out:%f\n", *(float*)pDat);
            FIFO_DEBUG(str);
        }
//         else if(Type == DOUBLE)
//         {
//             //FIFO_DEBUG("FIFO Out:%f \n", *(double*)pDat);
//             char str[60];
//             sprintf(str,"FIFO Out:%lf\n", *(double*)pDat);
//             FIFO_DEBUG(str);
//         }
    #endif
//     FIFO->Read += type;
    FIFO->Remain += type;
    //˻ͷ
    if ( FIFO->Read >= (FIFO->BaseAddr + FIFO->Size) )
    {
        FIFO_DEBUG("FIFO Tail\n");
        FIFO->Read = FIFO->BaseAddr;
    }

    return 0;
}

/******************************** (C) COPYRIGHT 2015 Seven *******************************/
