// include libraries from https://learn.adafruit.com/adafruit-motor-shield-v2-for-arduino/using-dc-motors
#include <Wire.h>
#include <Adafruit_MotorShield.h>
#include "utility/Adafruit_MS_PWMServoDriver.h"
Adafruit_MotorShield AFMS = Adafruit_MotorShield();   // call function for using motorshield

// =====================================================================================
// Motor ===============================================================================
// For each connected motor, one motor object is created. 
// The object stores information about the pin, where the motor is plugged as well as
//      the minimum and maximum range and direction the motor can be driven.
// The motor speed is constantly updated according to sensor values with the drive function.
class Motor {  
  private:
    Adafruit_DCMotor *motor;
    int curDirection;
    int minVal; 
    int maxVal;
  
  public: 
  Motor (int motorPin, int motorMin, int motorMax){
    this -> motor = AFMS.getMotor(motorPin);
    this -> minVal = motorMin; 
    this -> maxVal = motorMax; 
    this -> curDirection = FORWARD; // BACKWARD is another option
  }

  void drive(int value, int sensorMin, int sensorMax) {
    int outputValue = map(value, sensorMin, sensorMax, this->minVal, this->maxVal);  // map current sensor value to motor speed
    this -> motor -> setSpeed(outputValue); 
    this -> motor -> run(this->curDirection); 
  }
};

// =====================================================================================
// Output ==============================================================================
// SensoryOuput is an object that stores one or multiple sensorpins in an array. 
// It is only possible to group sensor pins that have the same minimum and maximum range. 
// In getValue() a function is included, where the sensory values can be used for further calculations. 
// This code provides an average calculation, but could be extended to whatever is required. 
class SensoryOutput {
  private: 
    int finalOutput; 
    int minRange;
    int maxRange; 
    int curArrayLength; 
    unsigned char valueArray[20];
  
  public: 
  SensoryOutput (int minRange, int maxRange) {
    this -> minRange = minRange;
    this -> maxRange = maxRange;
    this -> curArrayLength = 0; 
  }
  
  void include(unsigned char pin) {
    valueArray[curArrayLength] = pin;
    curArrayLength ++;
  }
  
  int getValue(){
     finalOutput = 0;

     // TODO: do whatever you want with sensory values
     // here the average is built, if multiple values are combined
     for (int i = 0; i < curArrayLength; i++) {
         finalOutput += analogRead(valueArray[i]);
    }
    return finalOutput / curArrayLength;
  }
  
  int getMin() {
      return this->minRange; 
  }
  
  int getMax() {
    return this->maxRange; 
  }
};

// =====================================================================================
// MAIN ================================================================================
// Here, motors, sensors and SensoryInputs are defined. 

// TODO: Declare motor pins, minimum and maximum speed per motor 
Motor motor1 = Motor(1, 25, 175), 
motor2 = Motor(2, 25, 175), 
motor3 = Motor(3, 25, 175), 
motor4 = Motor(4, 25, 175);

// TODO: Declare one sensory output per motor and set the minimum and maximum sensor range
SensoryOutput output1 = SensoryOutput(0,1023), 
output2 = SensoryOutput(0,1023), 
output3 = SensoryOutput(0,1023),
output4 = SensoryOutput(0,1023);

// define which sensors should be included in which sensoryOutputs
// either one sensor pin can be handled in one sensory output, or multiple 
void setup() {
  AFMS.begin();               // adafruit motor shield begins functioning
  
  // TODO: Declare analog pins per output value here: 
  output1.include(A0); // output1 combines values from 2 pins (can be done with more pins as well)
  output1.include(A1); 
  output2.include(A1); 
  output3.include(A2);
  output4.include(A3); 
}

// TODO: Give every motor its output (here motor1-output1, motor2-output2, ...)
void loop() {
  motor1.drive(output1.getValue(), output1.getMin(), output1.getMax());
  motor2.drive(output2.getValue(), output2.getMin(), output2.getMax());
  motor3.drive(output3.getValue(), output3.getMin(), output3.getMax());
  motor4.drive(output4.getValue(), output4.getMin(), output4.getMax());
}
