'=============================Subroutines======================

'Sub GetMotorBaseSpeed()
'Calculates base speed form 0 to 500 on how fast motors should be turning based on stick position over time
'Fills BaseMotorSpeed with 0 to 500 value

'Sub GetSpeedScalar()
'Calulates speed multiplier to apply to basemotorspeed based on minimum distances to either side
'Filles SpeedScalar with a value from 0 to 100 with 100 representing no objects

'Sub GetTurnScalar()
'Calculates amount to turn based on front objects 
'Fulls TurnScalar with a value from 0 to maxturnscalar

'Sub PutMovement()
'Corrects for turn values over 500 by applying to other motor and uses putmotor to tell roomba

'============================Code==========================

'----------------------------------------------------------------------------------------
Sub GetMasterSpeed()							

SlidePot = SlidePot - SlideCenter 								'Center the slide pot value
MasterSpeed = MasterSpeed + CLng((SlidePot)\SlideScalar)		'Add/Subtract from speed based on position
If Masterspeed > 500 Then										'Bracket values							
	MasterSpeed = 500
ElseIf	MasterSpeed < 0 Then
	MasterSpeed = 0
End If

PercentSpeed = MasterSpeed\5									'Calculate speed percentage out of 100

End Sub
'------------------------------------------------------------------------------------------
Sub GetMagnitude()

Sonar1mag = (SideSonarMagnitude)\(Cint(Sonar1)^2)								'Calculate inverse of distance squared
Sonar2mag = (FrontSonarMagnitude)\(Cint(Sonar2)^2)
Sonar3mag = (FrontSonarMagnitude)\(Cint(Sonar3)^2)
Sonar4mag = (SideSonarMagnitude)\(Cint(Sonar4)^2)

If Sonar1 < Sonar4	Then														'Calculate force from obhects in front
	FrontObjectMag = (FrontObjectMagnitude)\(((Cint(Sonar2)+Cint(Sonar3))\2)^2)
Else
	FrontObjectMag = -(FrontObjectMagnitude)\(((Cint(Sonar2)+Cint(Sonar3))\2)^2)
End If

MagnitudeVector = Sonar1mag + Sonar2mag - Sonar3mag - Sonar4mag + FrontObjectMag	'Add up forces

End Sub
'-------------------------------------------------------------------------------------------
Sub PutMovement()

If LeftMotor > 500 then											'Check for individual motor overflow
	RightMotor = RightMotor - (LeftMotor - 500)					'Apply overflow to other motor (opposite direction)
	LeftMotor = 500												'Bracket overflowing motor
	If RightMotor < -500 Then									'Check for underflow of other motor
		RightMotor = -500
	End If
ElseIf RightMotor > 500 then									'Check for individual motor overflow												
	LeftMotor = LeftMotor - (RightMotor - 500)					'Apply overflow to other motor (opposite direction)
	RightMotor = 500											'Bracket overflowing motor
	If LeftMotor < -500 Then									'Check for underflow of other motor
		LeftMotor = -500
	End If
End If
	
Call PutMotor													'Apply changes to motors

End Sub
'--------------------------------------------------------------------------------------------------
Sub GetProximity()

If (Cint(Sonar1) <= SideSonarThresh) OR (Cint(Sonar4) <= SideSonarThresh) OR _		'Determine proximity alert
	(Cint(Sonar2) <= FrontSonarThresh) OR (Cint(Sonar3) <= FrontSonarThresh) OR _
		(RFIR <= SideIRThresh) OR (LFIR <= SideIRThresh) THEN
			GetProximityAlert = 1													'Flag variable
Else			
			GetproximityAlert = 0													'Deflag variable
End If

End Sub
'-----------------------------------------------------------------------------------------------------
Sub RightWallFollow()

DistanceCorrect = ((RFIR-WallFollowDistance)*DistanceFactor)					'Calculate level of distance correction

If DistanceCorrect > 6 Then														'Bracket for indward turns
	DistanceCorrect = 6
End If


If NOT (lastreading = 0) Then													'Make sure you have two data points
	If  ((RFIRraw-Lastreading) < 40) then 										
		WallFollowCorrect = (Clng((RFIRraw-LastReading))*WallFollowAngleFactor*Clng(RFIR))\100 'Calculate correction
	End If
Else
	WallFollowCorrect = 0										'If don't have two data points set correction at 0
End If

If WallFollowCorrect > WallFollowCorrectMax Then								'Bracket values
	WallFollowCorrect = WallFollowCorrectMax
ElseIf	WallFollowCorrect < -WallFollowCorrectMax Then
	WallFollowCorrect = -WallFollowCorrectMax
End If
	

LastReading = RFIRraw															'Save last data point

End Sub
'-------------------------------------------------------------------------------------------------