Option Explicit
'===================================List of Files========================================

'Main contains the main control loops
'IO contains Rooomba sensory and motor control routines
'Config contains Roomba configuration (on and off) routines
'Init contains all variables and constants (is rather convoluted do to many generations of variables)
'Sensors contains routines for nonRoomba sensors
'Control contains all calculates for corrections and wall following

'===================================List Of Functions====================================

'--Core IO---

'Function GetDanger() as byte
'Returns a 1 if there are any bumps or Drops
'Fills Bumps with 1 if left bump, 2 if right bump, 3 if both
'Fills Drops with 1 if left drop, 2 if right drop, or 4 if front drop (and any other combinations)

'Sub Getsensors() as byte
'Fills Sonar(1 to 4) (representing sonar sensors from left to right) with data in inches to closest object
'Fills LFIR and RFIR with IR data for rangefinding, RotPot with rotation pot and Slide pot with linear pot

'Sub Putmotor as byte
'Applies LeftMotor and Rightmotor to the roombas motors

'--Second level control---

'Sub GetMasterSpeed()
'Fills MasterSpeed with base speed for both motors based on slide pot over time

'Sub GetMagnitude()
'Determines forces from objects and fills MagnitudeVector with desired turn

'Sub PutMovement()
'Applies corrections to motors with overflows from one motor subtracting from the opposite motors

'Sub GetProximity()
'Fills GetProximityAlert if there is an object that should break wall following

'Sub RightWallFollow()
'Fills WallFollowCorrect with necesary corrections for wall following

'===================================Main Function============================

Sub Main()

Call ComChannels(2, 19200)					'Prep two com ports
Call InitRoomba								'Turn roomba on
Call PutPowerLED(255,0)						'Indicate roomba is on

'---------------------------------Main loop-------------------------------

Do
Call GetSensors								'Read All Sensors
Call GetMasterSpeed							'Determine base motor speed
Call GetMagnitude							'Determine push forces using sonar
Call GetProximity							'Determine closest object

If (RFIR < WallFollowIRThresh) AND (Sonar4 < WallFollowSonarThresh) AND (Twistpot < 0) AND _	'Check for wall follow
(ClearLoops > ClearLoopsThreshold) AND (GetProximityAlert = 0) Then				
	Call PutPlayLED(1)																			'Indicate wall follow
	Call RightWallFollow																		'Get WallFollowcorrect
	RightMotor = MasterSpeed + (WallFollowCorrect*Clng(PercentSpeed))\100				'Apply correction to motors
	LeftMotor = MasterSpeed - (WallFollowCorrect*Clng(PercentSpeed))\100
Else																						'If not in wall follow state
	Call PutPlayLED(0)																			'Indicate no follow
	LeftMotor = Masterspeed + (Clng(MagnitudeVector)*Clng(PercentSpeed))\100					'Apply forces to motors
	RightMotor = Masterspeed - (Clng(MagnitudeVector)*Clng(PercentSpeed))\100
	If NOT ((MagnitudeVector < -150) OR (MagnitudeVector > 150)) Then						'Check for handle twist
		LastReading = 0
		RightMotor = RightMotor + (Clng(Twistpot)*TwistPotFactor*Clng(PercentSpeed))\10000	'Turn robot by twist
		LeftMotor = LeftMotor - (Clng(Twistpot)*TwistPotFactor*Clng(PercentSpeed))\10000
	End If
End If



If (RFIR < WallFollowIRThresh) AND (Sonar4 < WallFollowSonarThresh) Then		'Is object to side
	ClearLoops = ClearLoops + 1							'Incriment counter used to determine if should wall follow													
Else 
	Clearloops = 0										'Reset counter						
End If

If GetDanger = 1 Then									'Check for bumps and edges
	Exit Do												'cease and desist
End If

Call PutMovement																'Apply corrections to motors

Loop

'-------------------------------End Main loop-------------------


End Sub










