Option Explicit


'-----------------------Motor Control Subroutines-------------------
Sub PutMotor()

If RightMotor < 0 then								'If speed is negative		
	RightMotor = (65535 + RightMotor) + 1			'Convert to 2's compliment
End If

Motor1Low = cByte(RightMotor mod 256)				'seperate low byte
Motor1High = cByte(RightMotor \ 256)				'seperate high byte

If LeftMotor < 0 then								'If speed is negative																
	LeftMotor = (65535 + LeftMotor) + 1				'Convert to 2's compliment
End If

Motor2Low = cByte(LeftMotor mod 256)				'seperate low byte
Motor2High = cByte(LeftMotor \ 256)					'seperate high byte

Data(1) = 145							'Motor Speed Direct		
Data(2) = Motor1High 					
Data(3) = motor1Low 					
Data(4) = Motor2High 					
Data(5) = Motor2Low 					
Call PutQueue(OQ, data, 5) 				'placing lowest bit first of array into the Roomba
End Sub
'---------------------------------------------------------------------


'------------------------------Sensory Subroutines------------------------------
Function GetDanger() as byte

Call ClearQueue(IQ)

Data(1) = 149								
Data(2) = 5
Data(3) = 7
Data(4) = 9
Data(5) = 10
Data(6) = 11
Data(7) = 12
Call PutQueue(OQ, Data, 7) 					
Call GetQueue(IQ, DataIn(1), 1, 0.2, erflag)
Call GetQueue(IQ, DataIn(2), 1, 0.2, erflag)
Call GetQueue(IQ, DataIn(3), 1, 0.2, erflag)
Call GetQueue(IQ, DataIn(4), 1, 0.2, erflag)
Call GetQueue(IQ, DataIn(5), 1, 0.2, erflag)

BumpRight = DataIn(1) Mod 2
BumpLeft = DataIn(1) Mod 4 - BumpRight
WheelDropRight = DataIn(1) Mod 8 - BumpLeft - BumpRight
WheelDropLeft = DataIn(1) Mod 16 - WheeldropRight - BumpLeft - BumpRight
WheelDropCenter = DataIn(1) Mod 32 - WheeldropLeft - WheeldropRight - BumpLeft - BumpRight

GetDanger = 0
If DataIn(1) <> 0 OR (DataIn(2) = 1) OR (DataIn(3) = 1) OR (DataIn(4) = 1) OR (DataIn(5) = 1) then
	GetDanger = 1
End If

Bumps = 0
If BumpLeft <> 0 Then
	Bumps = Bumps + 1
End If
If BumpRight <> 0 Then
	Bumps = Bumps + 2
End If

Drops = 0
If (WheelDropLeft <> 0) OR (DataIn(2) = 1) Then
	Drops = Drops + 1
End If
If (WheelDropRight <> 0) OR (DataIn(5) = 1) Then
	Drops = Drops + 2
End If
If (WheelDropCenter = 1) OR (DataIn(3) = 1) OR (DataIn(4) = 1) Then
	Drops = Drops + 4
End If

End Function



Sub GetEncoders()

Call ClearQueue(IQ)

Data(1) = 142								
Data(2) = 19
Call PutQueue(OQ, Data, 2) 
Call GetQueue(IQ, DataIn(1), 1, 0.2, erflag)
Call GetQueue(IQ, DataIn(2), 1, 0.2, erflag)

Distance = Cint((DataIn(1)))*256+Cint((DataIn(2)))

Call ClearQueue(IQ)

Data(1) = 142								
Data(2) = 20
Call PutQueue(OQ, Data, 2) 
Call GetQueue(IQ, DataIn(1), 1, 0.2, erflag)
Call GetQueue(IQ, DataIn(2), 1, 0.2, erflag)

Angle = Cint((DataIn(1)))*256+Cint((DataIn(2)))

End Sub

'--------------------------------------------------------------------

'-----------------------Output Subroutines-------------------------------

Sub PutPlayLED(ByVal Desired as byte)
If Desired <> 0 Then
	Desired = 2
End If
Data(1) = 139 						
Data(2) = Desired 						
Data(3) = PowerLEDColor
Data(4) = PowerLED

Call PutQueue(OQ, data, 4) 	
PlayLED = Desired
End Sub

Sub PutPowerLed(ByVal Desired as byte, ByVal Color as Byte)
Data(1) = 139 						
Data(2) = PlayLED						
Data(3) = Color
Data(4) = Desired

Call PutQueue(OQ, data, 4) 		
PowerLED = Desired
PowerLEDColor = Color
End Sub