﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace RocketClac
{
    public partial class ApplicationScreen : Form
    {
        public ApplicationScreen()
        {
            InitializeComponent();
            SliderBar.Visible = false;
            panel_WelcomeScreen.BringToFront();
        }

        private void button5_Click(object sender, EventArgs e)
        {
            Environment.Exit(0);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            this.WindowState = FormWindowState.Minimized;
        }

        private void ExitBtn_MouseMove(object sender, MouseEventArgs e)
        {
            ExitBtn.ForeColor = Color.Aquamarine;
        }

        private void ExitBtn_MouseLeave(object sender, EventArgs e)
        {
            ExitBtn.ForeColor = Color.White;
        }

        private void button4_MouseMove(object sender, MouseEventArgs e)
        {
            button4.ForeColor = Color.Aquamarine;
        }

        private void button4_MouseLeave(object sender, EventArgs e)
        {
            button4.ForeColor = Color.White;
        }

        private void ImportBtn_MouseMove(object sender, MouseEventArgs e)
        {
            ImportBtn.ForeColor = Color.Aquamarine;
        }

        private void ImportBtn_MouseLeave(object sender, EventArgs e)
        {
            ImportBtn.ForeColor = Color.White;
        }

        private void HeightBtn_MouseMove(object sender, MouseEventArgs e)
        {
            HeightBtn.ForeColor = Color.Aquamarine;
        }

        private void HeightBtn_MouseLeave(object sender, EventArgs e)
        {
            HeightBtn.ForeColor = Color.White;
        }

        private void SpeedBtn_MouseMove(object sender, MouseEventArgs e)
        {
            SpeedBtn.ForeColor = Color.Aquamarine;
        }

        private void SpeedBtn_MouseLeave(object sender, EventArgs e)
        {
            SpeedBtn.ForeColor = Color.White;
        }

        private void ImportBtn_Click(object sender, EventArgs e)
        {
            panel_ImportScreen.BringToFront();
            SliderBar.Visible = true;           
            SliderBar.Width = ImportBtn.Width;
            SliderBar.Left = ImportBtn.Left;
        }

        private void HeightBtn_Click(object sender, EventArgs e)
        {
            panel_HeightScreen.BringToFront();
            SliderBar.Visible = true;
            SliderBar.Width = HeightBtn.Width;
            SliderBar.Left = HeightBtn.Left;
        }

        private void SpeedBtn_Click(object sender, EventArgs e)
        {
            SliderBar.Visible = true;
            SliderBar.Width = SpeedBtn.Width;
            SliderBar.Left = SpeedBtn.Left;
        }

        private void DataBtn_Click(object sender, EventArgs e)
        {
            panel_DataScreen.BringToFront();
            SliderBar.Visible = true;
            SliderBar.Width = DataBtn.Width;
            SliderBar.Left = DataBtn.Left;
        }

        private void DataBtn_MouseMove(object sender, MouseEventArgs e)
        {
            DataBtn.ForeColor = Color.Aquamarine;
        }

        private void DataBtn_MouseLeave(object sender, EventArgs e)
        {
            DataBtn.ForeColor = Color.White;
        }



        private void BtnImport_Click(object sender, EventArgs e)
        {
            /*using (OpenFileDialog ofd = new OpenFileDialog() { Filter = "TXT|*.txt", ValidateNames = true, Multiselect = false })
            {
                if (ofd.ShowDialog() == DialogResult.OK)
                {
                    RocketDataView.DataSource = Import.ImportTXTFile(ofd.FileName);
                }
            }
            */
        }

        private void button1_MouseMove(object sender, MouseEventArgs e)
        {
            btnImport.ForeColor = Color.Aquamarine;
        }

        private void btnImport_MouseLeave(object sender, EventArgs e)
        {
            btnImport.ForeColor = Color.White;
        }

        private void btnImport_Click_1(object sender, EventArgs e)
        {
            using (OpenFileDialog ofd = new OpenFileDialog() { Filter = "TXT|*.txt", ValidateNames = true, Multiselect = false })
            {
                try
                {
                    if (ofd.ShowDialog() == DialogResult.OK)
                    {
                        dataGridView.DataSource = Import.ImportTXTFile(ofd.FileName);

                        foreach (DataGridViewRow row in dataGridView.Rows)
                        {
                            double temp = Convert.ToDouble(row.Cells[dataGridView.Columns[1].Index].Value);
                            double pressur = Convert.ToDouble(row.Cells[dataGridView.Columns[2].Index].Value);

                            row.Cells[dataGridView.Columns[3].Index].Value = RocketCalc.Height(pressur,temp);

                            double Height_Start_Calc = Convert.ToDouble(dataGridView.Rows[dataGridView.Rows[0].Index].Cells[dataGridView.Columns[3].Index].Value);
                            double Height_Actual_Calc = Convert.ToDouble(row.Cells[dataGridView.Columns[3].Index].Value);

                            row.Cells[dataGridView.Columns[4].Index].Value= RocketCalc.ReeleHeight(Height_Start_Calc,Height_Actual_Calc);

                            //double TimeOne_Datagrid = Convert.ToDouble(dataGridView.Rows[dataGridView.Rows[0].Index].Cells[dataGridView.Columns[0].Index].Value);
                            //double TimeTwo_Datagrid = Convert.ToDouble(dataGridView.Rows[dataGridView.Rows[1].Index].Cells[dataGridView.Columns[0].Index].Value);
                            //double HeightOne_Datagrid = Convert.ToDouble(row[-1].Cells[dataGridView.Columns[3].Index].Value);

                            //row.Cells[dataGridView.Columns[5].Index].Value = RocketCalc.Speed(;
                        }
                    }
                    MessageBox.Show("Your data has successfully been transferred. Check them out!", "Message", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, "Messege", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }

            chart_Height.Series["Height"].XValueMember = "Time";
            chart_Height.Series["Height"].YValueMembers = "Real_height";
            chart_Height.DataSource = dataGridView.DataSource;
            chart_Height.DataBind();

            textBox_MaxHeight.Text = (from DataGridViewRow row in dataGridView.Rows
                                      where row.Cells[4].FormattedValue.ToString() != string.Empty
                                      select Convert.ToDouble(row.Cells[4].FormattedValue)).Max().ToString() + " meters";
        }
    }
}
