//
//  ManualController.h
//  Roboticcccccc
//
//  Created by Timothy Chong on 1/23/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Motor.h"
#import "Locations.h"


@interface ManualController : NSObject <NSTextFieldDelegate> {
    NSMutableArray * locals;
    double baseAngle,bottomAngle,middleAngle,topAngle;
    IBOutlet NSTextField * baseText;
    IBOutlet NSTextField * bottomText;
    IBOutlet NSTextField * middleText;
    IBOutlet NSTextField * topText;
    IBOutlet NSTextField * count;
    IBOutlet NSButton * grip;
    IBOutlet NSStepper * baseStep;
    IBOutlet NSStepper * bottomStep;
    IBOutlet NSStepper * middleStep;
    IBOutlet NSStepper * topStep;

    int size;
    int counter;
    double BASE_MAX;
    double BASE_MIN;
    double BOTTOM_MAX;
    double BOTTOM_MIN;
    double MIDDLE_MAX;
    double MIDDLE_MIN;
    double TOP_MIN;
    double TOP_MAX;
    NSTimer *timer;
    NSMutableString * serialPort;
    Motor * base;
    Motor * bottom;
    Motor * middle;
    Motor * top;
    BOOL Gripping;
}

-(IBAction)gripperClicked:(id)sender;
- (void)controlTextDidEndEditing:(NSNotification *)aNotification;
-(IBAction)baseClicked:(id)sender;
-(IBAction)bottmClicked:(id)sender;
-(IBAction)middleClicked:(id)sender;
-(IBAction)topClicked:(id)sender;
-(void) nextStep;
-(IBAction)start:(id)sender;
-(IBAction)stop:(id)sender;
-(IBAction)step:(id)sender;
-(IBAction)radioRightClicked:(id)sender;
-(IBAction)radioLeftClicked:(id)sender;
-(void) gripperOn;
-(void) gripperOff;
-(void) addLocations;
@end
