/*
RFduino GE G35 Christmas Lights by Matt Schoenholz @ Microsoft
Set 1 random bulb at a time
For use with RFduino Colorwheel App or LED Button App
www.RFduino.com
*/

#include <RFduinoBLE.h>
#include <G35String.h>

// Total # of lights on string (usually 50, 48, or 36). Maximum is 63, because
// the protocol uses 6-bit addressing and bulb #63 is reserved for broadcast
// messages.
#define LIGHT_COUNT (50)

// Arduino pin number. Pin 13 will blink the on-board LED.
#define G35_PIN (6)

G35String lights(G35_PIN, LIGHT_COUNT);

void setup() {
  pinMode(G35_PIN, OUTPUT);
  lights.enumerate();
  //lights.do_test_patterns();
  lights.fill_color(0, LIGHT_COUNT, G35::MAX_INTENSITY, COLOR_INDIGO);
  RFduinoBLE.advertisementData = "LIGHTS:)";
  RFduinoBLE.begin();
}

void loop() {
  RFduino_ULPDelay(INFINITE);
}

void RFduinoBLE_onConnect() {
  // the default starting color on the iPhone is white
  // set GE Color Effects white on connection
  lights.fill_color(0, LIGHT_COUNT, G35::MAX_INTENSITY, COLOR_WHITE);

}

void RFduinoBLE_onDisconnect() {
  // turn all GE Color Effects leds off on disconnect
  lights.fill_color(0, LIGHT_COUNT, G35::MAX_INTENSITY, COLOR_BLACK);

}

void RFduinoBLE_onReceive(char *data, int len) {
  // each transmission should contain an RGB triple
  if (len >= 1)
  {
    
    // set color for GE Color Effects
    lights.fill_random_max(0, LIGHT_COUNT, G35::MAX_INTENSITY);
  }
}
