//LED TEST 2 w/ 74HC595
//by Bwrussell 2013
//http://www.instructables.com/id/Quality-of-Life-Meter/

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
*/

//74HC595-Arduino Interface Pin Definitions
//Pin connected to ST_CP of 74HC595
int latchPin = 8;
//Pin connected to SH_CP of 74HC595
int clockPin = 12;
//Pin connected to DS of 74HC595
int dataPin = 11;
//Pin connected to the sweep pin of the pot
#define potPin A5

//arrays that hold the LED states for each pot position, one for each 595
int ledStatesA[] = {1,2,6,14,30,62,126,254,254,254,254,254};
int ledStatesB[] = {0,0,0,0,0,0,0,0,1,3,7,15};

//Variable Defs
int knobPosition;

void setup() {
  //Start Serial for debuging purposes	
  Serial.begin(9600);
  //set pins to output because they are addressed in the main loop
  pinMode(latchPin, OUTPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(dataPin, OUTPUT);

}

void loop(){
  knobPosition = potRead();
  
  digitalWrite(latchPin, 0);
  //send data to the second 595 (8-11)
  shiftOut(dataPin, clockPin, ledStatesB[knobPosition]); 
  //cosend data to the first 595 (0-7)
  shiftOut(dataPin, clockPin, ledStatesA[knobPosition]);
  //return the latch pin high to signal chip that it 
  //no longer needs to listen for information
  digitalWrite(latchPin, 1);
}

void shiftOut(int myDataPin, int myClockPin, byte myDataOut) {
  // This shifts 8 bits out MSB first, 
  //on the rising edge of the clock,
  //clock idles low

//internal function setup
  int i=0;
  int pinState;
  pinMode(myClockPin, OUTPUT);
  pinMode(myDataPin, OUTPUT);

 //clear everything out just in case to
 //prepare shift register for bit shifting
  digitalWrite(myDataPin, 0);
  digitalWrite(myClockPin, 0);


  for (i=7; i>=0; i--)  {
    digitalWrite(myClockPin, 0);


    if ( myDataOut & (1<<i) ) {
      pinState= 1;
    }
    else {	
      pinState= 0;
    }

    //Sets the pin to HIGH or LOW depending on pinState
    digitalWrite(myDataPin, pinState);
    //register shifts bits on upstroke of clock pin  
    digitalWrite(myClockPin, 1);
    //zero the data pin after shift to prevent bleed through
    digitalWrite(myDataPin, 0);
  }

  //stop shifting
  digitalWrite(myClockPin, 0);
}

// Function for reading and segmanting the pot input
int potRead () {
  int potRaw = 0;
  //read in the raw pot position, averaging over 5 samples
  for (int i=0; i<5; i++){
    potRaw = potRaw + analogRead(potPin);
  }
  potRaw = potRaw/5;
  //segment the raw data into 12 equal segmants, returns a value 0-11
  int potPosition = potRaw / 60; //Use 60 for 3.3V, 93 for 5V across the pot
  //send the current segment to the main loop
  return potPosition ;
}
