/*
 * Decompiled with CFR 0.152.
 */
package org.cad.ddd;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cad.ddd.Loader;

public class Main
extends JFrame
implements ItemListener {
    private int FILE_COUNT = 29;
    private static final long serialVersionUID = 1L;
    private static Path workDir;
    private Path dimensionFile;
    private JButton buttonSelect = new JButton("Samenpakken");
    private JCheckBox chkBox1 = new JCheckBox("Magnum Classic");
    private JCheckBox chkBox2 = new JCheckBox("Standaard");
    private JCheckBox chkBox3 = new JCheckBox("Cornetto");
    private JCheckBox chkBox4 = new JCheckBox("Cornetto Mini");
    private JCheckBox chkBox5 = new JCheckBox("Cornetto Klein");
    private JCheckBox chkBox6 = new JCheckBox("Cornetto Groot");
    private JCheckBox chkBox7 = new JCheckBox("Ijsbeker 130ml");
    private JCheckBox chkBox8 = new JCheckBox("Ijsbeker 245ml");
    private JCheckBox chkBox9 = new JCheckBox("Ijsbeker 360ml");
    private JCheckBox chkBox10 = new JCheckBox("Calippo");
    private JCheckBox chkBox11 = new JCheckBox("Twister");
    private JCheckBox chkBox12 = new JCheckBox("Twister Klein");
    private JCheckBox chkBox13 = new JCheckBox("Twister Groot");
    private JComboBox<String> dimension = new JComboBox<String>(new String[]{"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25"});
    private JTextPane text = new JTextPane();
    private JTextPane text2 = new JTextPane();
    private List<JCheckBox> boxes = new ArrayList<JCheckBox>();
    private Loader loader;

    public Main(Loader l) {
        super("Ijsjeshulp Selector 3000");
        this.setLayout(new FlowLayout(0, 10, 10));
        this.loader = l;
        this.boxes.add(this.chkBox1);
        this.boxes.add(this.chkBox2);
        this.boxes.add(this.chkBox3);
        this.boxes.add(this.chkBox4);
        this.boxes.add(this.chkBox5);
        this.boxes.add(this.chkBox6);
        this.boxes.add(this.chkBox7);
        this.boxes.add(this.chkBox8);
        this.boxes.add(this.chkBox9);
        this.boxes.add(this.chkBox10);
        this.boxes.add(this.chkBox11);
        this.boxes.add(this.chkBox12);
        this.boxes.add(this.chkBox13);
        try {
            workDir = Files.createTempDirectory("ijsjeshulp", new FileAttribute[0]);
            Files.createDirectory(Paths.get(workDir + "/diameters", new String[0]), new FileAttribute[0]);
            Files.createDirectory(Paths.get(workDir + "/typen", new String[0]), new FileAttribute[0]);
            workDir.toFile().deleteOnExit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.downloadFile("https://www.dropbox.com/s/2xbxsz3m49vbm2o/10.stl?dl=1", "diameters/10.stl");
        this.downloadFile("https://www.dropbox.com/s/9zeg0892blzevfg/11.stl?dl=1", "diameters/11.stl");
        this.downloadFile("https://www.dropbox.com/s/bc9qlscse6ufhut/12.stl?dl=1", "diameters/12.stl");
        this.downloadFile("https://www.dropbox.com/s/tyhgfmonrqm5q7q/13.stl?dl=1", "diameters/13.stl");
        this.downloadFile("https://www.dropbox.com/s/jja9y85xreelets/14.stl?dl=1", "diameters/14.stl");
        this.downloadFile("https://www.dropbox.com/s/g51wiwagl7f2gqx/15.stl?dl=1", "diameters/15.stl");
        this.downloadFile("https://www.dropbox.com/s/gpbqfn5x9pibwuk/16.stl?dl=1", "diameters/16.stl");
        this.downloadFile("https://www.dropbox.com/s/uwj76uf6lki22t4/17.stl?dl=1", "diameters/17.stl");
        this.downloadFile("https://www.dropbox.com/s/bmkx4euzmbj01ub/18.stl?dl=1", "diameters/18.stl");
        this.downloadFile("https://www.dropbox.com/s/lua864t1pntd1zi/19.stl?dl=1", "diameters/19.stl");
        this.downloadFile("https://www.dropbox.com/s/o3vbd5l7u1lxq80/20.stl?dl=1", "diameters/20.stl");
        this.downloadFile("https://www.dropbox.com/s/mpb2jfj8q9q5iw4/21.stl?dl=1", "diameters/21.stl");
        this.downloadFile("https://www.dropbox.com/s/m71hwny1kpwqhrw/22.stl?dl=1", "diameters/22.stl");
        this.downloadFile("https://www.dropbox.com/s/qlu739eiwddc549/23.stl?dl=1", "diameters/23.stl");
        this.downloadFile("https://www.dropbox.com/s/8yl5y7984wc7eq7/24.stl?dl=1", "diameters/24.stl");
        this.downloadFile("https://www.dropbox.com/s/pb0tl6ejx863ygx/25.stl?dl=1", "diameters/25.stl");
        this.downloadFile("https://www.dropbox.com/s/p5c5lc6isbazgwa/Calippo.stl?dl=1", "typen/Calippo.stl");
        this.downloadFile("https://www.dropbox.com/s/185qthrzfu00f3x/Cornetto%20Groot.stl?dl=1", "typen/Cornetto Groot.stl");
        this.downloadFile("https://www.dropbox.com/s/oezqzkvhdz45x6j/Cornetto%20Klein.stl?dl=1", "typen/Cornetto Klein.stl");
        this.downloadFile("https://www.dropbox.com/s/p9jtjb3dk0raudg/Cornetto%20Mini.stl?dl=1", "typen/Cornetto Mini.stl");
        this.downloadFile("https://www.dropbox.com/s/ltthy5allaw82t5/Cornetto.stl?dl=1", "typen/Cornetto.stl");
        this.downloadFile("https://www.dropbox.com/s/0qj24jp8bz30kjv/Ijsbeker%20130ml.stl?dl=1", "typen/Ijsbeker 130ml.stl");
        this.downloadFile("https://www.dropbox.com/s/pfqja14depcco5a/Ijsbeker%20245ml.stl?dl=1", "typen/Ijsbeker 245ml.stl");
        this.downloadFile("https://www.dropbox.com/s/ec99obpux1uz9nw/Ijsbeker%20360ml.stl?dl=1", "typen/Ijsbeker 360ml.stl");
        this.downloadFile("https://www.dropbox.com/s/mon9b109ahz094d/Magnum%20Classic.stl?dl=1", "typen/Magnum Classic.stl");
        this.downloadFile("https://www.dropbox.com/s/2gfcj9qqdi9jxqi/Standaard.stl?dl=1", "typen/Standaard.stl");
        this.downloadFile("https://www.dropbox.com/s/1zhnlf8937y9r8d/Twister%20Groot.stl?dl=1", "typen/Twister Groot.stl");
        this.downloadFile("https://www.dropbox.com/s/l21a77vbdqg4nrf/Twister%20Klein.stl?dl=1", "typen/Twister Klein.stl");
        this.downloadFile("https://www.dropbox.com/s/42xn9j0p3c20ndm/Twister.stl?dl=1", "typen/Twister.stl");
        this.setDimensionFile(this.dimension.getItemAt(0).toString());
        this.dimension.setEditable(false);
        this.chkBox1.setSelected(true);
        this.text.setText("Kies uw duimmaat [in mm]:");
        this.text.setEditable(false);
        this.text2.setText("Selecteer ijstypen:");
        this.text2.setEditable(false);
        this.buttonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Runtime.getRuntime().exec("explorer.exe /select," + Main.this.buildZip());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Main.this.dispose();
            }
        });
        this.dimension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Main.this.setDimensionFile(Main.this.dimension.getSelectedItem().toString());
            }
        });
        JPanel panel2 = new JPanel(new GridLayout(0, 1));
        panel2.add(this.text);
        panel2.add(this.dimension);
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.add(this.text2);
        int i = 0;
        while (i < this.boxes.size()) {
            panel.add(this.boxes.get(i));
            ++i;
        }
        this.add(panel2);
        this.add(panel);
        this.add(this.buttonSelect);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
    }

    public void downloadFile(String url, String destination) {
        try {
            URL website = new URL(url);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(workDir + "/" + destination);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
        }
        catch (Exception e) {
            System.out.println("Couldn't download: " + url);
        }
        this.loader.updateState(100.0f / (float)this.FILE_COUNT);
    }

    public String buildZip() throws IOException {
        File zipfile = new File(workDir + "/Resultaat.zip");
        ArrayList<File> files = new ArrayList<File>();
        files.add(new File(this.dimensionFile.toString()));
        int i = 0;
        while (i < this.boxes.size()) {
            if (this.boxes.get(i).isSelected()) {
                files.add(new File(workDir + "/typen/" + this.boxes.get(i).getText() + ".stl"));
            }
            ++i;
        }
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
            int i2 = 0;
            while (i2 < files.size()) {
                int len;
                FileInputStream in = new FileInputStream(((File)files.get(i2)).getCanonicalFile());
                out.putNextEntry(new ZipEntry(((File)files.get(i2)).getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                ++i2;
            }
            out.close();
            return zipfile.getPath().toString();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    public void setDimensionFile(String number) {
        this.dimensionFile = Paths.get(workDir + "/diameters/" + number + ".stl", new String[0]);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Loader l = new Loader();
                l.setVisible(true);
                l.update(l.getGraphics());
                new Main(l).setVisible(true);
                l.dispose();
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }
}

