#include <Wire.h>           
#include "data.h"
#define I2C_ADDR 0x74
uint8_t        page = 0;
const uint8_t *ptr  = anim;
uint8_t        img[9 * 16];
void writeRegister(uint8_t n) {
  Wire.beginTransmission(I2C_ADDR);
  Wire.write(n);
}
void pageSelect(uint8_t n) {
  writeRegister(0xFD);
  Wire.write(n);
  Wire.endTransmission();
}
void setup() {
  uint8_t i, p, byteCounter;
  Wire.begin();
  pageSelect(0x0B);
  writeRegister(0);
  for(i=0; i<13; i++) Wire.write(10 == i);
  Wire.endTransmission();
  for(p=0; p<2; p++) {
    pageSelect(p);
    writeRegister(0);
    for(i=0; i<18; i++) Wire.write(0xFF);
    for(byteCounter = i+1; i<0xB4; i++) {
      Wire.write(0);
      if(++byteCounter >= 32) {
        byteCounter = 1;
        Wire.endTransmission();
        writeRegister(i);
      }
    }
    Wire.endTransmission();
  } 
}
void loop() {
  uint8_t  a, x1, y1, x2, y2, x, y;
  pageSelect(0x0B);
  writeRegister(0x01);
  Wire.write(page);
  Wire.endTransmission();
  page ^= 1;
  a = pgm_read_byte(ptr++);
  if(a >= 0x90) {
    ptr = anim;
    a   = pgm_read_byte(ptr++);
  }
  x1 = a >> 4;
  y1 = a & 0x0F;
  a  = pgm_read_byte(ptr++);
  x2 = a >> 4;
  y2 = a & 0x0F;
  for(x=x1; x<=x2; x++) {
    for(y=y1; y<=y2; y++) img[(x << 4) + y] = pgm_read_byte(ptr++);
  }
  pageSelect(page);
  writeRegister(0x24);
  uint8_t i = 0, byteCounter = 1;
  for(uint8_t x=0; x<9; x++) {
    for(uint8_t y=0; y<16; y++) {
      Wire.write(img[i++]);
      if(++byteCounter >= 32) {
        Wire.endTransmission();
        writeRegister(0x24 + i);
      }
    }
  }
  Wire.endTransmission();
}
