#ifndef WindowStepper_h
#define WindowStepper_h

/*
	Class for running a bipolar stepper motor (Nema 8) connected with an
	H-Bridge(DRV8834) in Indexer Mode with full-step.
*/
class WindowStepper
{
	public:
		WindowStepper(int dirPin, int stepPin, int m0Pin, int m1PinPin);

		//Performs a step and waits
		void step(int length);

		//Sets the direction of the steps
		void setDirection(int direction);

		//Gets the actual direction of the steps
		int getDirection();

		//Sets the direction of the steps
		void setDelay(int delay);

		//Gets the actual direction of the steps
		int getDelay();

	private:

		//Pins for controlling the stepper
		int m_dirPin;	//Sets the direction
		int m_stepPin;	//Sets the step (LOW=Stop,HIGH=Step)
		int m_m0Pin;	//Control
		int m_m1Pin;	//Control

		//The direction of the steps
		int m_Direction;

		//Delay after a performed step
		int m_Delay;
};

#endif
