#include "Arduino.h"
#include "WindowStepper.h"


WindowStepper::WindowStepper(int dirPin, int stepPin, int m0Pin, int m1Pin)
{
	m_dirPin = dirPin;
	m_stepPin = stepPin;
	m_m0Pin = m0Pin;
	m_m1Pin = m1Pin;

	m_Direction = 0;

	pinMode(m_dirPin, OUTPUT);
	pinMode(m_stepPin, OUTPUT);
	pinMode(m_m0Pin, OUTPUT);
	pinMode(m_m1Pin, OUTPUT);
}

void WindowStepper::step(int length)
{
	//Set step pin on H-Bridge to HIGH
	digitalWrite(m_stepPin, HIGH);

	//Wait (defines the length/speed of the step)
	delay(length);

	//Set step pin on H-Bridge to LOW
	digitalWrite(m_stepPin, LOW);

	//Wait after the step
	delay(m_Delay);
}

void WindowStepper::setDirection(int direction)
{
	m_Direction = (direction == 0) ? 0:1;
	digitalWrite(m_dirPin, (m_Direction == 0) ? LOW:HIGH);
}

int WindowStepper::getDirection()
{
	return m_Direction;
}

void WindowStepper::setDelay(int delay)
{
	m_Delay = delay;
}

int WindowStepper::getDelay()
{
	return m_Delay;
}
