#include "Arduino.h"
#include "Time.h"

Time::Time()
{
	m_currentTime = 0;
	m_lastTime = 0;
	m_fElapsed = 0.0f;
}

void Time::setup()
{
	m_currentTime = millis();
	m_lastTime = m_currentTime;
}

void Time::update()
{
	m_currentTime = millis();

	m_fElapsed = (float)(m_currentTime - m_lastTime) / 1000.0f;

	m_lastTime = m_currentTime;
}

float Time::getElapsed()
{
	return m_fElapsed;
}

