//demo for PmodACL2, fan, and ping-pong ball height controller
#include <ACL2.h>
#include "DSPI.h"
const int chipSelectPin = 10;
ACL2 myACL;
int x = 0;
int y = 0;
int z = 0;
int onOff = 6; 
int maxInput = 16;
int idleValue = 0;
int idleCount = 0;
bool idleState = false;

void setup(){
  //Serial printing for debugging
//  Serial.begin(115200);
  pinMode(chipSelectPin, OUTPUT);
  pinMode(onOff, OUTPUT);
  myACL.begin(chipSelectPin);
  myACL.setZero();
  delay(100);
}

void loop(){
  x = myACL.getX(); 
  y = myACL.getY(); 
  z = myACL.getZ(); 
  
  /*  print 
  Serial.print("X: "); 
  Serial.println(x);
  Serial.print("Y: "); 
 Serial.println(y);
  Serial.print("Z: "); 
  Serial.println(z);
  Serial.println("");
  // */
  if(idleCount > 60){
    idleState = true;
    idleFloat();
    //x is rechecked at the end of idleFloat
    //to ensure we can break out of the cycle
  }
  
  //set the boundaries
  if(idleState == false){
    if(x<-1000){
      x = 0;
      heightControl(x);
    }
    else if(x>1000){
      x = maxInput;
      heightControl(x);
    }
    //set some scaling
    else{
      if(x<0){x = x* -1;}
      
  //    Serial.print("x scale: "); Serial.println(x);
      x = (double(x)/1000.0)*maxInput;
  //    Serial.print("x adj: "); Serial.println(x);
      heightControl(x);
    }
  }//END of if not in idle state
//    Serial.println("");
  if(idleValue == x){
    idleCount++;
  }
  else{
    idleCount = 0;
    idleState = false;
  }
  idleValue = x;
  
  

}//end of loop

void heightControl(int data){
  int downTime = maxInput - data;     //calculate how long the fan should be off based on how long it should be turned on
   
  int startTime = millis();      //store start time
   
  while((millis() - startTime) < 100){      //(millis() - startTime) is elapsed play time
    if(downTime != 0){
      digitalWrite(onOff, LOW);  //turn off the motor
      delay(downTime);  //Microseconds
    }
    if(data != 0){
      digitalWrite(onOff, HIGH);  //turn on the motor
      delay(data);  //Microseconds
    }
  }
}//end of heightControl

void idleFloat(){
  //float the ball in the air
  heightControl((maxInput * 0.8));
  //recheck x values to see if we're no longer idle
  if(x<-1000){x = maxInput;}
  else if(x>1000){x = maxInput;}
  else{
    if(x<0){x = x* -1;}
    x = (double(x)/1000.0)*maxInput;
  }
}
// */
