#include <ACL2.h>


/**************************************************/
/* PmodACL2 Demo                                   */
/**************************************************/
/*    Author: Samuel Lowe                         */
/*    Copyright 2014, Digilent Inc.               */
/*                                                */
/*   Made for use with chipKIT Pro MX3            */
/*   PmodACL2 on connector JC                     */
/**************************************************/
/*  Module Description:                           */
/*                                                */
/*    This module implements a demo application   */
/*    of the PmodACL2.                            */
/*                                                */
/*  Functionality:                                */
/*                                                */  
/*    This module initializes the PmodACL2        */
/*    then reads the x, y, z and temperature      */
/*    data and prints it continuosly to the       */
/*    serial monitor                      `       */
/*                                                */
/**************************************************/
/*  Revision History:                             */
/*                                                */
/*      10/14/2014(SamL): Created                 */
/*                                                */
/**************************************************/

// the sensor communicates using SPI, so include the library:
#include "DSPI.h"


bool inactDetect = false;
const int chipSelectPin = 10;

ACL2 myACL;

//initialize variables
  
  int x = 0;
  int y = 0;
  int z = 0;

void setup() {
Serial.begin(9600);
  //int test = 0;
  
  pinMode(47, OUTPUT);
  digitalWrite(47,LOW);
  // initalize the  data ready and chip select pins
  pinMode(chipSelectPin, OUTPUT);
  

  // initialize sensor
  myACL.begin(chipSelectPin);
//  Serial.println('\n');
//  Serial.println(myACL.getStatus(), BIN);
  myACL.setZero();
  delay(100);
  
  //need to setup inactivity detection, read upon wake-up
  //while reading, disregard values less than +- 100
  pinMode(2, INPUT);
  //setup interrupt on pin 2 for when inactivity is detected
  attachInterrupt(1,iISR,RISING);
}

void loop() {
  //store values into variables
  x = myACL.getX(); 
  y = myACL.getY(); 
  z = myACL.getZ(); 
  
  if(inactDetect = true){
    inactISR();
  }
  
  //print
 // Serial.print("X: "); 
  Serial.println(x);
 // Serial.print("Y: "); 
  Serial.println(y);
 // Serial.print("Z: "); 
  Serial.println(z);
  Serial.println("");
// delay(500);
}

void iISR(){
  inactDetect = true;
}

void inactISR(){
//  Serial.println("inactivity detected");
//  digitalWrite(47, HIGH);
  uint8_t inactStatus = myACL.getStatus();
  delay(1);
// Serial.println("interrupt erased");
  inactDetect = false;
}
