/**************************************************************************\
* Pinoccio Library                                                         *
* https://github.com/Pinoccio/library-pinoccio                             *
* Copyright (c) 2014, Pinoccio Inc. All rights reserved.                   *
* ------------------------------------------------------------------------ *
*  This program is free software; you can redistribute it and/or modify it *
*  under the terms of the MIT License as described in license.txt.         *
\**************************************************************************/
#include <SPI.h>
#include <Wire.h>
#include <Scout.h>
#include <GS.h>
#include <bitlash.h>
#include <lwm.h>
#include <js0n.h>
#include "Shell.h"
#include "String.h"
#include "version.h"
#include "Statistic.h"

int sensor = 3; // Analog in ---
int val = 0; // Current reading for analog pin ---
//long delta = 0l; //difference between midpoint and current reading
int avg = 0; // Running average of the wave amplitude
int calibratedAverage = 0;// an auto-calibrated value

long mostRecentFlowStartMillis = 0;
long durationInMillis = 0;
//int testCountStart = 0;
//int testCountStop = 0;


Statistic myStats;
Statistic bufferStats;
Statistic calibrationStats;

long startTimeMillis = 0;
long startBufferTimeMillis = 0;
long kMeasurementInterval = 5000;
//long kPingInterval = 200;   
float stdev = 0.0;
float stdNoFlow = 10.0;  //Sets a sensitivity threshold for baseline stdev (no flow scenario). Will only register if this number is exceeded
//int kSensitivity = (stdev+10); //mitigates ambient noise, bumps, etc
//int stdLowFlow = 20;
//int stdMedFlow = 120;
float stdHiFlow = 200.0;
float flowLow = 0.0;

//Calculate Flow Rate
float flowHigh = 1.7; //max flow rate in gpm. Fill a one gallon jug at max flow and timing it with a stopwatch. (60/(# secs to fill) Record stdev.
float flowGPMTotal = 0;

  bool isFlowing = false;
  bool flowDetected = false;
  long kTrialInterval = 1000;
  int stdSample = 0;

int count = 0;
int calibrationCount = 0;
int calibrationReadings = 3000;
int isCalibrated = false;
int legitimateFlowStarted = false;
int successfulAdjacentBufferMeasurements=0;

void setup() {
  Scout.setup(SKETCH_NAME, SKETCH_REVISION, SKETCH_BUILD);
  // Add custom setup code here
  //avg = MIDPOINT;
  startTimeMillis = millis();
  startBufferTimeMillis = millis();
  myStats.clear();
  bufferStats.clear();
  calibrationStats.clear();
  //Shell.eval("function lightup {message.scout(1,1);led.sethex(\"FF0000\");}");
  //Shell.eval("function darken { message.scout(1,0);led.sethex(\"00C5CD\");}");
  Shell.eval("led.off");
}

void loop() {
  Scout.loop();
 
  val = analogRead(sensor);
  
  if (!isCalibrated) {
    // don't let values through until unit has been calibrated 
    calibrationStats.add(val);
    calibrationCount ++;
    if (calibrationCount < calibrationReadings) {
        return;
    } else {
        // calibration is ready to be averaged.
       calibratedAverage = calibrationStats.average();
       isCalibrated = true;
       Serial.print("Calibration obtained at ");
       Serial.println(calibratedAverage);
    }
  }
  
  // interrogate the flow to filter out spikes.  
  // during interrogation, simple pass the calibration average through to the main stats.
  if (!legitimateFlowStarted) {
    // flow hasn't started yet. send baseline vals to the main stats collection.
 
    bufferStats.add(val);
    if ((millis() - startBufferTimeMillis) > kTrialInterval) {  
      // measure the stdDev of the buffer. 
      int bufferStd = bufferStats.pop_stdev();
      if (bufferStd > stdNoFlow) {
         //flow detected
         successfulAdjacentBufferMeasurements++; 
        Serial.print("Flow detected. Success count: ");
        Serial.println(successfulAdjacentBufferMeasurements);
      } else {
         // start the counter over.  this var must reach 2 in order to be let through. That means, a flow must persist above stopping for two measurement cycles before being called legit. 
         successfulAdjacentBufferMeasurements = 0;
         Serial.println("Flow low. Count started over.");
      }
      // start the buffer clock over
      bufferStats.clear();
      startBufferTimeMillis=millis();    
    }
    
   if (successfulAdjacentBufferMeasurements >= 3) {
       legitimateFlowStarted = true;
       Serial.println("Legitimate flow started");
       
       // turn on led.
       Shell.eval("led.setrgb(0, 0, 255)");
       Shell.eval("led.on");
       
   } else {
       // flow is still not legitimate. pass baseline value
       val = calibratedAverage;
   }
    
  }  
 
 // the main stats collection will only get a) nothing during calibration, b) baseline values during calibration, or c) actual values when the flow is legitimate.
 myStats.add(val);
 count++;

  stdev = myStats.pop_stdev();
  
   if (stdev < stdNoFlow) {
        // the flow has fallen beneath the low threshold. flow stopped.
        legitimateFlowStarted = false; 
        Shell.eval("led.off");  
    }
  
  
  if ((millis() - startTimeMillis) > kMeasurementInterval) {        // time to do a measurement:
     
    Serial.print(" stdev: ");
    Serial.print(stdev);
    
    if (stdev < stdNoFlow) {
        // the flow has fallen beneath the low threshold. flow stopped.
        legitimateFlowStarted = false;  
  
    } else {
      
      //calculate stdev and flowrate and sent to HQ
      float flowGPM = map (stdev, stdNoFlow, stdHiFlow, flowLow * 100.0, flowHigh * 100.0) / 100.0;
      flowGPM = constrain(flowGPM, flowLow, flowHigh);
  
      Serial.print(", \tflowrate: ");
      Serial.print(flowGPM);
  
      flowGPMTotal = flowGPMTotal + flowGPM;     // fancy shorthand version: flowGPMTotal += flowGPM;
   
      Serial.print(", \tTotal: ");
      Serial.println(flowGPMTotal);
      
      //report to hq
      String duration = String((millis() - startTimeMillis));
      String sDuration = String("duration-" + duration);
      String stringAvgFlowRate = String(flowGPM);
      String sAvgFlowRate = String("|avg_flow_rate-" + stringAvgFlowRate);
      String valueString = sDuration + sAvgFlowRate;
      Serial.print("Value String");
      Serial.println(valueString);
      Shell.eval("hq.report(\"fixture-event\", \""+valueString+"\")");
      Shell.eval("message.scout(1,0)");
    }
    //clear myStats
    myStats.clear();
    count = 0;
    startTimeMillis = millis();
  } 

}
