/* ========================================
 *
 * Copyright Andyk75, 2016
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * ========================================
*/

/* ========================================
 *  Includes
 * ======================================== */
#include <povanimation.h>
#include <device.h>
#include <stdbool.h>
#include <FreeMono21x31.h>
#include <FreeSerif31x32.h>

/* ========================================
 * Local Function Prototypes
 * ======================================== */
extern uint32  StripLights_ledArray[StripLights_ROWS][StripLights_COLUMNS];
void pova_DisplayText();
void pova_CalculateNextColor(uint8 Hue);

/* ========================================
 *  global variables
 * ======================================== */
uint32 POVCounter = 0;
uint8 ActivePOVAnimation = e_Font_FreeSerif_HSV;
uint32 POVCounterMAX = 100 ;

char teststring[250] = "Jedem Anfang wohnt ein Zauber inne. ~(H. Hesse)";
uint8 TextWriteCounter = 0;
volatile uint8 TextCounter = 0;
uint16 ColumnsCounterPerCharacterForDisplay = 0;

uint8 ColumnsPerCharacter = 0;
const uint32 *FontPointer = 0;
volatile uint32 POVA_TextColor = 0x00440000;
volatile bool LoadNextCharacter = true;
uint32 columnpointer = 0;
uint32 currentColumn = 0;
uint32 FirstNextCharacterColumn = 0xFFFFFFFF;
volatile uint8 Colorcounter = 0;
volatile hsv_color hsvcolor = { 0x0050ff00 };

bool WriteSubText = false; 

/* ========================================
 * Public Functions 
 * ======================================== */
void DisplayPOVAnimation() {
    switch(ActivePOVAnimation) {
        case e_Font_FreeMono:
            FontPointer = FreeMono21x31;
            pova_DisplayText();
            break;
        case e_Font_FreeSerif:
            FontPointer = FreeSerif31x32;
            pova_DisplayText();
            break;
        case e_Font_FreeMono_HSV:        // 3
            FontPointer = FreeMono21x31;
            pova_CalculateNextColor(Colorcounter++);
            pova_DisplayText();
            break; 
        case e_Font_FreeSerif_HSV:    // 4
            FontPointer = FreeSerif31x32;
            pova_CalculateNextColor(Colorcounter++);
            pova_DisplayText();
            break; 
        default:
            FontPointer = FreeMono21x31;
            pova_DisplayText();
            break;        
    }    
}

void POVA_SetActivePOVAnimation( uint8 NewAnimation ) {
    ActivePOVAnimation = NewAnimation;
    TextCounter = 0;
    ColumnsCounterPerCharacterForDisplay = 0;
}

void POVA_AddCharacterToText( char NewCharacter ) {
    teststring[TextWriteCounter++]=NewCharacter;
    teststring[TextWriteCounter] = '\0';    // Finish the string
}

void POVA_ClearText( ) {
    memset(teststring, 0, sizeof(teststring));
    TextWriteCounter = 0;
}

void POVA_SetTextColor( uint32 newColor ) {
    POVA_TextColor = newColor;   
    led_color newsetcolor;
    newsetcolor.c.g = (uint8)(newColor & 0x000000ff);
    newsetcolor.c.r = (uint8)((newColor>>8) & 0x000000ff);
    newsetcolor.c.b = (uint8)((newColor>>16) & 0x000000ff);
    hsvcolor = rgb_to_hsv(newsetcolor);
    Colorcounter = hsvcolor.h.h;        
}
/* ========================================
 *  Local Functions
 * ======================================== */

void pova_DisplayText() {
    uint8 i = 0;

    if( LoadNextCharacter == true ) {
        LoadNextCharacter = false;  // don't load next character until we are done with this.
        uint32 character = teststring[TextCounter]; // Get the next character from the string.
        
        if(character == 0x7E) {
            // This character '~' starts writing subtext. 
            // Only 32 LEDs are used for subtext.     
            WriteSubText = true;
            TextCounter++;
            LoadNextCharacter = true;
            return;            
        }
        
        // the null-character ends the string.
        if(character == '\0') {
            TextCounter = 0;  // Reset the Characterpointer.
            TextWriteCounter = 0;   // Reset the writepointer (anyway, just in case)
            
            // Clear Display
            Display_new_Color(0, 0, 0);
            StripLights_Trigger(1); 
            CyDelay(5);
            
            Main_ActivateAnimation( false );    // Disable the further display of text. Wait for next buttonpress
            LoadNextCharacter = true;   // Reset LoadNextCharacter for next time. If this is not done, the first character is missing.
            WriteSubText = false;      // When string ends, subtext is disabled for next display. 
            return;     // Leave the function
        }
        
        // Character 0-31 is not contained in the fonts, that is why we have to reduce the count by 32
        if( character > 0x20 ) {
            character = teststring[TextCounter] - 0x20;
        } else {    // in other cases use the blank.        
            character = 0;   
        }           

        // Columnpointer points to the first 32bit value which represents the first column of the display.
        columnpointer = FontPointer[ character ];
        // This is the first line of the next column, used for checking of end of character display! 
        FirstNextCharacterColumn = FontPointer[ character +1 ];
    }
        
    // get the current column.
    currentColumn = FontPointer[ columnpointer ];
 
    
    if( WriteSubText ) { 
       
        for( i=0; i<27; i++) {
            StripLights_ledArray[0][i] = 0; // Upper LEDs are always off
        }
            
        for(i=0; i<32 ; i++ ) {
            if( ( currentColumn & (1<<i) ) ) {
                StripLights_ledArray[0][i+27] = POVA_TextColor;
            } else {
                StripLights_ledArray[0][(i+27)] = 0;
            }        
        }                     
       
            StripLights_ledArray[0][59] = 0;
            StripLights_ledArray[0][60] = 0;
            StripLights_ledArray[0][61] = 0;
            StripLights_ledArray[0][62] = 0;
            StripLights_ledArray[0][63] = 0;
        
        // To reduce also the width of the character we skip on column.
        columnpointer++;
        
    } else {        
        // For every set bit in the currentColumn, the respective Text-Color is written to the LEDArray. 
        for(i=0; i<32 ; i++ ) {
            if( ( currentColumn & (1<<i) ) ) {
                StripLights_ledArray[0][(2*i)] = POVA_TextColor;
                StripLights_ledArray[0][(2*i)+1] = POVA_TextColor;
            } else {
                StripLights_ledArray[0][(2*i)] = 0;
                StripLights_ledArray[0][(2*i)+1] = 0;
            }        
        }     
    }
    
    // Increment to next column. 
    columnpointer++;
   
    //if the Columnpointer points to the next character, we are finished with this character. 
    if(columnpointer>=FirstNextCharacterColumn) {
        // So next time we load a new character. 
        LoadNextCharacter = true;
        // This is the counter for the characters in the string. 
        TextCounter++;
    }
}

void pova_CalculateNextColor(uint8 Hue) {
    hsvcolor.h.h = Hue;
    POVA_TextColor = (hsv_to_rgb(hsvcolor).rgb);   
}




/* [] END OF FILE */
