CON
  _clkmode = xtal1 + pll16x                           
    _xinfreq = 5_000_000
  pinDataOut = 26  
  pinClock = 27    
  
  'LED 1,3...,63 
PUB Start(LedAdress)

cognew(@entry,LedAdress) 



DAT           org

'################################################################################################################
'tested OK
entry                                                 ''SHIFTOUT Entry
        mov frqa,#0             ' unecessary
        mov phsa,#0             ' unecessary
        mov ctra,#pinDataOut    ' set the data pin
        movi ctra,#%0_00100_000 ' set the mode to NCO, single output pin
        ' set up Counter B to be the clock counter
        mov frqb,#0             ' unecessary
        mov phsb,#0             ' unecessary
        mov ctrb,#pinClock      ' set the clock pin
        movi ctrb,#%0_00100_000 ' set the mode to NCO, single output pin
        '     set up my 3 pins as outputs
        mov t,#1                ' temp = 1
        shl t,#pinDataOut       ' temp = 1 << pinDataOut
        mov dira,t              ' DIRA now has the DataOut pin as an output
        mov t,#1                ' temp = 1
        shl t,#pinClock         ' temp = 1 << pinClock
        or dira,t               ' DIRA now has both DataOut and Clock as outputs
        
        mov     run_cog2_pointer,par
        mov     Wait_pointer,par
        add     Wait_pointer,#4
        mov     offset_rot_pointer,par
        add     offset_rot_pointer,#8
       

        
        'add     offset_diff_pointer, time_diff_pointer       

              
loop          
               mov     LedPointer,    par


               
               mov     Reference_ptr, LedPointer
               add     Reference_ptr, #66
               rdlong  offset_rot,offset_rot_pointer  ' get offset for rotation  

               add     LedPointer,     offset         ' offset for beginning at the end of the BMP
               sub     LedPointer, offset_rot         ' subtract rotation offset from origin offset  
              
              
                       
               
              
              WAITPEQ low,#1       'wait for
             
              WAITPEQ high,#1               ' new round
              mov time2,cnt     
              sub time2,time1
                                      ' 
              mov time1,cnt
                                          ' 
              'calculate row delta delay
              'division loop needs 228 cnt
             
            
              mov shiftBits,#16 'ready for 16 quotient bits
:division_loop
              cmpsub time2,y wc 'if y =< x then subtract it, quotient bit into c
              rcl time2,#1 'rotate c into quotient, shift dividend
              djnz shiftBits,#:division_loop 'loop until done
              and time2,mask  'only bit 15..0
              
              max time2,max_wait   'not too high
              min time2,min_wait   '         low
              sub time2,duration_row_cnt 'subtract row time
              
              mov wait,time2   'this is the rest time to be add after row finish
              wrlong  wait, Wait_pointer 'for debugging    
              
               
               
             'start rows 

              mov     row,  #120
new_row       cmp     LedPointer,Reference_ptr wc               'BMP at beginning ?      13884 - 6*24*95
      if_c    mov     LedPointer,par               'goto end of BMP                   (13680)
      if_c    add     LedPointer,offset
             
              ' inner Loop
'-----------------------------------------------------------------------------                                  
              call    #StartFrame   
              mov     line,  #32
new_line      call    #eight_ones               '11111111
              call    #LEDout                    'blue
              add     LedPointer,    #1         '
              call    #LEDout                    'green
              add    LedPointer,    #1
              call    #LEDout                     'red
              sub     LedPointer,    #8
              
              djnz    line,#new_line
              call    #StopFrame
              
              
              mov     time5,cnt
              add     time5,wait
              waitcnt time5,#0              'wait the rest time
                                                  '
              
               cmp     row,#60 wz               'half rotation ?
       if_z    wrlong  wait,run_cog2_pointer    'then start the other (even) side  ! and commit actually wait value
              '
'-----------------------------------------------------------------------------                    
               ' inner Loop   
            
              djnz    row,#new_row
             
              wrlong  low,run_cog2_pointer      'stop the other side (not yet)
              jmp     #loop                '     Go wait for next round



'-----------------------------------------------------------------------------------------------

LEDout
              
             
              
        rdbyte  t3,LedPointer  '     Load t3 with DataValue
        mov t,#7                ' number of bits left        
        mov phsa,t3          ' start with the raw data byte
        shl phsa,#24            ' get the MSb into position 31
        'rev phsa,#0            ' do this instead of the above line for LSb first
        movi phsb,#%011000000   ' set up my clock register         
        movi frqb,#%001000000   ' start my clock line ticking!
:bit_shift_loop
        shl phsa,#1             ' move next bit into the PHSA[31] slot
        djnz t,#:bit_shift_loop ' keep going till we run out of bits
        mov frqb,#0    ' stop my clock
LEDout_ret    ret


'--------------------------------------------------------------------------------------------------

eight_ones
        mov t,#7                ' number of bits left        
        mov phsa,#255          ' start with the raw data byte
        shl phsa,#24            ' get the MSb into position 31
        'rev phsa,#0            ' do this instead of the above line for LSb first
        movi phsb,#%011000000   ' set up my clock register         
        movi frqb,#%001000000   ' start my clock line ticking!
:bit_shift_loop2
        shl phsa,#1             ' move next bit into the PHSA[31] slot
        djnz t,#:bit_shift_loop2 ' keep going till we run out of bits
        mov frqb,#0    ' stop my clock     ' stop my clock
eight_ones_ret    ret

'------------------------------------------------------------------------------------------------

StartFrame
        mov     t3,             #4            ''      
StartX4
        mov t,#7                ' number of bits left        
        mov phsa,#%00000000         ' start with the raw data byte
        shl phsa,#24            ' get the MSb into position 31
        'rev phsa,#0            ' do this instead of the above line for LSb first
        movi phsb,#%011000000   ' set up my clock register         
        movi frqb,#%001000000   ' start my clock line ticking!
:bit_shift_loop3
        shl phsa,#1             ' move next bit into the PHSA[31] slot
        djnz t,#:bit_shift_loop3 ' keep going till we run out of bits
        mov frqb,#0    ' stop my clock  ' stop my clock            ''          Restore ClockPin to original read value                       ''          Send clock pulse
        djnz    t3,             #StartX4         ''          4 times
StartFrame_ret ret


'----------------------------------------------------------------------------------------------

StopFrame
              

        mov     t3,             #4
StopX4  mov t,#7       
        mov phsa,#%11111111         ' start with the raw data byte
        shl phsa,#24            ' get the MSb into position 31
        'rev phsa,#0            ' do this instead of the above line for LSb first
        movi phsb,#%011000000   ' set up my clock register         
        movi frqb,#%001000000   ' start my clock line ticking!
:bit_shift_loop44
        shl phsa,#1             ' move next bit into the PHSA[31] slot
        djnz t,#:bit_shift_loop44 ' keep going till we run out of bits
        mov frqb,#0    ' stop my clock  ' stop my clock
        djnz    t3,             #StopX4         ''                 
StopFrame_ret ret

             
'-----------------------------------------------------------------------------------------------------
LedOff
        call    #eight_ones               '11111111    
        mov     t3,             #3
                  ''      
NullX3
        mov t,#7 
        mov phsa,#%00000000             ' start with the raw data byte
        shl phsa,#24            ' get the MSb into position 31
        'rev phsa,#0            ' do this instead of the above line for LSb first
        movi phsb,#%011000000   ' set up my clock register         
        movi frqb,#%001000000   ' start my clock line ticking!
:bit_shift_loop5
        shl phsa,#1             ' move next bit into the PHSA[31] slot
        djnz t,#:bit_shift_loop5 ' keep going till we run out of bits
        mov frqb,#0    ' stop my clock  ' stop my clock            Restore ClockPin to original read value                       ''          Send clock pulse
        djnz    t3,             #NullX3         ''          3 times

LedOff_ret    ret





'------------------------------------------------------------------------------------------------------------------------------



row                      long   0
line                     long   0

Wait                   long   0

low                      long 0
high                     long 1

Wait_pointer           long 0
LedPointer               long 0
offset                   long 23100  'BMP begin at end of fie !

t                       long    0                       ''temp variables
t1                      long    0                       ''     Used for DataPin mask      
t2                      long    0                       ''     Used for CLockPin mask    
t3                      long    0                       ''     Used to hold DataValue SHIFTIN/SHIFTOUT
t4                      long    0                       ''     Used to hold # of Bits
t5                      long    0                       ''     Used for temporary data mask
t6                      long    0                       ''     Used for Clock Delay

run_cog2                long  0
run_cog2_pointer         long 0

offset_rot_pointer      long 0
offset_rot              long 0

time1                   long 0
time2                   long 0

time5                   long 0

Reference_ptr            long 0

duration_row_cnt        long 14855 '14575 + 280 'measured in cnt, trail and error for delta 

max_wait                long 18000
min_wait                long 15000

shiftBits               long 0
y                       long %1111000000000000000000
mask                    long %0000000000000000_1111111111111111

fit


  {{

 Fast SPI Clock based on:
 
  Jonathan "lonesock" Dummer
  Testing a fast SPI clock out routine

  Use both counters in NCO single-ended mode, where the output
  pin is equal to PHSx's high bit.  Use Counter B to drive the
  clock pin, and Counter A to drive the data line.  B actually
  changes the pin automatically, while you update the Data pin
  using a series of SHL's on PHSA (we set FRQA to 0, so no up-
  dates are happening automatically).

  This is for an SPI interface where the data is latched in on
  the rising edge of the Clock line, so you want your Data pin
  to be stable before the clock pin goes high.  You might have
  to sdjust the "movi phsb,#%xxx000000" line to initialize the
  PHSB into the right state for your SPI definition.
}}