// 1602 LCD 4-bit interface
// Written by Boomer48: April 2019


#define LCD_Mode 5
#define LCD_Enable 6
#define LCD_Data4 7
#define LCD_Data5 8
#define LCD_Data6 9
#define LCD_Data7 10

#define Cmnd_Mode 0
#define Data_Mode 1

byte Reg_Select;

// Make routines globally visible
void LCD_setup();
void Init_LCD();
void Clear_LCD();
void LCD_Line1();
void LCD_Line2();
void LCD_Char_Loc(byte Location, byte Data_Byte);
void Send_Nibble(byte Data_Byte);
void Send_Byte(byte Data_Byte);

// Code goes here
void LCD_setup() {
  pinMode(LCD_Mode, OUTPUT);
  pinMode(LCD_Enable, OUTPUT);
  pinMode(LCD_Data4, OUTPUT);
  pinMode(LCD_Data5, OUTPUT);
  pinMode(LCD_Data6, OUTPUT);
  pinMode(LCD_Data7, OUTPUT);
  digitalWrite(LCD_Mode, LOW);
  digitalWrite(LCD_Enable, LOW);
  delay(1000); // wait for LCD to get ready
  Init_LCD();
}

void Init_LCD() {
  Reg_Select = Cmnd_Mode;
  Send_Nibble(0x30);
  delayMicroseconds(4100);
  Send_Nibble(0x30);
  delayMicroseconds(100);
  Send_Nibble(0x30);
  delayMicroseconds(100);
  Send_Nibble(0x20); // command 4-bit mode
  delayMicroseconds(100);
//  Send_Byte(0x20); // 16 characters, one line
  Send_Byte(0x28); // 16 characters, two lines
  delayMicroseconds(100);
  Send_Byte(0x01); // clear display
  delayMicroseconds(4100);
  Send_Byte(0x06); // entry mode, inc. DDRAM, no shift
  delayMicroseconds(100);
  Send_Byte(0x0C); // Display on, cursor off
  delayMicroseconds(100);
  Reg_Select = Data_Mode;
}

void Clear_LCD () {
  Reg_Select = Cmnd_Mode;
  Send_Byte(0x01); // clear display
  delayMicroseconds(4100);
  Reg_Select = Data_Mode;
}

void LCD_Line1() {
  Reg_Select = Cmnd_Mode;
  Send_Byte(0x80); // write at start of line1 (address 0x00)
  delayMicroseconds(100);
  Reg_Select = Data_Mode;
}

void LCD_Line2() {
  Reg_Select = Cmnd_Mode;
  Send_Byte(0xC0); // write at start of line2 (address 0x40)
  delayMicroseconds(100);
  Reg_Select = Data_Mode;
}

void LCD_Char_Loc(byte Location, byte Data_Byte) {
  Reg_Select = Cmnd_Mode;
  Send_Byte(Location); // write at specific location
  delayMicroseconds(100);
  Reg_Select = Data_Mode;
  Send_Byte(Data_Byte);
}

void Send_Nibble(byte Data_Byte) {
  byte i = 7;

  if (Reg_Select == Cmnd_Mode)
    digitalWrite(LCD_Mode, LOW);
  else // data mode
    digitalWrite(LCD_Mode, HIGH);

  digitalWrite(LCD_Data7, bitRead(Data_Byte, i));
  i--;
  digitalWrite(LCD_Data6, bitRead(Data_Byte, i));
  i--;
  digitalWrite(LCD_Data5, bitRead(Data_Byte, i));
  i--;
  digitalWrite(LCD_Data4, bitRead(Data_Byte, i));
  i--;
  digitalWrite(LCD_Enable, HIGH);
  delayMicroseconds(1);
  digitalWrite(LCD_Enable, LOW);
  delayMicroseconds(50);
}

void Send_Byte(byte Data_Byte) {
  Send_Nibble(Data_Byte); // Upper nibble first
  Send_Nibble(Data_Byte << 4);
}
