// 1602 LCD 4-bit interface
// Written by Boomer48: May 2019


#include "LCD_4Bit.h"

#define Trail_Blk 11 // ID of Trailer Block (holds keys)
#define Data_Blk 10 // ID of Data Block (holds credits)
#define Resp_TFI 0xD5 // TFI for response messages from reader

#define Def_Key1 0xFF // first byte of default key
#define Def_Key2 0xFF
#define Def_Key3 0xFF
#define Def_Key4 0xFF
#define Def_Key5 0xFF
#define Def_Key6 0xFF // last byte of default key

byte temp;
byte TFI_Found;
byte Tag_Blk_Num; // Tag Block Number
byte UID1;
byte UID2;
byte UID3;
byte UID4;
byte Checksum;
byte Cmd_Echo; // byte after TFI in response
byte Cmd_Stat; // command status in response
byte Error_Flg;
byte Junk_Num = 0; // junk number for write to tag
char ASCII[] = "0123456789ABCDEF";

void setup() {
  LCD_setup();
  Serial.begin(115200);
  Flush_RX();

  while (Serial.available() == 0)
    Send_Init();
}

void loop() {
Scan_Loop:
  Tag_Blk_Num = Data_Blk;
  Scan_Tag();
  Disp_UID(); // comment out if not needed
  Auth_Tag();

  if (Error_Flg == true)
    goto Scan_Loop;

  Auth_Msg(); // comment out if not needed

  Write_Tag();
  Send_Data();

  if (Error_Flg == true)
    goto Scan_Loop;

  Read_Tag();

  if (Error_Flg == true)
    goto Scan_Loop;

  Disp_Data();
  delay(3000);
  Done_Msg();

  // Change values to write (debug)
  Junk_Num = Junk_Num + 0x11;

  goto Scan_Loop;
}

void Flush_RX() {
  while (Serial.available() > 0)
    Serial.read(); // clear receive buffer
}

void Make_ASCII(byte BCD_Byte) {
  Send_Byte(ASCII[BCD_Byte >> 4]); // display upper nibble first
  Send_Byte(ASCII[BCD_Byte & 0x0F]);
}

void Disp_Data() {
  byte i;

  LCD_Line1();

  for (i = 0; i < 8; i++)
    Make_ASCII(Serial.read());

  LCD_Line2();

  for (i = 0; i < 8; i++)
    Make_ASCII(Serial.read());
}

// ---------------------------------------------------
// RFID Messages
// ---------------------------------------------------

void Preamble() {
  Flush_RX();
  Serial.write(0x00);
  Serial.write(0x00);
  Serial.write(0xFF);
}

void Postamble() {
  Serial.write(0x00);
  delay(100);
}

void Send_ACK() {
  Serial.write(0x00);
  Serial.write(0x00);
  Serial.write(0xFF);
  Serial.write(0x00);
  Serial.write(0xFF);
  Serial.write(0x00);
}

void Do_Cksum() {
  Checksum = (~Checksum) + 1;
  Serial.write(Checksum);
  Postamble();
}
void Send_Init() {
  Serial.write(0x55);
  Serial.write(0x55);
  Serial.write(0x00);
  Serial.write(0x00);
  Serial.write(0x00);
  Serial.write(0x00); // add more zeros if needed to wake up

  // Need to send SAM Config to get out of Low Vbat state
  Preamble();
  Serial.write(0x03);
  Serial.write(0xFD);
  Serial.write(0xD4);
  Serial.write(0x14); // SAMConfiguration
  Serial.write(0x01);
  Serial.write(0x17);
  Postamble();
}

void Scan_Tag() {
  TFI_Found = false;

  while (TFI_Found == false) {
    Preamble();
    Serial.write(0x04);
    Serial.write(0xFC);
    Serial.write(0xD4);
    Serial.write(0x4A); // InListPassiveTarget
    Serial.write(0x01); // read one card (max=2)
    Serial.write(0x00); // 106-kbps type A
    Serial.write(0xE1);
    Postamble();
    Scan_Msg();
    Find_Resp();
    Get_UID();
  }
}

void Find_Resp() {
  TFI_Found = false;

  while ((Serial.available() > 0) && (TFI_Found == false)) {
    temp = Serial.read();
    if (temp == Resp_TFI) {
      TFI_Found = true;
      Cmd_Echo = Serial.read();
      Cmd_Stat = Serial.read();
    }
  }
}

void Get_UID() {
  Serial.read();
  Serial.read();
  Serial.read();
  Serial.read();
  Serial.read();
  UID1 = Serial.read();
  UID2 = Serial.read();
  UID3 = Serial.read();
  UID4 = Serial.read();
}

// Authorize tag data sector using the defined Trailer block ID
void Auth_Tag() {
  Checksum = 0;
  Preamble();
  Serial.write(0x0F);
  Serial.write(0xF1);
  temp = 0xD4;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = 0x40;
  Serial.write(temp); // InDataExchange
  Checksum = Checksum + temp;
  temp = 0x01;
  Serial.write(temp); // number of targets
  Checksum = Checksum + temp;
  temp = 0x60;
  Serial.write(temp); // authenticate with Key A
  Checksum = Checksum + temp;
  temp = Trail_Blk;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Def_Key1;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Def_Key2;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Def_Key3;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Def_Key4;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Def_Key5;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Def_Key6;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = UID1;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = UID2;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = UID3;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = UID4;
  Serial.write(temp);
  Checksum = Checksum + temp;

  Do_Cksum();
  Find_Resp();

  if ((TFI_Found == false) || (Cmd_Stat != 0))
    Bad_Scan();
  else
    Error_Flg = false;
}

// Initiates a write to the tag
void Write_Tag() {
  Checksum = 0;
  Preamble();
  Serial.write(0x15);
  Serial.write(0xEB);
  temp = 0xD4;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = 0x40;
  Serial.write(temp); // InDataExchange
  Checksum = Checksum + temp;
  temp = 0x01;
  Serial.write(temp); // number of targets
  Checksum = Checksum + temp;
  temp = 0xA0;
  Serial.write(temp); // write block (16 bytes)
  Checksum = Checksum + temp;
  temp = Tag_Blk_Num; // block number (0-63)
  Serial.write(temp);
  Checksum = Checksum + temp;
}

void Send_Data() {
  temp = Junk_Num;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = (~Junk_Num);
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Junk_Num;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = (~Junk_Num);
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Junk_Num;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = (~Junk_Num);
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Junk_Num;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = (~Junk_Num);
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Junk_Num;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = (~Junk_Num);
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Junk_Num;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = (~Junk_Num);
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Junk_Num;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = (~Junk_Num);
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = Junk_Num;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = (~Junk_Num);
  Serial.write(temp);
  Checksum = Checksum + temp;

  Do_Cksum();
  Find_Resp();

  if ((TFI_Found == false) || (Cmd_Stat != 0))
    Bad_Write();
  else
    Error_Flg = false;
}

// Read tag data from the defined data block of the authorized sector
void Read_Tag() {
  Checksum = 0;
  Preamble();
  Serial.write(0x05);
  Serial.write(0xFB);
  temp = 0xD4;
  Serial.write(temp);
  Checksum = Checksum + temp;
  temp = 0x40;
  Serial.write(temp); // InDataExchange
  Checksum = Checksum + temp;
  temp = 0x01;
  Serial.write(temp); // number of targets
  Checksum = Checksum + temp;
  temp = 0x30;
  Serial.write(temp); // read block (16 bytes)
  Checksum = Checksum + temp;
  temp = Tag_Blk_Num; // block number (0-63)
  Serial.write(temp);
  Checksum = Checksum + temp;

  Do_Cksum();
  Find_Resp();

  if ((TFI_Found == false) || (Cmd_Stat != 0))
    Bad_Read();
  else
    Error_Flg = false;
}

// ---------------------------------------------------
// Display Messages
// ---------------------------------------------------

void Scan_Msg() {
  Clear_LCD();
  Send_Byte('R');
  Send_Byte('E');
  Send_Byte('A');
  Send_Byte('D');
  Send_Byte('Y');
  Send_Byte(' ');
  Send_Byte('T');
  Send_Byte('O');
  Send_Byte(' ');
  Send_Byte('S');
  Send_Byte('C');
  Send_Byte('A');
  Send_Byte('N');
  delay(1000);
}

void Bad_Scan() {
  Clear_LCD();
  Send_Byte('B');
  Send_Byte('A');
  Send_Byte('D');
  Send_Byte(' ');
  Send_Byte('S');
  Send_Byte('C');
  Send_Byte('A');
  Send_Byte('N');
  Error_Flg = true;
  delay(2000);
}

void Bad_Read() {
  Clear_LCD();
  Send_Byte('B');
  Send_Byte('A');
  Send_Byte('D');
  Send_Byte(' ');
  Send_Byte('R');
  Send_Byte('E');
  Send_Byte('A');
  Send_Byte('D');
  Error_Flg = true;
  delay(2000);
}

void Bad_Write() {
  Clear_LCD();
  Send_Byte('B');
  Send_Byte('A');
  Send_Byte('D');
  Send_Byte(' ');
  Send_Byte('W');
  Send_Byte('R');
  Send_Byte('I');
  Send_Byte('T');
  Send_Byte('E');
  Error_Flg = true;
  delay(2000);
}

void Disp_UID() {
  Clear_LCD();
  Send_Byte('U');
  Send_Byte('I');
  Send_Byte('D');
  Send_Byte(':');
  Send_Byte(' ');
  Make_ASCII(UID1);
  Make_ASCII(UID2);
  Make_ASCII(UID3);
  Make_ASCII(UID4);
  delay(2000);
}

void Auth_Msg() {
  Clear_LCD();
  Send_Byte('A');
  Send_Byte('U');
  Send_Byte('T');
  Send_Byte('H');
  Send_Byte('E');
  Send_Byte('N');
  Send_Byte('T');
  Send_Byte('I');
  Send_Byte('C');
  Send_Byte('A');
  Send_Byte('T');
  Send_Byte('E');
  Send_Byte('D');
  delay(2000);
}

void Done_Msg() {
  Clear_LCD();
  Send_Byte('R');
  Send_Byte('E');
  Send_Byte('M');
  Send_Byte('O');
  Send_Byte('V');
  Send_Byte('E');
  Send_Byte(' ');
  Send_Byte('T');
  Send_Byte('A');
  Send_Byte('G');
  delay(2000);
}
