#include <Wire.h>              // I2C aka TWI library
#include <Time.h>              // Time manipulation librarry
#include <DS1307RTC.h>         // RTC library
#include <Adafruit_NeoPixel.h> // NeoPixel library
#include <CapacitiveSensor.h>

CapacitiveSensor   cs_13_10 = CapacitiveSensor(13, 10);

#define PIN  3       // Which pin on the Arduino is connected to the NeoPixels?
#define NUMPIXELS 12 // How many NeoPixels are attached to the Arduino?

// When we setup the NeoPixel library, we tell it how many pixels, and which pin to use to send signals.
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

void setup()
{
  pixels.begin();          // This initializes the NeoPixel library.
  pixels.setBrightness(25);// Sets brightness of NeoPixels
  Wire.begin();            // This initializes the Wire library.
}


void loop()
{

  long sensor =  cs_13_10.capacitiveSensor(30);

  switch (sensor > 100) {
    case 1:
      FlashLightStart();
      delay(10000);
      break;
    default:
      clock1();
      break;
  }
}




