/*

  this Code Made With Love By MellBell Electronics
  9/6/2018

  In this project we are using an Ultrasonic sensor, 3 Leds(different colors), Buzzer. when the ultrasonic sensor measure distance less than 10CM
  only the blue led turns on. 
  when it measure more tan or equal 20CM blue, yellow, LED Turns on.
  when it measure more than or equal 20CM blue, yellow, red, buzzer Turns On.
  

*/


#define trigPin A1                        //define a constant called trigPin for the pin A1
#define echoPin A0                        //define a constant called echoPin for the pin A0

#define redLed 4                          //define a constant called redLed for the digital pin 4
#define yellowLed 3                       //define a constant called yellowLed for the digital pin 3
#define greenLed 2                        //define a constant called greenLed for the digital pin 2

#define buzzer A2                         //define a constant called buzzer for the pin A2

void setup() {

  pinMode(trigPin, OUTPUT);                      //set the trigPin as an OUTPUT Pin, the trigPin responsible for sending a signal to the sensor to send out the ultrasonic wave
  pinMode(echoPin, INPUT);                       //set the echoPin as an INPUT pin, the choPin responsible for receiving the wave.

  pinMode(buzzer, OUTPUT);                       //set the buzzer as an OUTPUT pin, the buzzer is responsible for making the sound.

  pinMode(redLed, OUTPUT);                       //set the redLed as an OUTPUT pin, the redLed is responsible for turning ON and OFF the redLed.
  pinMode(yellowLed, OUTPUT);                    //set the yellowLed as an OUTPUT pin, the yellowLed is responsible for turning ON and OFF the yellowLed.
  pinMode(greenLed, OUTPUT);                     //set the greenLed as an OUTPUT pin, the yellowLed is responsible for turning ON and OFF the greenLed.

  Serial.begin(9600);

}

void loop() {

  if (measuredDistance() < 10) {                          // if the distance is less than 10CM ONLY the green led will turn ON.
    digitalWrite(greenLed, HIGH);
    digitalWrite(yellowLed, LOW);
    digitalWrite(redLed, LOW);
    noTone(buzzer);
  }
  else if (measuredDistance() >= 10 && measuredDistance() < 20) {               // if the distance is greater than or equal 10CM and less than 20CM ONLY the green led and the yellow will turn ON.
    digitalWrite(greenLed, HIGH);
    digitalWrite(yellowLed, HIGH);
    digitalWrite(redLed, LOW);
    noTone(buzzer);
  }
  else if (measuredDistance() >= 20) {                        // if the distance is greater than or equal 20CM the THREE LEDs will turn ON and buzzer will make a Sound.
    digitalWrite(greenLed, HIGH);
    digitalWrite(yellowLed, HIGH);
    digitalWrite(redLed, HIGH);
    tone(buzzer, 500);
  }

  Serial.print("distance in CM is equal:  ");                  //print on the Serial Monitor   "distance in CM is equal:  "
  Serial.println(measuredDistance());                          //calling the measuredDistance function which returns the distance measured.
}

/*
  This function Takes No Arguments
  return the distance in CM which measured by the ultrasonic sensor, 
  the Data type of the returned value is (long)
  this function is responsible for sending out the ultrasonic wave and receiving it back and calculationg the distance
*/

long measuredDistance() {

  long duration, distance;
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);                                // delays are required for a succesful sensor operation.
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);                               //this delay is required
  digitalWrite(trigPin, LOW);
  duration = pulseIn(echoPin, HIGH);                   //receiving back the ultrasonic wave
  distance = (duration / 2) / 29.1;                    // convert the distance to centimeters.
  delay(2);                                            //delay 2 milliseconds to not make the buffer full which will cause a problem with the serial communication.
  return distance;
}

