/*
 * Decompiled with CFR 0.152.
 */
package neurosky;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;
import processing.core.PApplet;

public class ThinkGearSocket
implements Runnable {
    public PApplet parent;
    public Socket neuroSocket;
    public OutputStream outStream;
    public InputStream inStream;
    public BufferedReader stdIn;
    private Method attentionEventMethod = null;
    private Method meditationEventMethod = null;
    private Method poorSignalEventMethod = null;
    private Method blinkEventMethod = null;
    private Method eegEventMethod = null;
    private Method rawEventMethod = null;
    public String appName = "";
    public String appKey = "";
    private Thread t;
    private int[] raw = new int[512];
    private int index = 0;
    public static final String VERSION = "1.0";
    private boolean running = true;

    public ThinkGearSocket(PApplet pApplet, String string, String string2) {
        this(pApplet);
        this.appName = string;
        this.appKey = string2;
    }

    public ThinkGearSocket(PApplet pApplet) {
        this.parent = pApplet;
        try {
            this.attentionEventMethod = this.parent.getClass().getMethod("attentionEvent", Integer.TYPE);
        }
        catch (Exception exception) {
            System.err.println("attentionEvent() method not defined. ");
        }
        try {
            this.meditationEventMethod = this.parent.getClass().getMethod("meditationEvent", Integer.TYPE);
        }
        catch (Exception exception) {
            System.err.println("meditationEvent() method not defined. ");
        }
        try {
            this.poorSignalEventMethod = this.parent.getClass().getMethod("poorSignalEvent", Integer.TYPE);
        }
        catch (Exception exception) {
            System.err.println("poorSignalEvent() method not defined. ");
        }
        try {
            this.blinkEventMethod = this.parent.getClass().getMethod("blinkEvent", Integer.TYPE);
        }
        catch (Exception exception) {
            System.err.println("blinkEvent() method not defined. ");
        }
        try {
            this.eegEventMethod = this.parent.getClass().getMethod("eegEvent", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            System.err.println("eegEvent() method not defined. ");
        }
        try {
            this.rawEventMethod = this.parent.getClass().getMethod("rawEvent", int[].class);
        }
        catch (Exception exception) {
            System.err.println("rawEvent() method not defined. ");
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public static String version() {
        return VERSION;
    }

    public void start() throws ConnectException {
        JSONObject jSONObject;
        try {
            this.neuroSocket = new Socket("127.0.0.1", 13854);
        }
        catch (ConnectException connectException) {
            System.out.println("Oi plonker! Is ThinkkGear running?");
            this.running = false;
            throw connectException;
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this.inStream = this.neuroSocket.getInputStream();
            this.outStream = this.neuroSocket.getOutputStream();
            this.stdIn = new BufferedReader(new InputStreamReader(this.neuroSocket.getInputStream()));
            this.running = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.appName != "" && this.appKey != "") {
            jSONObject = new JSONObject();
            try {
                jSONObject.put("appName", this.appName);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            try {
                jSONObject.put("appKey", this.appKey);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.sendMessage(jSONObject.toString());
            System.out.println("appAuth" + jSONObject);
        }
        jSONObject = new JSONObject();
        try {
            jSONObject.put("enableRawOutput", true);
        }
        catch (JSONException jSONException) {
            System.out.println("raw error");
            jSONException.printStackTrace();
        }
        try {
            jSONObject.put("format", "Json");
        }
        catch (JSONException jSONException) {
            System.out.println("Json error");
            jSONException.printStackTrace();
        }
        this.sendMessage(jSONObject.toString());
        this.t = new Thread(this);
        this.t.start();
    }

    public void stop() {
        if (this.running) {
            this.t.interrupt();
            try {
                this.neuroSocket.close();
                this.inStream.close();
                this.outStream.close();
                this.stdIn.close();
                this.stdIn = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.running = false;
    }

    public void sendMessage(String string) {
        PrintWriter printWriter = new PrintWriter(this.outStream, true);
        printWriter.println(string);
    }

    public void run() {
        if (this.running && this.neuroSocket.isConnected()) {
            try {
                String string;
                while ((string = this.stdIn.readLine()) != null) {
                    String[] stringArray = string.split("/\r/");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].indexOf("{") <= -1) continue;
                        JSONObject jSONObject = new JSONObject(stringArray[i]);
                        this.parsePacket(jSONObject);
                    }
                }
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.parent.delay(50);
        } else {
            this.running = false;
        }
    }

    private void triggerAttentionEvent(int n) {
        if (this.attentionEventMethod != null) {
            try {
                this.attentionEventMethod.invoke((Object)this.parent, n);
            }
            catch (Exception exception) {
                System.err.println("Disabling attentionEvent()  because of an error.");
                exception.printStackTrace();
                this.attentionEventMethod = null;
            }
        }
    }

    private void triggerMeditationEvent(int n) {
        if (this.meditationEventMethod != null) {
            try {
                this.meditationEventMethod.invoke((Object)this.parent, n);
            }
            catch (Exception exception) {
                System.err.println("Disabling meditationEvent()  because of an error.");
                exception.printStackTrace();
                this.meditationEventMethod = null;
            }
        }
    }

    private void triggerPoorSignalEvent(int n) {
        if (this.poorSignalEventMethod != null) {
            try {
                this.poorSignalEventMethod.invoke((Object)this.parent, n);
            }
            catch (Exception exception) {
                System.err.println("Disabling meditationEvent()  because of an error.");
                exception.printStackTrace();
                this.poorSignalEventMethod = null;
            }
        }
    }

    private void triggerBlinkEvent(int n) {
        if (this.blinkEventMethod != null) {
            try {
                this.blinkEventMethod.invoke((Object)this.parent, n);
            }
            catch (Exception exception) {
                System.err.println("Disabling blinkEvent()  because of an error.");
                exception.printStackTrace();
                this.blinkEventMethod = null;
            }
        }
    }

    private void triggerEEGEvent(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.eegEventMethod != null) {
            try {
                this.eegEventMethod.invoke((Object)this.parent, n, n2, n3, n4, n5, n6, n7, n8);
            }
            catch (Exception exception) {
                System.err.println("Disabling eegEvent()  because of an error.");
                exception.printStackTrace();
                this.eegEventMethod = null;
            }
        }
    }

    private void triggerRawEvent(int[] nArray) {
        if (this.rawEventMethod != null) {
            try {
                this.rawEventMethod.invoke((Object)this.parent, new Object[]{nArray});
            }
            catch (Exception exception) {
                System.err.println("Disabling rawEvent()  because of an error.");
                exception.printStackTrace();
                this.rawEventMethod = null;
            }
        }
    }

    private void parsePacket(JSONObject jSONObject) {
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = e.toString();
            try {
                if (string.matches("poorSignalLevel")) {
                    this.triggerPoorSignalEvent(jSONObject.getInt(e.toString()));
                }
                if (string.matches("rawEeg")) {
                    int n;
                    this.raw[this.index] = n = ((Integer)jSONObject.get("rawEeg")).intValue();
                    ++this.index;
                    if (this.index == 512) {
                        this.index = 0;
                        int[] nArray = new int[512];
                        PApplet.arrayCopy((Object)this.raw, (Object)nArray);
                        this.triggerRawEvent(nArray);
                    }
                }
                if (string.matches("blinkStrength")) {
                    this.triggerBlinkEvent(jSONObject.getInt(e.toString()));
                }
                if (string.matches("eSense")) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject("eSense");
                    this.triggerAttentionEvent(jSONObject2.getInt("attention"));
                    this.triggerMeditationEvent(jSONObject2.getInt("meditation"));
                }
                if (!string.matches("eegPower")) continue;
                JSONObject jSONObject3 = jSONObject.getJSONObject("eegPower");
                this.triggerEEGEvent(jSONObject3.getInt("delta"), jSONObject3.getInt("theta"), jSONObject3.getInt("lowAlpha"), jSONObject3.getInt("highAlpha"), jSONObject3.getInt("lowBeta"), jSONObject3.getInt("highBeta"), jSONObject3.getInt("lowGamma"), jSONObject3.getInt("highGamma"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

