////////////////////////////////////////////////////////////////////////////
// Name: progmem.c
// Author: B. Gian James <gian@BattleDroids.net>
// Description: Contains all the game data and strings contained in
//              progmem space.
//
// $Id: progmem.c,v 1.2 2009/08/21 07:24:03 gian Exp $
////////////////////////////////////////////////////////////////////////////
#include <avr/pgmspace.h>

#include "progmem.h"

prog_char endl[]  = "\r";
prog_char initialized[]  = "Another quality AVR product from BattleDroids.net!\r";
prog_char new_game[]  = ">>Would you like to start a new game? \r";
prog_char your_turn[]  = "It is your turn.\r";
prog_char game_master[]  = ">>Who will be the game master? You or me?  \r";
prog_char correct_color[]  = "Correct color: ";
prog_char correct_place[]  = "Correct place: ";
prog_char make_guess[] = ">>What are your color picks? \r";
prog_char guess_info[]  = "Please type the colors with spaces between them.\r";
prog_char title1[] = "    ************************************************************************\r";
prog_char title2[] = "    **                .oO[ Mastermind v1.0  AVR ]Oo.                      **\r";
prog_char title3[] = "    **  Copyright 2009 B. Gian James  <gian@BattleDroids.net>             **\r";
prog_char title4[] = "    **  You are free to copy, distribute, modify, or steal this work.     **\r";
prog_char title5[] = "    **                                                                    **\r";
prog_char title6[] = "    **  Based on the logic game \"Mastermind.\"  Enjoy!                     **\r";
prog_char title7[] = "    ************************************************************************\r";
prog_char intro1[] = "Please type all your responses in lower case. It reduces the processing I have to do. Thanks!\r";
prog_char im_ready[] = "I've chosen my colors. Let's begin!\r";
prog_char colors[] = "Color choices: ";
prog_char help1[] = "The object of the game is to figure out what colors were chosen by the clues given. The target\r";
prog_char help2[] = "color sequence is four colors, in any order, duplicate colors allowed. The player will be told\r";
prog_char help3[] = "how many colors were in the target sequence, and how many of those correct colors were also in\r";
prog_char help4[] = "the correct position. For blue, blue, red, yellow, if a player guessed red, white, blue, yellow\r";
prog_char help5[] = "he would have two correct colors and one color in the correct spot. Those are the only clues you\r";
prog_char help6[] = "will be given, but from these, you can deduce the correct combination of colors.\r";
prog_char help7[] = "You may type \"help\" at any time to get this message.  Good luck!\r";
prog_char abortnow[] = "There was a problem. Gotta abort!\r";
prog_char intro2[] = "It helps a lot if you are using a monospace/fixed-width font since the formatting depends on it.\r";
prog_char intro3[] = "Common monospace are Courier, Proggy, Envy Code, Andale Mono, Dina, etc.\r";
prog_char intro4[] = "If you are using the AVR Terminal from BattleDroids.net then you won't experience a format issue.\r";
prog_char intro5[] = "Download the most recent version from http://www.BattleDroids.net/ \r";
prog_char flavor[] = "      <<Now with more AVR flavor and fewer calories! No MSG! 100% Organic!>>\r";
prog_char won[] = "<< Congratulations! You won! /me bows to the master of logic! >>\r";
prog_char highscore[] = "Hey, this is a high score!\r";

char * StringDB[]  PROGMEM =
{
	endl,
	initialized,
	new_game,
	your_turn,
	game_master,
	correct_color,
	correct_place,
	make_guess,
	guess_info,
	title1, title2, title3, title4, title5, title6, title7,
	intro1, 
	im_ready,
	colors,
	help1, help2, help3, help4, help5, help6, help7,
	abortnow,
	intro2, intro3, intro4, intro5,
	flavor,
	won,
	highscore
};

char *
GetString(String s)
{
	return ( (char*)pgm_read_word(&StringDB[s]));
}