////////////////////////////////////////////////////////////////////////////
// Name: main.c
// Author: B. Gian James <gian@BattleDroids.net>
// Description: The main file for ATmega162 Mastermind
//
// $Id: main.c,v 1.4 2009/08/21 08:19:12 gian Exp $
////////////////////////////////////////////////////////////////////////////

#include <avr/io.h>
#include <stdlib.h>	// itoa
#include <string.h>
#include "usart.h"
#include "hardware.h"
#include "config.h"
#include "progmem.h"
#include "mastermind.h"

void 	DoTitle(void);
void	DoHelp(void);
uint8	DoColors(void);
void	DoRandom(void);


char 			buff[MAX_RX_SZ];

int main(void)
{
	InitTimer();
	InitUSART();

	DoTitle();
	DoHelp();
	DoRandom();
		
	for (;;)
	{
		WriteString(GetString(NEW_GAME));
		ReadLine(buff);
		if (buff[0] == 'n')
			WriteRAMString("Then turn me off! I'm in a loop!\r");
				
		WriteString(GetString(GAME_MASTER));
		ReadLine(buff);
		if (buff[0] == 'y') {		// Player against MCU
			InitGame(MCU);
			WriteString(GetString(IM_READY));
			
			TurnStruct *	currTurn;
			uint8	turn;
			for(turn = 0; turn < NUM_TURNS; turn++)	// Here we go
			{
				memset(buff,0,MAX_RX_SZ);
				// Setup round
				StartRound(turn);
				// Get colors from player
				while ( (DoColors() == 1) )
					DoHelp();
				
				// Calculate the number of colors correct
				currTurn = CalcCorrect();				
				// Display the results
				DisplayTurnInfo();
				
				if (currTurn->numColorPlaceCorrect == NUM_SLOTS)
				{
					WriteString(GetString(ENDL));
					WriteString(GetString(WON));
					uint8 highScore = ReadEEHighScore();
					if (highScore == 0xFF || highScore > currTurn->turn) {
						WriteString(GetString(HIGHSCORE));
						WriteString(PSTR("Saving your high score...\r"));
						WriteEEHighScore(currTurn->turn);					
					}
					WriteRAMString("\r\r");
					break;
				}
				if (currTurn->turn == 8)
				{
					WriteString(PSTR("Sorry! You didn't figure out the correct color sequence!\r"));
				}
			}
		} else						// MCU against player
		{
			WriteString(PSTR("Sorry, that isn't implemented in v1.0\r"));
		}	
	}
}

void DoRandom()
{
	uint8	haveLDR = ReadEEHaveLDR();
	if (haveLDR == 0x01)
		InitRandom(1);
	else if (haveLDR == 0x00)
		InitRandom(0);
	else {
		WriteString(PSTR(">>Do you have a Light Determinig Resistor (LDR) attached to PINC0 (Analog Pin 0)? \r"));
		ReadLine(buff);
		if (buff[0] == 'y') {
			InitRandom(1);
			haveLDR = 0x01;
		}
		else {
			WriteString(PSTR("Ok. I'll randomize by time. Try it with an LDR as per the instructions sometime. It's fun :)\r"));
			InitRandom(0);
			haveLDR = 0x00;
		}
		WriteEEHaveLDR(haveLDR);
	}
}

uint8 DoColors()
{
	WriteString(GetString(COLORS));
	for(uint8 z = 0; z < NUM_COLORS; z++) {
		WriteRAMString(ColorInfo[z].name);
		WriteRAMString(" ");
	}
	WriteString(GetString(ENDL));
	WriteString(GetString(GUESS_INFO));
	WriteString(GetString(MAKE_GUESS));			
	ReadLine(buff);
	if (buff[0] == 'h' && buff[1] == 'e')
		return 1;
	
#ifdef DEBUG
	WriteRAMString(buff);
#endif
	// Parse color choices and calc the number correct
	while (!ProcessColors(buff))
	{
		WriteString(PSTR("Bad color choice. Let's try it again.\r"));
		
		WriteString(GetString(COLORS));
		for(uint8 z = 0; z < NUM_COLORS; z++) {
			WriteRAMString(ColorInfo[z].name);
			WriteRAMString(" ");
		}
		WriteString(GetString(ENDL));
		WriteString(GetString(GUESS_INFO));
		WriteString(GetString(MAKE_GUESS));			
		ReadLine(buff);
#ifdef DEBUG	
		WriteRAMString(buff);
#endif
	}
	
	return 0;

}

void DoTitle()
{
	// Title
	WriteString(GetString(ENDL));
	WriteString(GetString(ENDL));

	WriteString(GetString(TITLE1));
	WriteString(GetString(TITLE2));
	WriteString(GetString(TITLE3));
	WriteString(GetString(TITLE4));
	WriteString(GetString(TITLE5));
	WriteString(GetString(TITLE6));
	WriteString(GetString(TITLE7));
	WriteChar('\r');
	WriteString(GetString(FLAVOR));
	WriteString(GetString(INITIALIZED));
}


void DoHelp()
{
	WriteString(GetString(HELP1));
	WriteString(GetString(HELP2));
	WriteString(GetString(HELP3));
	WriteString(GetString(HELP4));
	WriteString(GetString(HELP5));
	WriteString(GetString(HELP6));
	WriteString(GetString(HELP7));	
	WriteString(GetString(INTRO1));
	WriteString(GetString(INTRO2));
	WriteString(GetString(INTRO3));
	WriteString(GetString(INTRO4));
	WriteString(GetString(INTRO5));
	WriteChar('\r');
}



