#pragma once
////////////////////////////////////////////////////////////////////////////
/// Name: common.h
/// Author: B. Gian James  <gian@OpenHouseware.net>
/// Description: Commonly used things n stuff.
///
// $Id: common.h,v 1.1.1.1 2009/08/17 08:10:59 gian Exp $
////////////////////////////////////////////////////////////////////////////

#ifndef F_CPU
#define F_CPU 16000000
#endif
#include <avr/io.h>
#include <util/delay.h>
#include <stdio.h>
#include <stdint.h>
#include <avr/pgmspace.h>

// This just makes my life easier
#define BIT16(b) ((unsigned long)0x00000001 << (b))
#define	BIT8(b) (0x01 << (b))


// from AVR035: Efficient C Coding for AVR 
#define BSET(ADDRESS,BIT) (ADDRESS |= (unsigned char)(1<<BIT)) 
#define BCLR(ADDRESS,BIT) (ADDRESS &= (unsigned char)~(1<<BIT)) 
#define BTOG(ADDRESS,BIT) (ADDRESS ^= (unsigned char)(1<<BIT)) 
#define BCHK(ADDRESS,BIT) (ADDRESS &  (unsigned char)(1<<BIT)) 

#define BMSET(x,y) (x |= (y)) 
#define BMCLR(x,y) (x &= (~y)) 
#define BMTOG(x,y) (x ^= (y)) 
#define BMCHK(x,y) (x & (y)) 

// Typedefs for shorthand
// I wonder how much time programmer's around the world have lost from having
// to type "_t"...
typedef uint8_t			uint8;
typedef uint16_t		uint16;
typedef uint32_t		uint32;
typedef unsigned char 	uchar;

// Utility functions
uint8_t StringCopy(char *, const char *);

// Timer defines
#define EnableCTCTimer()		BSET(TCCR0A,WGM01)
#define PRESCALER				1024
#define StartTimer()			(BSET(TCCR0B,CS02), BSET(TCCR0B,CS00))
#define StopTimer()				(BCLR(TCCR0B,CS02), BCLR(TCCR0B,CS00))
#define EnableCTCInterrupt()	BSET(TIMSK0,OCIE0A)
#define EnableCTCInterruptB()	BSET(TIMSK0,OCIE0B)
#define ComparePerSec()			195
#define SetCompareMatch()		(OCR0A = ComparePerSec())
#define SetUARTCompareMatch()	(OCR0B = ComparePerSec())
#define InterruptsPerSec		100
#define UARTRxDelay				5

#define SENDESC            \
    Term_Send( 27 );       \
    Term_Send( '[' );
	
	

