//Number of slices in image stack
int slices1 = 1;
// Corection factor to keep all of the values below 255 generally this should be smaller than the "min" value from the data set
float maxFactor = 0.94;

//Regression coefficents
float a0 = 0.939055700753706;
float ax = 0.0043514167765956;
float axx = -0.0000745261312451661;
float ayy = 0.0000433855924125834;
/////////////////////////////////////////////////////////
// Conversion function for Intensity to RGB value Do not change theses
float b0 = -3.17683320898;
float b1 = 253.987338525855;
//Variables
float proj;
float maxImageMap;
float maxImageMap2;
float finalMap;
float x;
float y;
int sliceNumber=1;
PImage imageSlice;
PImage maskSlice1;

void setup() {
  size(1280, 800);
  
  // Create mask
  for (int i = 1; i < 1280; i++) {
    for (int j = 1; j < 800; j++) {
      //shiftaxis (Dont' use width and hieght for corrections, it gives some errors in the final resul (?))
      x = i * 64 / 1280;
      y = (800 - j) * 40 / 800;
      //Use regression equation to generate map of projector light intensity (0-1) converting from mm to pixels
      proj = a0+ax*x+axx*x*x+ayy*y*y;
      //Invert the ratio scaling by the max factor so that no part is greater than 1
      maxImageMap = maxFactor / proj;
      //Convert map from (0-1) scale by using a regression relationship from 16-BJA-4, should be general for all I2C printers
      maxImageMap2 = b0 + b1 * maxImageMap;
      //Create inverse image to subtract off (some weird bug in processing does not always give the correct blending subtractions, hence +3 
      finalMap = 255 - maxImageMap2 + 3;
      color c = color(finalMap, finalMap, finalMap);
      set(i, j, c);
    }
   }
   save("data/mask/correctionMask.png");
   maskSlice1 = loadImage("data/mask/correctionMask.png");  
}

void draw() {
  imageSlice = loadImage( "../Data/image stack/slice_"+str(sliceNumber)+".png"); 
  background(imageSlice);
  
  //Subtract off mask
  blend(maskSlice1, 0, 0, 1280, 800, 0, 0, 1280, 800, SUBTRACT);
  
  save("output/slice_"+str(sliceNumber)+".png");
      sliceNumber=sliceNumber+1;
  
  if (sliceNumber > slices1) {
      exit();   
  } 
}
