/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.wearable.R;
import android.support.wearable.view.ObservableScrollView;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.Button;
import android.widget.TextView;

@TargetApi(value=21)
public class WearableDialogActivity
extends Activity
implements Handler.Callback,
View.OnLayoutChangeListener,
ObservableScrollView.OnScrollListener,
View.OnClickListener,
View.OnApplyWindowInsetsListener {
    private static final int MSG_HIDE_BUTTON_BAR = 1001;
    private static final long ANIM_DURATION = 500L;
    private static final long HIDE_ANIM_DELAY = 1500L;
    private ObservableScrollView mParentPanel;
    private ViewGroup mButtonPanel;
    private ViewGroup mAnimatedWrapperContainer;
    private TextView mTitleView;
    private TextView mMessageView;
    private Button mButtonPositive;
    private Button mButtonNegative;
    private Button mButtonNeutral;
    private Handler mHandler;
    private ObjectAnimator mButtonPanelAnimator;
    private PropertyValuesHolder mTranslationValuesHolder;
    private Interpolator mInterpolator;
    private boolean mHiddenBefore;
    private float mButtonPanelFloatHeight;
    private int mButtonPanelShadeHeight;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(R.style.Theme_WearDiag);
        this.setContentView(R.layout.alert_dialog_wearable);
        this.mAnimatedWrapperContainer = (ViewGroup)this.findViewById(R.id.animatedWrapperContainer);
        this.mTitleView = (TextView)this.mAnimatedWrapperContainer.findViewById(R.id.alertTitle);
        this.mMessageView = (TextView)this.mAnimatedWrapperContainer.findViewById(16908299);
        this.mButtonPanel = (ViewGroup)this.mAnimatedWrapperContainer.findViewById(R.id.buttonPanel);
        this.mButtonPositive = (Button)this.mButtonPanel.findViewById(16908313);
        this.mButtonPositive.setOnClickListener((View.OnClickListener)this);
        this.mButtonNegative = (Button)this.mButtonPanel.findViewById(16908314);
        this.mButtonNegative.setOnClickListener((View.OnClickListener)this);
        this.mButtonNeutral = (Button)this.mButtonPanel.findViewById(16908315);
        this.mButtonNeutral.setOnClickListener((View.OnClickListener)this);
        this.setupLayout();
        this.mHandler = new Handler((Handler.Callback)this);
        this.mInterpolator = AnimationUtils.loadInterpolator((Context)this, (int)17563661);
        this.mButtonPanelFloatHeight = this.getResources().getDimension(R.dimen.diag_floating_height);
        this.mParentPanel = (ObservableScrollView)this.findViewById(R.id.parentPanel);
        this.mParentPanel.addOnLayoutChangeListener(this);
        this.mParentPanel.setOnScrollListener(this);
        this.mParentPanel.setOnApplyWindowInsetsListener(this);
    }

    public WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
        Resources res = this.getResources();
        if (insets.isRound()) {
            this.mButtonPanelShadeHeight = res.getDimensionPixelSize(R.dimen.diag_shade_height_round);
            this.mTitleView.setPadding(res.getDimensionPixelSize(R.dimen.diag_content_side_padding_round), res.getDimensionPixelSize(R.dimen.diag_content_top_padding_round), res.getDimensionPixelSize(R.dimen.diag_content_side_padding_round), 0);
            this.mMessageView.setPadding(res.getDimensionPixelSize(R.dimen.diag_content_side_padding_round), 0, res.getDimensionPixelSize(R.dimen.diag_content_side_padding_round), res.getDimensionPixelSize(R.dimen.diag_content_bottom_padding));
            this.mButtonPanel.setPadding(res.getDimensionPixelSize(R.dimen.diag_content_side_padding_round), 0, res.getDimensionPixelSize(R.dimen.diag_button_side_padding_right_round), res.getDimensionPixelSize(R.dimen.diag_button_bottom_padding_round));
        } else {
            this.mButtonPanelShadeHeight = this.getResources().getDimensionPixelSize(R.dimen.diag_shade_height_rect);
        }
        return v.onApplyWindowInsets(insets);
    }

    protected void setupLayout() {
        CharSequence title = this.getAlertTitle();
        if (TextUtils.isEmpty((CharSequence)title)) {
            this.mTitleView.setVisibility(8);
        } else {
            this.mMessageView.setVisibility(0);
            this.mTitleView.setText(title);
        }
        CharSequence message = this.getMessage();
        if (TextUtils.isEmpty((CharSequence)message)) {
            this.mMessageView.setVisibility(8);
        } else {
            this.mMessageView.setVisibility(0);
            this.mMessageView.setText(message);
        }
        boolean hasButtons = this.setButton(this.mButtonPositive, this.getPositiveButtonText(), this.getPositiveButtonDrawable());
        hasButtons = this.setButton(this.mButtonNegative, this.getNegativeButtonText(), this.getNegativeButtonDrawable()) || hasButtons;
        hasButtons = this.setButton(this.mButtonNeutral, this.getNeutralButtonText(), this.getNeutralButtonDrawable()) || hasButtons;
        this.mButtonPanel.setVisibility(hasButtons ? 0 : 8);
    }

    private boolean setButton(Button button, CharSequence text, Drawable drawable2) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            button.setVisibility(8);
            return false;
        }
        button.setText(text);
        if (drawable2 != null) {
            button.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
        }
        button.setVisibility(0);
        return true;
    }

    public CharSequence getAlertTitle() {
        return null;
    }

    public CharSequence getMessage() {
        return null;
    }

    public CharSequence getPositiveButtonText() {
        return null;
    }

    public Drawable getPositiveButtonDrawable() {
        return null;
    }

    public CharSequence getNegativeButtonText() {
        return null;
    }

    public Drawable getNegativeButtonDrawable() {
        return null;
    }

    public CharSequence getNeutralButtonText() {
        return null;
    }

    public Drawable getNeutralButtonDrawable() {
        return null;
    }

    public void onPositiveButtonClick() {
        this.finish();
    }

    public void onNeutralButtonClick() {
        this.finish();
    }

    public void onNegativeButtonClick() {
        this.finish();
    }

    public void onClick(View v) {
        switch (v.getId()) {
            case 16908313: {
                this.onPositiveButtonClick();
                break;
            }
            case 16908314: {
                this.onNegativeButtonClick();
                break;
            }
            case 16908315: {
                this.onNeutralButtonClick();
            }
        }
    }

    @Override
    public void onScroll(float deltaY) {
        this.mHandler.removeMessages(1001);
        this.hideButtonBar();
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (this.mButtonPanelAnimator != null) {
            this.mButtonPanelAnimator.cancel();
        }
        this.mHandler.removeMessages(1001);
        this.mHiddenBefore = false;
        if (this.mAnimatedWrapperContainer.getHeight() > this.mParentPanel.getHeight()) {
            this.mButtonPanel.setTranslationZ(this.mButtonPanelFloatHeight);
            this.mHandler.sendEmptyMessageDelayed(1001, 1500L);
            this.mButtonPanelAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)this.mButtonPanel, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{this.getButtonBarFloatingBottomTranslation(), this.getButtonBarFloatingTopTranslation()}), PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Z, (float[])new float[]{0.0f, this.mButtonPanelFloatHeight})});
            this.mButtonPanelAnimator.setDuration(500L);
            this.mButtonPanelAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
            this.mButtonPanelAnimator.start();
        } else {
            this.mButtonPanel.setTranslationY(0.0f);
            this.mButtonPanel.setTranslationZ(0.0f);
            this.mButtonPanel.offsetTopAndBottom(this.mParentPanel.getHeight() - this.mAnimatedWrapperContainer.getHeight());
            this.mAnimatedWrapperContainer.setBottom(this.mParentPanel.getHeight());
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1001: {
                this.hideButtonBar();
                return true;
            }
        }
        return false;
    }

    private int getButtonBarFloatingTopTranslation() {
        return this.getButtonBarOffsetFromBottom() - Math.min(this.mButtonPanel.getHeight(), this.mButtonPanelShadeHeight);
    }

    private int getButtonBarFloatingBottomTranslation() {
        return Math.min(this.getButtonBarOffsetFromBottom(), 0);
    }

    private int getButtonBarOffsetFromBottom() {
        return -this.mButtonPanel.getTop() + Math.max(this.mParentPanel.getScrollY(), 0) + this.mParentPanel.getHeight();
    }

    private void hideButtonBar() {
        if (!this.mHiddenBefore || this.mButtonPanelAnimator == null) {
            if (this.mButtonPanelAnimator != null) {
                this.mButtonPanelAnimator.cancel();
            }
            this.mTranslationValuesHolder = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{this.getButtonBarFloatingTopTranslation(), this.getButtonBarFloatingBottomTranslation()});
            this.mButtonPanelAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)this.mButtonPanel, (PropertyValuesHolder[])new PropertyValuesHolder[]{this.mTranslationValuesHolder, PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Z, (float[])new float[]{this.mButtonPanelFloatHeight, 0.0f})});
            this.mButtonPanelAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    WearableDialogActivity.this.mParentPanel.setOnScrollListener(null);
                    WearableDialogActivity.this.mButtonPanel.setTranslationY(0.0f);
                    WearableDialogActivity.this.mButtonPanel.setTranslationZ(0.0f);
                }
            });
            this.mButtonPanelAnimator.setDuration(500L);
            this.mButtonPanelAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
            this.mButtonPanelAnimator.start();
        } else if (this.mButtonPanelAnimator.isRunning()) {
            int end;
            int start = this.getButtonBarFloatingTopTranslation();
            if (start < (end = this.getButtonBarFloatingBottomTranslation())) {
                this.mTranslationValuesHolder.setFloatValues(new float[]{start, end});
                if (this.mButtonPanel.getTranslationY() < (float)start) {
                    this.mButtonPanel.setTranslationY((float)start);
                }
            } else {
                this.mButtonPanelAnimator.cancel();
                this.mButtonPanel.setTranslationY(0.0f);
                this.mButtonPanel.setTranslationZ(0.0f);
            }
        } else {
            this.mButtonPanel.setTranslationY(0.0f);
            this.mButtonPanel.setTranslationZ(0.0f);
        }
        this.mHiddenBefore = true;
    }
}

