/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.StateListAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.support.wearable.R;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;

@SuppressLint(value={"ClickableViewAccessibility"})
@TargetApi(value=21)
public class CircularButton
extends View {
    private static final double SQRT_2 = Math.sqrt(2.0);
    public static final int SCALE_MODE_FIT = 0;
    public static final int SCALE_MODE_CENTER = 1;
    private static final float DEFAULT_ICON_SIZE_DP = 48.0f;
    private int mRippleColor = -1;
    private ShapeDrawable mShapeDrawable = new ShapeDrawable((Shape)new OvalShape());
    private RippleDrawable mRippleDrawable;
    private Interpolator mInterpolator;
    private ColorStateList mColors;
    private Drawable mImage;
    private int mDiameter;
    private int mScaleMode;

    private static int inscribedSize(int r) {
        return (int)Math.floor((double)r * SQRT_2);
    }

    private static int encircledRadius(int l) {
        return (int)Math.floor((double)l / SQRT_2);
    }

    public CircularButton(Context context) {
        this(context, null);
    }

    public CircularButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularButton(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public CircularButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mShapeDrawable.getPaint().setColor(-3355444);
        super.setBackgroundDrawable((Drawable)this.mShapeDrawable);
        this.setOutlineProvider(new CircleOutlineProvider());
        this.mInterpolator = new AccelerateInterpolator(2.0f);
        this.mScaleMode = 0;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularButton, defStyleAttr, defStyleRes);
        for (int i = 0; i < a.getIndexCount(); ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.CircularButton_android_color) {
                this.mColors = a.getColorStateList(attr);
                this.mShapeDrawable.getPaint().setColor(this.mColors.getDefaultColor());
                continue;
            }
            if (attr == R.styleable.CircularButton_android_src) {
                this.mImage = a.getDrawable(attr);
                continue;
            }
            if (attr == R.styleable.CircularButton_rippleColor) {
                this.setRippleColor(a.getColor(attr, -1));
                continue;
            }
            if (attr == R.styleable.CircularButton_pressedTranslationZ) {
                this.setPressedTranslationZ(a.getDimension(attr, 0.0f));
                continue;
            }
            if (attr != R.styleable.CircularButton_imageScaleMode) continue;
            this.mScaleMode = a.getInt(attr, this.mScaleMode);
        }
        a.recycle();
        this.setClickable(true);
    }

    public void setColor(int color2) {
        this.mColors = ColorStateList.valueOf((int)color2);
        this.mShapeDrawable.getPaint().setColor(this.mColors.getDefaultColor());
    }

    public void setColor(ColorStateList colorStateList) {
        this.mColors = colorStateList;
        this.mShapeDrawable.getPaint().setColor(this.mColors.getDefaultColor());
    }

    public void setRippleColor(int rippleColor) {
        this.mRippleColor = rippleColor;
        if (this.mRippleDrawable != null) {
            this.mRippleDrawable.setColor(ColorStateList.valueOf((int)rippleColor));
        } else if (this.mRippleColor != -1 && !this.isInEditMode()) {
            this.mRippleDrawable = new RippleDrawable(ColorStateList.valueOf((int)rippleColor), (Drawable)this.mShapeDrawable, (Drawable)this.mShapeDrawable);
            super.setBackgroundDrawable((Drawable)this.mRippleDrawable);
        } else {
            this.mRippleDrawable = null;
            super.setBackgroundDrawable((Drawable)this.mShapeDrawable);
        }
    }

    public void setImageResource(int drawableRes) {
        this.setImageDrawable(this.getResources().getDrawable(drawableRes));
    }

    public Drawable getImageDrawable() {
        return this.mImage;
    }

    public void setImageDrawable(Drawable drawable2) {
        if (this.mImage != null) {
            this.mImage.setCallback(null);
        }
        if (this.mImage != drawable2) {
            this.mImage = drawable2;
            this.requestLayout();
            this.invalidate();
        }
        if (this.mImage != null) {
            this.mImage.setCallback((Drawable.Callback)this);
        }
    }

    public int getImageScaleMode() {
        return this.mScaleMode;
    }

    public void setImageScaleMode(int scaleMode) {
        this.mScaleMode = scaleMode;
        if (this.mImage != null) {
            this.invalidate();
            this.requestLayout();
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return this.mImage == who || super.verifyDrawable(who);
    }

    public void setBackgroundDrawable(Drawable background) {
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mColors != null && this.mColors.isStateful()) {
            this.mShapeDrawable.getPaint().setColor(this.mColors.getColorForState(this.getDrawableState(), this.mColors.getDefaultColor()));
            this.mShapeDrawable.invalidateSelf();
        }
    }

    private int dpToPx(float dp) {
        return (int)Math.ceil(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics()));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == 0x40000000 && heightMode == 0x40000000) {
            this.mDiameter = Math.min(widthSize, heightSize);
        } else if (widthMode == 0x40000000) {
            this.mDiameter = widthSize;
        } else if (heightMode == 0x40000000) {
            this.mDiameter = heightSize;
        } else {
            int imageSize = CircularButton.hasIntrinsicSize(this.mImage) ? Math.max(this.mImage.getIntrinsicHeight(), this.mImage.getIntrinsicWidth()) : this.dpToPx(48.0f);
            if (widthMode == Integer.MIN_VALUE || heightMode == Integer.MIN_VALUE) {
                int atMost = 0;
                atMost = widthMode != Integer.MIN_VALUE ? heightSize : (heightMode != Integer.MIN_VALUE ? widthSize : Math.min(widthSize, heightSize));
                this.mDiameter = Math.min(atMost, CircularButton.encircledRadius(imageSize) * 2);
            } else {
                this.mDiameter = imageSize;
            }
        }
        this.setMeasuredDimension(this.mDiameter, this.mDiameter);
    }

    private static boolean hasIntrinsicSize(Drawable d) {
        return d != null && d.getIntrinsicHeight() > 0 && d.getIntrinsicWidth() > 0;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        int w = r - l;
        int h = b - t;
        if (this.mImage != null) {
            int iw = this.mImage.getIntrinsicWidth();
            int ih = this.mImage.getIntrinsicHeight();
            if (this.mScaleMode == 0 || !CircularButton.hasIntrinsicSize(this.mImage)) {
                int vpad;
                int inscr = CircularButton.inscribedSize(this.mDiameter / 2);
                int hpad = vpad = (this.mDiameter - inscr) / 2;
                if (!CircularButton.hasIntrinsicSize(this.mImage)) {
                    this.mImage.setBounds(hpad, vpad, hpad + inscr, vpad + inscr);
                } else {
                    if (iw == ih) {
                        iw = ih = inscr;
                    } else {
                        float aspect = (float)iw / (float)ih;
                        if (iw > ih) {
                            iw = inscr;
                            ih = (int)((float)iw / aspect);
                            vpad = (int)((float)(inscr - ih) / 2.0f);
                        } else {
                            ih = inscr;
                            iw = (int)((float)ih * aspect);
                            hpad = (int)((float)(inscr - iw) / 2.0f);
                        }
                    }
                    this.mImage.setBounds(hpad, vpad, hpad + iw, vpad + ih);
                }
            } else {
                int hpad = (int)((float)(w - iw) / 2.0f);
                int vpad = (int)((float)(h - ih) / 2.0f);
                this.mImage.setBounds(hpad, vpad, hpad + iw, vpad + ih);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mImage != null) {
            this.mImage.draw(canvas);
        }
    }

    public void setPressedTranslationZ(float translationZ) {
        StateListAnimator stateListAnimator = new StateListAnimator();
        stateListAnimator.addState(PRESSED_ENABLED_STATE_SET, this.setupAnimator((Animator)ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationZ", (float[])new float[]{translationZ})));
        stateListAnimator.addState(ENABLED_FOCUSED_STATE_SET, this.setupAnimator((Animator)ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationZ", (float[])new float[]{translationZ})));
        stateListAnimator.addState(EMPTY_STATE_SET, this.setupAnimator((Animator)ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationZ", (float[])new float[]{this.getElevation()})));
        this.setStateListAnimator(stateListAnimator);
    }

    private Animator setupAnimator(Animator animator) {
        animator.setInterpolator((TimeInterpolator)this.mInterpolator);
        return animator;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean handled = super.onTouchEvent(event);
        if (handled) {
            switch (event.getAction() & 0xFF) {
                case 0: {
                    this.getBackground().setHotspot(event.getX(), event.getY());
                }
            }
        }
        return handled;
    }

    private class CircleOutlineProvider
    extends ViewOutlineProvider {
        private CircleOutlineProvider() {
        }

        public void getOutline(View view, Outline outline) {
            outline.setOval(0, 0, CircularButton.this.mDiameter, CircularButton.this.mDiameter);
        }
    }
}

