/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.support.wearable.R;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import java.util.Objects;

@TargetApi(value=21)
public class ActionLabel
extends View {
    static final int MIN_TEXT_SIZE = 10;
    static final int MAX_TEXT_SIZE = 60;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int MONOSPACE = 3;
    private static final String TAG = "ActionLabel";
    private static final boolean DEBUG = false;
    private TextPaint mTextPaint;
    private float mLineSpacingMult;
    private float mLineSpacingAdd;
    private Layout mLayout;
    private int mGravity = 0x800033;
    private ColorStateList mTextColor;
    private int mCurTextColor;
    private CharSequence mText;
    private float mSpacingMult = 1.0f;
    private float mSpacingAdd = 0.0f;
    private float mMinTextSize;
    private float mMaxTextSize;
    private float mTextScaleFactor;
    private float mCurrentTextSize;
    private int mMaxLines = Integer.MAX_VALUE;
    private int mDrawMaxLines;

    public ActionLabel(Context context) {
        this(context, null);
    }

    public ActionLabel(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ActionLabel(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ActionLabel(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        float density = dm.density;
        float scaledDensity = dm.scaledDensity;
        this.mTextScaleFactor = scaledDensity / density;
        this.mMinTextSize = 10.0f * scaledDensity;
        this.mMaxTextSize = 60.0f * scaledDensity;
        this.mTextPaint = new TextPaint(1);
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.ActionLabel, defStyleAttr, defStyleRes);
        this.mText = a.getText(R.styleable.ActionLabel_android_text);
        this.mMinTextSize = a.getDimension(R.styleable.ActionLabel_minTextSize, this.mMinTextSize);
        this.mMaxTextSize = a.getDimension(R.styleable.ActionLabel_maxTextSize, this.mMaxTextSize);
        this.mTextColor = a.getColorStateList(R.styleable.ActionLabel_android_textColor);
        this.mMaxLines = a.getInt(R.styleable.ActionLabel_android_maxLines, 2);
        if (this.mTextColor != null) {
            this.updateTextColors();
        }
        this.mTextPaint.setTextSize(this.mMaxTextSize);
        String fontFamily = a.getString(R.styleable.ActionLabel_android_fontFamily);
        int typefaceIndex = a.getInt(R.styleable.ActionLabel_android_typeface, -1);
        int styleIndex = a.getInt(R.styleable.ActionLabel_android_textStyle, -1);
        this.setTypefaceFromAttrs(fontFamily, typefaceIndex, styleIndex);
        this.mGravity = a.getInt(R.styleable.ActionLabel_android_gravity, this.mGravity);
        this.mLineSpacingAdd = a.getDimensionPixelSize(R.styleable.ActionLabel_android_lineSpacingExtra, (int)this.mLineSpacingAdd);
        this.mLineSpacingMult = a.getFloat(R.styleable.ActionLabel_android_lineSpacingMultiplier, this.mLineSpacingMult);
        a.recycle();
        if (this.mText == null) {
            this.mText = "";
        }
    }

    public void setText(CharSequence text) {
        if (!Objects.equals(this.mText, text)) {
            this.mLayout = null;
            this.mText = text;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setMinTextSize(float size) {
        this.setMinTextSize(2, size);
    }

    public void setMinTextSize(int unit, float size) {
        float sizePx = TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        if (sizePx != this.mMinTextSize) {
            this.mLayout = null;
            this.mMinTextSize = sizePx;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setMaxTextSize(float size) {
        this.setMaxTextSize(2, size);
    }

    public void setMaxTextSize(int unit, float size) {
        float sizePx = TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        if (sizePx != this.mMaxTextSize) {
            this.mLayout = null;
            this.mMaxTextSize = sizePx;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setTypeface(Typeface tf) {
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            if (this.mLayout != null) {
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setTypeface(Typeface tf, int style2) {
        if (style2 > 0) {
            tf = tf == null ? Typeface.defaultFromStyle((int)style2) : Typeface.create((Typeface)tf, (int)style2);
            this.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style2 & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setTypeface(tf);
        }
    }

    public Typeface getTypeface() {
        return this.mTextPaint.getTypeface();
    }

    void setTypefaceFromAttrs(String familyName, int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        if (familyName != null && (tf = Typeface.create((String)familyName, (int)styleIndex)) != null) {
            this.setTypeface(tf);
            return;
        }
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        this.setTypeface(tf, styleIndex);
    }

    public void setLineSpacing(float add, float mult) {
        if (this.mSpacingAdd != add || this.mSpacingMult != mult) {
            this.mSpacingAdd = add;
            this.mSpacingMult = mult;
            if (this.mLayout != null) {
                this.mLayout = null;
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public float getLineSpacingMultiplier() {
        return this.mSpacingMult;
    }

    public float getLineSpacingExtra() {
        return this.mSpacingAdd;
    }

    public void setTextColor(int color2) {
        this.mTextColor = ColorStateList.valueOf((int)color2);
        this.updateTextColors();
    }

    public void setTextColor(ColorStateList colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        this.mTextColor = colors;
        this.updateTextColors();
    }

    public final ColorStateList getTextColors() {
        return this.mTextColor;
    }

    public final int getCurrentTextColor() {
        return this.mCurTextColor;
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    public void setMaxLines(int lines) {
        if (this.mMaxLines != lines) {
            this.mMaxLines = lines;
            this.mLayout = null;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.invalidate();
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mTextColor != null && this.mTextColor.isStateful()) {
            this.updateTextColors();
        }
    }

    private void updateTextColors() {
        int color2 = this.mTextColor.getColorForState(this.getDrawableState(), 0);
        if (color2 != this.mCurTextColor) {
            this.mCurTextColor = color2;
            this.invalidate();
        }
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.mLayout = null;
        this.requestLayout();
        this.invalidate();
    }

    @SuppressLint(value={"RtlHardcoded"})
    private Layout.Alignment getLayoutAlignment() {
        Layout.Alignment alignment;
        block0 : switch (this.getTextAlignment()) {
            case 1: {
                switch (this.mGravity & 0x800007) {
                    case 0x800003: {
                        alignment = Layout.Alignment.ALIGN_NORMAL;
                        break block0;
                    }
                    case 0x800005: {
                        alignment = Layout.Alignment.ALIGN_OPPOSITE;
                        break block0;
                    }
                    case 3: {
                        alignment = Layout.Alignment.ALIGN_NORMAL;
                        break block0;
                    }
                    case 5: {
                        alignment = Layout.Alignment.ALIGN_OPPOSITE;
                        break block0;
                    }
                    case 1: {
                        alignment = Layout.Alignment.ALIGN_CENTER;
                        break block0;
                    }
                }
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 2: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 3: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 4: {
                alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            default: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        return alignment;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = -1;
        int height = -1;
        if (widthMode == 0x40000000) {
            width = widthSize;
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
        }
        if (width == -1) {
            this.mTextPaint.setTextSize(this.mMaxTextSize);
            width = (int)Math.ceil(Layout.getDesiredWidth((CharSequence)this.mText, (TextPaint)this.mTextPaint));
            this.mTextPaint.setTextSize(this.mCurrentTextSize);
        }
        if (widthMode == Integer.MIN_VALUE) {
            width = Math.min(width, widthSize);
        }
        Layout.Alignment alignment = this.getLayoutAlignment();
        if (height == -1) {
            int n = height = heightMode == Integer.MIN_VALUE ? heightSize : Integer.MAX_VALUE;
        }
        if (this.mLayout == null) {
            this.mLayout = this.makeNewLayout(width, height, alignment);
        } else {
            boolean heightChanged;
            boolean widthChanged = this.mLayout.getWidth() != width;
            boolean bl = heightChanged = this.mLayout.getHeight() != height;
            if (widthChanged || heightChanged) {
                this.mLayout = this.makeNewLayout(width, height, alignment);
            }
        }
        if (this.mLayout == null) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (heightMode != 0x40000000) {
            height = this.mLayout.getLineTop(this.mLayout.getLineCount());
        }
        if (heightMode == Integer.MIN_VALUE) {
            height = Math.min(height, heightSize);
        }
        this.setMeasuredDimension(width, height);
    }

    private Layout makeNewLayout(int width, int height, Layout.Alignment alignment) {
        boolean textCanShrink;
        if (height <= 0 || width <= 0) {
            return null;
        }
        long t = 0L;
        int availableHeight = height - (this.getPaddingTop() + this.getPaddingBottom());
        int availableWidth = width - (this.getPaddingLeft() + this.getPaddingRight());
        this.mCurrentTextSize = this.mMaxTextSize;
        this.mTextPaint.setTextSize(this.mMaxTextSize);
        int tries = 1;
        StaticLayout layout2 = new StaticLayout(this.mText, this.mTextPaint, availableWidth, alignment, this.mSpacingMult, this.mSpacingAdd, true);
        boolean tooManyLines = layout2.getLineCount() > this.mMaxLines;
        boolean tooTall = layout2.getLineTop(layout2.getLineCount()) > availableHeight;
        boolean bl = textCanShrink = this.mTextPaint.getTextSize() > this.mMinTextSize;
        if (tooManyLines || tooTall) {
            while ((tooManyLines || tooTall) && textCanShrink) {
                this.mCurrentTextSize -= 1.0f;
                this.mTextPaint.setTextSize(this.mCurrentTextSize);
                layout2 = new StaticLayout(this.mText, this.mTextPaint, availableWidth, alignment, this.mSpacingMult, this.mSpacingAdd, true);
                tooTall = layout2.getLineTop(layout2.getLineCount()) > availableHeight;
                tooManyLines = layout2.getLineCount() > this.mMaxLines;
                textCanShrink = this.mTextPaint.getTextSize() > this.mMinTextSize;
                ++tries;
            }
        }
        this.mDrawMaxLines = Math.min(this.mMaxLines, layout2.getLineCount());
        return layout2;
    }

    private int getAvailableHeight() {
        return this.getHeight() - (this.getPaddingTop() + this.getPaddingBottom());
    }

    int getVerticalOffset() {
        int voffset;
        int availHeight = this.getAvailableHeight();
        int textHeight = this.mLayout.getLineTop(this.mDrawMaxLines);
        int gravity = this.mGravity & 0x70;
        switch (gravity) {
            case 48: {
                voffset = 0;
                break;
            }
            case 16: {
                voffset = (availHeight - textHeight) / 2;
                break;
            }
            case 80: {
                voffset = availHeight - textHeight;
                break;
            }
            default: {
                voffset = 0;
            }
        }
        return voffset;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mLayout != null) {
            canvas.save();
            this.mTextPaint.setColor(this.mCurTextColor);
            this.mTextPaint.drawableState = this.getDrawableState();
            canvas.translate((float)this.getPaddingLeft(), (float)(this.getPaddingTop() + this.getVerticalOffset()));
            canvas.clipRect(0, 0, this.getWidth() - this.getPaddingRight(), this.mLayout.getLineTop(this.mDrawMaxLines));
            this.mLayout.draw(canvas);
            canvas.restore();
        }
    }
}

