/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzm;
import com.google.android.gms.maps.internal.zzx;
import com.google.android.gms.maps.internal.zzy;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapFragment
extends Fragment {
    private final zzb zzaBU = new zzb(this);
    private GoogleMap zzaBV;

    public static MapFragment newInstance() {
        return new MapFragment();
    }

    public static MapFragment newInstance(GoogleMapOptions options) {
        MapFragment mapFragment = new MapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)options);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    protected IMapFragmentDelegate zzvt() {
        this.zzaBU.zzvu();
        if (this.zzaBU.zzqj() == null) {
            return null;
        }
        return ((zza)this.zzaBU.zzqj()).zzvt();
    }

    @Deprecated
    public final GoogleMap getMap() {
        IGoogleMapDelegate iGoogleMapDelegate;
        IMapFragmentDelegate iMapFragmentDelegate = this.zzvt();
        if (iMapFragmentDelegate == null) {
            return null;
        }
        try {
            iGoogleMapDelegate = iMapFragmentDelegate.getMap();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        if (iGoogleMapDelegate == null) {
            return null;
        }
        if (this.zzaBV == null || this.zzaBV.zzvi().asBinder() != iGoogleMapDelegate.asBinder()) {
            this.zzaBV = new GoogleMap(iGoogleMapDelegate);
        }
        return this.zzaBV;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzaBU.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.zzaBU.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attrs);
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.zzaBU.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.zzaBU.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = this.zzaBU.onCreateView(inflater, container, savedInstanceState);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zzaBU.onResume();
    }

    public void onPause() {
        this.zzaBU.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.zzaBU.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzaBU.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzaBU.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(outState);
        this.zzaBU.onSaveInstanceState(outState);
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        zzu.zzbY((String)"getMapAsync must be called on the main thread.");
        this.zzaBU.getMapAsync(callback);
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment zzajt;
        protected zzf<zza> zzaBZ;
        private Activity mActivity;
        private final List<OnMapReadyCallback> zzaCa = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.zzajt = fragment;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzaBZ = zzf2;
            this.zzvu();
        }

        public void zzvu() {
            if (this.mActivity != null && this.zzaBZ != null && this.zzqj() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzy.zzay((Context)this.mActivity).zzr(zze.zzw((Object)this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzaBZ.zza((LifecycleDelegate)new zza(this.zzajt, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaCa) {
                        ((zza)this.zzqj()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaCa.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzvu();
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zzqj() != null) {
                ((zza)this.zzqj()).getMapAsync(callback);
            } else {
                this.zzaCa.add(callback);
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final Fragment zzajt;
        private final IMapFragmentDelegate zzaBW;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zzaBW = (IMapFragmentDelegate)zzu.zzu((Object)iMapFragmentDelegate);
            this.zzajt = (Fragment)zzu.zzu((Object)fragment);
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)attrs.getParcelable("MapOptions");
            try {
                this.zzaBW.onInflate(zze.zzw((Object)activity), googleMapOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                Bundle bundle;
                if (savedInstanceState == null) {
                    savedInstanceState = new Bundle();
                }
                if ((bundle = this.zzajt.getArguments()) != null && bundle.containsKey("MapOptions")) {
                    zzx.zza(savedInstanceState, "MapOptions", bundle.getParcelable("MapOptions"));
                }
                this.zzaBW.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            zzd zzd2;
            try {
                zzd2 = this.zzaBW.onCreateView(zze.zzw((Object)inflater), zze.zzw((Object)container), savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zze.zzn((zzd)zzd2);
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.zzaBW.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaBW.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            try {
                this.zzaBW.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroy() {
            try {
                this.zzaBW.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzaBW.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaBW.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapFragmentDelegate zzvt() {
            return this.zzaBW;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzaBW.getMapAsync(new zzm.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

