/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.zzl;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbk;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzhl;
import org.json.JSONException;
import org.json.JSONObject;

@zzgd
public class zzb
extends zzhh
implements zzc.zza {
    private final zza.zza zzCd;
    private final AdRequestInfoParcel.zza zzCe;
    private final Object zzBr = new Object();
    private final Context mContext;
    private final zzan zzvA;
    zzhh zzCf;
    Object zzqt = new Object();
    AdResponseParcel zzBt;
    zzdy zzxn;

    public zzb(Context context, AdRequestInfoParcel.zza zza2, zzan zzan2, zza.zza zza3) {
        this.zzCd = zza3;
        this.mContext = context;
        this.zzCe = zza2;
        this.zzvA = zzan2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzqt;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zzb.zzay("Received ad response.");
            this.zzBt = adResponseParcel;
            this.zzqt.notify();
        }
    }

    zzhh zzb(AdRequestInfoParcel adRequestInfoParcel) {
        return zzc.zza(this.mContext, adRequestInfoParcel, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdP() {
        Object object = this.zzqt;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zzb.zzay("AdLoaderBackgroundTask started.");
            zzaj zzaj2 = this.zzvA.zzab();
            String string = zzaj2.zzb(this.mContext);
            zzl zzl2 = zzl.zzq(this.mContext);
            String string2 = zzl2.getClientId();
            AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzCe, string, string2);
            AdSizeParcel adSizeParcel = null;
            int n = -2;
            long l = -1L;
            try {
                long l2 = zzo.zzbz().elapsedRealtime();
                zzhh zzhh2 = this.zzb(adRequestInfoParcel);
                Object object2 = this.zzBr;
                synchronized (object2) {
                    this.zzCf = zzhh2;
                    if (this.zzCf == null) {
                        throw new zza("Could not start the ad request service.", 0);
                    }
                }
                this.zzi(l2);
                l = zzo.zzbz().elapsedRealtime();
                this.zzfu();
                if (adRequestInfoParcel.zzpN.zzso != null) {
                    adSizeParcel = this.zzc(adRequestInfoParcel);
                }
                this.zzw(this.zzBt.zzCU);
            }
            catch (zza zza2) {
                n = zza2.getErrorCode();
                if (n == 3 || n == -1) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzaA(zza2.getMessage());
                } else {
                    com.google.android.gms.ads.internal.util.client.zzb.zzaC(zza2.getMessage());
                }
                this.zzBt = this.zzBt == null ? new AdResponseParcel(n) : new AdResponseParcel(n, this.zzBt.zzxJ);
                zzhl.zzGk.post(new Runnable(){

                    @Override
                    public void run() {
                        zzb.this.onStop();
                    }
                });
            }
            JSONObject jSONObject = null;
            if (!TextUtils.isEmpty((CharSequence)this.zzBt.zzCS)) {
                try {
                    jSONObject = new JSONObject(this.zzBt.zzCS);
                }
                catch (Exception exception) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Error parsing the JSON for Active View.", exception);
                }
            }
            final zzha.zza zza3 = new zzha.zza(adRequestInfoParcel, this.zzBt, this.zzxn, adSizeParcel, n, l, this.zzBt.zzCO, jSONObject);
            zzhl.zzGk.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzb.this.zzqt;
                    synchronized (object) {
                        zzb.this.zzCd.zza(zza3);
                    }
                }
            });
        }
    }

    protected void zzw(boolean bl) {
        zzo.zzby().zzA(bl);
        zzbk zzbk2 = zzo.zzby().zzD(this.mContext);
        if (zzbk2 != null && !zzbk2.isAlive()) {
            com.google.android.gms.ads.internal.util.client.zzb.zzay("start fetching content...");
            zzbk2.zzcp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzBr;
        synchronized (object) {
            if (this.zzCf != null) {
                this.zzCf.cancel();
            }
        }
    }

    protected void zzfu() throws zza {
        if (this.zzBt.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzBt.zzCI)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzo.zzby().zza(this.mContext, this.zzBt.zzCu);
        if (this.zzBt.zzCK) {
            try {
                this.zzxn = new zzdy(this.zzBt.zzCI);
            }
            catch (JSONException jSONException) {
                throw new zza("Could not parse mediation config: " + this.zzBt.zzCI, 0);
            }
        }
    }

    protected AdSizeParcel zzc(AdRequestInfoParcel adRequestInfoParcel) throws zza {
        int n;
        int n2;
        if (this.zzBt.zzCN == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzBt.zzCN.split("x");
        if (stringArray.length != 2) {
            throw new zza("Invalid ad size format from the ad response: " + this.zzBt.zzCN, 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new zza("Invalid ad size number from the ad response: " + this.zzBt.zzCN, 0);
        }
        for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzpN.zzso) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / f) : adSizeParcel.width;
            int n5 = n3 = adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / f) : adSizeParcel.height;
            if (n2 != n4 || n != n3) continue;
            return new AdSizeParcel(adSizeParcel, adRequestInfoParcel.zzpN.zzso);
        }
        throw new zza("The ad size from the ad response was not one of the requested sizes: " + this.zzBt.zzCN, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzi(long l) throws zza {
        do {
            if (this.zze(l)) continue;
            throw new zza("Timed out waiting for ad response.", 2);
        } while (this.zzBt == null);
        Object object = this.zzBr;
        synchronized (object) {
            this.zzCf = null;
        }
        if (this.zzBt.errorCode != -2 && this.zzBt.errorCode != -3) {
            throw new zza("There was a problem getting an ad response. ErrorCode: " + this.zzBt.errorCode, this.zzBt.errorCode);
        }
    }

    protected boolean zze(long l) throws zza {
        long l2 = 60000L - (zzo.zzbz().elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzqt.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            throw new zza("Ad request cancelled.", -1);
        }
        return true;
    }

    @zzgd
    static final class zza
    extends Exception {
        private final int zzBv;

        public zza(String string, int n) {
            super(string);
            this.zzBv = n;
        }

        public int getErrorCode() {
            return this.zzBv;
        }
    }
}

