/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzhl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzgd
public class zzi
extends SurfaceView
implements AudioManager.OnAudioFocusChangeListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
SurfaceHolder.Callback {
    private static final Map<Integer, String> zzzU = new HashMap<Integer, String>();
    private int zzzV = 0;
    private int zzzW = 0;
    private SurfaceHolder zzzX;
    private MediaPlayer zzzY;
    private Uri zzzZ;
    private int zzAa;
    private int zzAb;
    private int zzAc;
    private int zzAd;
    private int zzAe;
    private float zzAf = 1.0f;
    private boolean zzAg;
    private boolean zzAh;
    private int zzAi;
    private zzg zzAj;

    public zzi(Context context) {
        super(context);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        if (Build.VERSION.SDK_INT < 11) {
            this.getHolder().setType(3);
        }
    }

    public void zza(zzg zzg2) {
        this.zzAj = zzg2;
    }

    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    public void setVideoURI(Uri uri) {
        this.zzzZ = uri;
        this.zzAi = 0;
        this.zzeP();
        this.requestLayout();
        this.invalidate();
    }

    public void stop() {
        zzb.zzaB("AdVideoView stop");
        if (this.zzzY != null) {
            this.zzzY.stop();
            this.zzzY.release();
            this.zzzY = null;
            this.zzzV = 0;
            this.zzzW = 0;
            this.zzeS();
        }
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        zzb.zzaB("AdVideoView size changed: " + width + " x " + height);
        this.zzAa = mp.getVideoWidth();
        this.zzAb = mp.getVideoHeight();
        if (this.zzAa != 0 && this.zzAb != 0) {
            this.getHolder().setFixedSize(this.zzAa, this.zzAb);
            this.requestLayout();
        }
    }

    public void onPrepared(final MediaPlayer mediaPlayer) {
        zzb.zzaB("AdVideoView prepared");
        this.zzzV = 2;
        zzhl.zzGk.post(new Runnable(){

            @Override
            public void run() {
                if (zzi.this.zzAj != null) {
                    zzi.this.zzAj.onPrepared(mediaPlayer);
                }
            }
        });
        this.zzAa = mediaPlayer.getVideoWidth();
        this.zzAb = mediaPlayer.getVideoHeight();
        if (this.zzAi != 0) {
            this.seekTo(this.zzAi);
        }
        this.zzeQ();
        if (this.zzAa != 0 && this.zzAb != 0) {
            zzb.zzaA("AdVideoView stream dimensions: " + this.zzAa + " x " + this.zzAb);
            this.getHolder().setFixedSize(this.zzAa, this.zzAb);
            if (this.zzAc == this.zzAa && this.zzAd == this.zzAb && this.zzzW == 3) {
                this.play();
            }
        } else if (this.zzzW == 3) {
            this.play();
        }
        this.zzeR();
        this.zzeW();
    }

    public void onCompletion(MediaPlayer mp) {
        zzb.zzaB("AdVideoView completion");
        this.zzzV = 5;
        this.zzzW = 5;
        zzhl.zzGk.post(new Runnable(){

            @Override
            public void run() {
                if (zzi.this.zzAj != null) {
                    zzi.this.zzAj.zzeF();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        String string = zzzU.get(what);
        String string2 = zzzU.get(extra);
        zzb.zzaB("AdVideoView MediaPlayer info: " + string + ":" + string2);
        return true;
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        final String string = zzzU.get(what);
        final String string2 = zzzU.get(extra);
        zzb.zzaC("AdVideoView MediaPlayer error: " + string + ":" + string2);
        this.zzzV = -1;
        this.zzzW = -1;
        zzhl.zzGk.post(new Runnable(){

            @Override
            public void run() {
                if (zzi.this.zzAj != null) {
                    zzi.this.zzAj.zzg(string, string2);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.zzAe = percent;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        zzb.zzaB("AdVideoView surface created");
        this.zzzX = holder;
        this.zzeP();
        zzhl.zzGk.post(new Runnable(){

            @Override
            public void run() {
                if (zzi.this.zzAj != null) {
                    zzi.this.zzAj.zzeD();
                }
            }
        });
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        boolean bl;
        zzb.zzaB("AdVideoView surface changed");
        this.zzAc = w;
        this.zzAd = h;
        boolean bl2 = this.zzzW == 3;
        boolean bl3 = bl = this.zzAa == w && this.zzAb == h;
        if (this.zzzY != null && bl2 && bl) {
            if (this.zzAi != 0) {
                this.seekTo(this.zzAi);
            }
            this.play();
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        zzb.zzaB("AdVideoView surface destroyed");
        if (this.zzzY != null && this.zzAi == 0) {
            this.zzAi = this.zzzY.getCurrentPosition();
        }
        this.zzzX = null;
        zzhl.zzGk.post(new Runnable(){

            @Override
            public void run() {
                if (zzi.this.zzAj != null) {
                    zzi.this.zzAj.onPaused();
                    zzi.this.zzAj.zzeG();
                }
            }
        });
        this.zzv(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n = zzi.getDefaultSize((int)this.zzAa, (int)widthMeasureSpec);
        int n2 = zzi.getDefaultSize((int)this.zzAb, (int)heightMeasureSpec);
        if (this.zzAa > 0 && this.zzAb > 0) {
            int n3 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n5 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n6 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (n3 == 0x40000000 && n5 == 0x40000000) {
                n2 = n6;
                n = n4;
                if (this.zzAa * n2 < n * this.zzAb) {
                    n = n2 * this.zzAa / this.zzAb;
                } else if (this.zzAa * n2 > n * this.zzAb) {
                    n2 = n * this.zzAb / this.zzAa;
                }
            } else if (n3 == 0x40000000) {
                n = n4;
                n2 = n * this.zzAb / this.zzAa;
                if (n5 == Integer.MIN_VALUE && n2 > n6) {
                    n2 = n6;
                }
            } else if (n5 == 0x40000000) {
                n2 = n6;
                n = n2 * this.zzAa / this.zzAb;
                if (n3 == Integer.MIN_VALUE && n > n4) {
                    n = n4;
                }
            } else {
                n = this.zzAa;
                n2 = this.zzAb;
                if (n5 == Integer.MIN_VALUE && n2 > n6) {
                    n2 = n6;
                    n = n2 * this.zzAa / this.zzAb;
                }
                if (n3 == Integer.MIN_VALUE && n > n4) {
                    n = n4;
                    n2 = n * this.zzAb / this.zzAa;
                }
            }
        }
        this.setMeasuredDimension(n, n2);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    private void zzeP() {
        zzb.zzaB("AdVideoView init MediaPlayer");
        if (this.zzzZ == null || this.zzzX == null) {
            return;
        }
        this.zzv(false);
        try {
            this.zzzY = new MediaPlayer();
            this.zzzY.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzzY.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzzY.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzzY.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzzY.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzzY.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzAe = 0;
            this.zzzY.setDataSource(this.getContext(), this.zzzZ);
            this.zzzY.setDisplay(this.zzzX);
            this.zzzY.setAudioStreamType(3);
            this.zzzY.setScreenOnWhilePlaying(true);
            this.zzzY.prepareAsync();
            this.zzzV = 1;
        }
        catch (IOException | IllegalArgumentException exception) {
            zzb.zzd("Failed to initialize MediaPlayer at " + this.zzzZ, exception);
            this.onError(this.zzzY, 1, 0);
        }
    }

    private void zzeQ() {
        if (this.zzeT() && this.zzzW != 3) {
            long l;
            zzb.zzaB("AdVideoView nudging MediaPlayer");
            this.zzzY.start();
            int n = this.zzzY.getCurrentPosition();
            long l2 = zzo.zzbz().currentTimeMillis();
            while (this.zzeT() && this.zzzY.getCurrentPosition() == n && (l = zzo.zzbz().currentTimeMillis()) - l2 <= 250L) {
            }
            this.zzzY.pause();
        }
    }

    private void zzeR() {
        AudioManager audioManager = this.zzeX();
        if (audioManager != null && !this.zzAh) {
            int n = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
            if (n == 1) {
                this.zzeU();
            } else {
                zzb.zzaC("AdVideoView audio focus request failed");
            }
        }
    }

    private void zzeS() {
        zzb.zzaB("AdVideoView abandon audio focus");
        AudioManager audioManager = this.zzeX();
        if (audioManager != null && this.zzAh) {
            int n = audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            if (n == 1) {
                this.zzAh = false;
            } else {
                zzb.zzaC("AdVideoView abandon audio focus failed");
            }
        }
    }

    private void zzv(boolean bl) {
        zzb.zzaB("AdVideoView release");
        if (this.zzzY != null) {
            this.zzzY.reset();
            this.zzzY.release();
            this.zzzY = null;
            this.zzzV = 0;
            if (bl) {
                this.zzzW = 0;
            }
            this.zzeS();
        }
    }

    public void play() {
        zzb.zzaB("AdVideoView play");
        if (this.zzeT()) {
            this.zzzY.start();
            this.zzzV = 3;
            zzhl.zzGk.post(new Runnable(){

                @Override
                public void run() {
                    if (zzi.this.zzAj != null) {
                        zzi.this.zzAj.zzeE();
                    }
                }
            });
        }
        this.zzzW = 3;
    }

    public void pause() {
        zzb.zzaB("AdVideoView pause");
        if (this.zzeT() && this.zzzY.isPlaying()) {
            this.zzzY.pause();
            this.zzzV = 4;
            zzhl.zzGk.post(new Runnable(){

                @Override
                public void run() {
                    if (zzi.this.zzAj != null) {
                        zzi.this.zzAj.onPaused();
                    }
                }
            });
        }
        this.zzzW = 4;
    }

    public int getCurrentPosition() {
        if (this.zzeT()) {
            return this.zzzY.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int millis) {
        zzb.zzaB("AdVideoView seek " + millis);
        if (this.zzeT()) {
            this.zzzY.seekTo(millis);
            this.zzAi = 0;
        } else {
            this.zzAi = millis;
        }
    }

    private boolean zzeT() {
        return this.zzzY != null && this.zzzV != -1 && this.zzzV != 0 && this.zzzV != 1;
    }

    public void onAudioFocusChange(int focusChange) {
        if (focusChange > 0) {
            this.zzeU();
        } else if (focusChange < 0) {
            this.zzeV();
        }
    }

    public void zzeI() {
        this.zzAg = true;
        this.zzeW();
    }

    public void zzeJ() {
        this.zzAg = false;
        this.zzeW();
    }

    public void zza(float f) {
        this.zzAf = f;
        this.zzeW();
    }

    private void zzeU() {
        zzb.zzaB("AdVideoView audio focus gained");
        this.zzAh = true;
        this.zzeW();
    }

    private void zzeV() {
        zzb.zzaB("AdVideoView audio focus lost");
        this.zzAh = false;
        this.zzeW();
    }

    private void zzeW() {
        if (!this.zzAg && this.zzAh) {
            this.zzb(this.zzAf);
        } else {
            this.zzb(0.0f);
        }
    }

    private void zzb(float f) {
        if (this.zzzY != null) {
            try {
                this.zzzY.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzb.zzaC("AdVideoView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private AudioManager zzeX() {
        Context context = this.getContext();
        return (AudioManager)context.getSystemService("audio");
    }

    static {
        zzzU.put(-1004, "MEDIA_ERROR_IO");
        zzzU.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzzU.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzzU.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzzU.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzzU.put(1, "MEDIA_ERROR_UNKNOWN");
        zzzU.put(1, "MEDIA_INFO_UNKNOWN");
        zzzU.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzzU.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzzU.put(701, "MEDIA_INFO_BUFFERING_START");
        zzzU.put(702, "MEDIA_INFO_BUFFERING_END");
        zzzU.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzzU.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzzU.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzzU.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzzU.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }
}

