/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzg;
import com.google.android.gms.ads.internal.client.zzi;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.client.zzr;
import com.google.android.gms.ads.internal.client.zzx;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcj;
import com.google.android.gms.internal.zzee;
import com.google.android.gms.internal.zzfk;
import com.google.android.gms.internal.zzfo;
import java.util.concurrent.atomic.AtomicBoolean;

public class zzy {
    private final zzee zzsR = new zzee();
    private final zzg zznH;
    private final AtomicBoolean zzsS;
    private AdListener zzrV;
    private zza zzrU;
    private zzr zzsT;
    private AdSize[] zzsr;
    private String zzoL;
    private String zzsU;
    private ViewGroup zzsV;
    private AppEventListener zzsq;
    private InAppPurchaseListener zzsW;
    private PlayStorePurchaseListener zzsX;
    private OnCustomRenderedAdLoadedListener zzsY;

    public zzy(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzg.zzcw());
    }

    public zzy(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzg.zzcw());
    }

    zzy(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzg zzg2, zzr zzr2) {
        this.zzsV = viewGroup;
        this.zznH = zzg2;
        this.zzsT = zzr2;
        this.zzsS = new AtomicBoolean(false);
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzj zzj2 = new zzj(context, attributeSet);
                this.zzsr = zzj2.zzi(bl);
                this.zzoL = zzj2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzk.zzcA().zza(viewGroup, new AdSizeParcel(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzk.zzcA().zza(viewGroup, new AdSizeParcel(context, this.zzsr[0]), "Ads by Google");
            }
        }
    }

    zzy(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzg zzg2) {
        this(viewGroup, attributeSet, bl, zzg2, null);
    }

    public void destroy() {
        try {
            if (this.zzsT != null) {
                this.zzsT.destroy();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to destroy AdView.", remoteException);
        }
    }

    public AdListener getAdListener() {
        return this.zzrV;
    }

    public AdSize getAdSize() {
        try {
            AdSizeParcel adSizeParcel;
            if (this.zzsT != null && (adSizeParcel = this.zzsT.zzaN()) != null) {
                return adSizeParcel.zzcy();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the current AdSize.", remoteException);
        }
        return this.zzsr != null ? this.zzsr[0] : null;
    }

    public AdSize[] getAdSizes() {
        return this.zzsr;
    }

    public String getAdUnitId() {
        return this.zzoL;
    }

    public AppEventListener getAppEventListener() {
        return this.zzsq;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzsW;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzsY;
    }

    public void zza(zzx zzx2) {
        try {
            if (this.zzsT == null) {
                this.zzcO();
            }
            if (this.zzsT.zza(this.zznH.zza(this.zzsV.getContext(), zzx2))) {
                this.zzsR.zzf(zzx2.zzcJ());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void pause() {
        try {
            if (this.zzsT != null) {
                this.zzsT.pause();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call pause.", remoteException);
        }
    }

    public void recordManualImpression() {
        if (this.zzsS.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzsT != null) {
                this.zzsT.zzaP();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to record impression.", remoteException);
        }
    }

    public void resume() {
        try {
            if (this.zzsT != null) {
                this.zzsT.resume();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call resume.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzrV = adListener;
            if (this.zzsT != null) {
                this.zzsT.zza(adListener != null ? new zzc(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zza zza2) {
        try {
            this.zzrU = zza2;
            if (this.zzsT != null) {
                this.zzsT.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdSizes(AdSize ... adSizes) {
        if (this.zzsr != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizes);
    }

    public void zza(AdSize ... adSizeArray) {
        this.zzsr = adSizeArray;
        try {
            if (this.zzsT != null) {
                this.zzsT.zza(new AdSizeParcel(this.zzsV.getContext(), this.zzsr));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the ad size.", remoteException);
        }
        this.zzsV.requestLayout();
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzoL != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzoL = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzsq = appEventListener;
            if (this.zzsT != null) {
                this.zzsT.zza(appEventListener != null ? new zzi(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzsX != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzsW = inAppPurchaseListener;
            if (this.zzsT != null) {
                this.zzsT.zza(inAppPurchaseListener != null ? new zzfk(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzsY = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzsT != null) {
                this.zzsT.zza(onCustomRenderedAdLoadedListener != null ? new zzcj(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zzsW != null) {
            throw new IllegalStateException("InAppPurchaseListener has already been set.");
        }
        try {
            this.zzsX = playStorePurchaseListener;
            this.zzsU = publicKey;
            if (this.zzsT != null) {
                this.zzsT.zza(playStorePurchaseListener != null ? new zzfo(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzsT != null) {
                return this.zzsT.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    private void zzcN() {
        try {
            zzd zzd2 = this.zzsT.zzaM();
            if (zzd2 == null) {
                return;
            }
            this.zzsV.addView((View)zze.zzn((zzd)zzd2));
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get an ad frame.", remoteException);
        }
    }

    private void zzcO() throws RemoteException {
        if ((this.zzsr == null || this.zzoL == null) && this.zzsT == null) {
            throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
        }
        Context context = this.zzsV.getContext();
        this.zzsT = zzk.zzcB().zza(context, new AdSizeParcel(context, this.zzsr), this.zzoL, this.zzsR);
        if (this.zzrV != null) {
            this.zzsT.zza(new zzc(this.zzrV));
        }
        if (this.zzrU != null) {
            this.zzsT.zza(new zzb(this.zzrU));
        }
        if (this.zzsq != null) {
            this.zzsT.zza(new zzi(this.zzsq));
        }
        if (this.zzsW != null) {
            this.zzsT.zza(new zzfk(this.zzsW));
        }
        if (this.zzsX != null) {
            this.zzsT.zza(new zzfo(this.zzsX), this.zzsU);
        }
        if (this.zzsY != null) {
            this.zzsT.zza(new zzcj(this.zzsY));
        }
        this.zzsT.zza(zzk.zzcC());
        this.zzcN();
    }
}

