/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzrc;
import com.google.android.gms.internal.zzrm;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.wearable.Asset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class DataMap {
    public static final String TAG = "DataMap";
    private final HashMap<String, Object> zzaSU = new HashMap();

    public static DataMap fromBundle(Bundle bundle) {
        bundle.setClassLoader(Asset.class.getClassLoader());
        DataMap dataMap = new DataMap();
        for (String string : bundle.keySet()) {
            DataMap.zza(dataMap, string, bundle.get(string));
        }
        return dataMap;
    }

    public static DataMap fromByteArray(byte[] bytes) {
        try {
            return zzrb.zza(new zzrb.zza(zzrc.zzw(bytes), new ArrayList<Asset>()));
        }
        catch (zzrm zzrm2) {
            throw new IllegalArgumentException("Unable to convert data", zzrm2);
        }
    }

    public static ArrayList<DataMap> arrayListFromBundleArrayList(ArrayList<Bundle> bundleArrayList) {
        ArrayList<DataMap> arrayList = new ArrayList<DataMap>();
        for (Bundle bundle : bundleArrayList) {
            arrayList.add(DataMap.fromBundle(bundle));
        }
        return arrayList;
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        for (String string : this.zzaSU.keySet()) {
            DataMap.zza(bundle, string, this.zzaSU.get(string));
        }
        return bundle;
    }

    public byte[] toByteArray() {
        return zzrn.zzf((zzrn)zzrb.zza((DataMap)this).zzaVj);
    }

    public int size() {
        return this.zzaSU.size();
    }

    public boolean isEmpty() {
        return this.zzaSU.isEmpty();
    }

    public void clear() {
        this.zzaSU.clear();
    }

    public boolean containsKey(String key) {
        return this.zzaSU.containsKey(key);
    }

    public <T> T get(String key) {
        return (T)this.zzaSU.get(key);
    }

    public Object remove(String key) {
        return this.zzaSU.remove(key);
    }

    public void putAll(DataMap dataMap) {
        for (String string : dataMap.keySet()) {
            this.zzaSU.put(string, dataMap.get(string));
        }
    }

    public Set<String> keySet() {
        return this.zzaSU.keySet();
    }

    public void putBoolean(String key, boolean value) {
        this.zzaSU.put(key, value);
    }

    public void putByte(String key, byte value) {
        this.zzaSU.put(key, value);
    }

    public void putInt(String key, int value) {
        this.zzaSU.put(key, value);
    }

    public void putLong(String key, long value) {
        this.zzaSU.put(key, value);
    }

    public void putFloat(String key, float value) {
        this.zzaSU.put(key, Float.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.zzaSU.put(key, value);
    }

    public void putString(String key, String value) {
        this.zzaSU.put(key, value);
    }

    public void putAsset(String key, Asset value) {
        this.zzaSU.put(key, value);
    }

    public void putDataMap(String key, DataMap value) {
        this.zzaSU.put(key, value);
    }

    public void putDataMapArrayList(String key, ArrayList<DataMap> value) {
        this.zzaSU.put(key, value);
    }

    public void putIntegerArrayList(String key, ArrayList<Integer> value) {
        this.zzaSU.put(key, value);
    }

    public void putStringArrayList(String key, ArrayList<String> value) {
        this.zzaSU.put(key, value);
    }

    public void putByteArray(String key, byte[] value) {
        this.zzaSU.put(key, value);
    }

    public void putLongArray(String key, long[] value) {
        this.zzaSU.put(key, value);
    }

    public void putFloatArray(String key, float[] value) {
        this.zzaSU.put(key, value);
    }

    public void putStringArray(String key, String[] value) {
        this.zzaSU.put(key, value);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return (Boolean)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "Boolean", defaultValue, classCastException);
            return defaultValue;
        }
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(String key, byte defaultValue) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return (Byte)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "Byte", defaultValue, classCastException);
            return defaultValue;
        }
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return (Integer)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "Integer", classCastException);
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return (Long)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "long", classCastException);
            return defaultValue;
        }
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return ((Float)object).floatValue();
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "Float", Float.valueOf(defaultValue), classCastException);
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return (Double)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "Double", defaultValue, classCastException);
            return defaultValue;
        }
    }

    public String getString(String key, String defaultValue) {
        String string = this.getString(key);
        return string == null ? defaultValue : string;
    }

    public String getString(String key) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (String)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "String", classCastException);
            return null;
        }
    }

    public Asset getAsset(String key) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (Asset)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "Asset", classCastException);
            return null;
        }
    }

    public DataMap getDataMap(String key) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (DataMap)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, TAG, classCastException);
            return null;
        }
    }

    public ArrayList<Integer> getIntegerArrayList(String key) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "ArrayList<Integer>", classCastException);
            return null;
        }
    }

    public ArrayList<String> getStringArrayList(String key) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "ArrayList<String>", classCastException);
            return null;
        }
    }

    public ArrayList<DataMap> getDataMapArrayList(String key) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "ArrayList<DataMap>", classCastException);
            return null;
        }
    }

    public byte[] getByteArray(String key) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (byte[])object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "byte[]", classCastException);
            return null;
        }
    }

    public long[] getLongArray(String key) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (long[])object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "long[]", classCastException);
            return null;
        }
    }

    public float[] getFloatArray(String key) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (float[])object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "float[]", classCastException);
            return null;
        }
    }

    public String[] getStringArray(String key) {
        Object object = this.zzaSU.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (String[])object;
        }
        catch (ClassCastException classCastException) {
            this.zza(key, object, "String[]", classCastException);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataMap)) {
            return false;
        }
        return DataMap.zza(this, (DataMap)o);
    }

    public int hashCode() {
        return 29 * this.zzaSU.hashCode();
    }

    public String toString() {
        return this.zzaSU.toString();
    }

    private void zza(String string, Object object, String string2, ClassCastException classCastException) {
        this.zza(string, object, string2, "<null>", classCastException);
    }

    private void zza(String string, Object object, String string2, Object object2, ClassCastException classCastException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Key ");
        stringBuilder.append(string);
        stringBuilder.append(" expected ");
        stringBuilder.append(string2);
        stringBuilder.append(" but value was a ");
        stringBuilder.append(object.getClass().getName());
        stringBuilder.append(".  The default value ");
        stringBuilder.append(object2);
        stringBuilder.append(" was returned.");
        Log.w((String)TAG, (String)stringBuilder.toString());
        Log.w((String)TAG, (String)"Attempt to cast generated internal exception:", (Throwable)classCastException);
    }

    private static boolean zza(DataMap dataMap, DataMap dataMap2) {
        if (dataMap.size() != dataMap2.size()) {
            return false;
        }
        for (String string : dataMap.keySet()) {
            Object t = dataMap.get(string);
            Object t2 = dataMap2.get(string);
            if (t instanceof Asset) {
                if (!(t2 instanceof Asset)) {
                    return false;
                }
                if (DataMap.zza((Asset)t, (Asset)t2)) continue;
                return false;
            }
            if (t instanceof String[]) {
                if (!(t2 instanceof String[])) {
                    return false;
                }
                if (Arrays.equals((String[])t, (String[])t2)) continue;
                return false;
            }
            if (t instanceof long[]) {
                if (!(t2 instanceof long[])) {
                    return false;
                }
                if (Arrays.equals((long[])t, (long[])t2)) continue;
                return false;
            }
            if (t instanceof float[]) {
                if (!(t2 instanceof float[])) {
                    return false;
                }
                if (Arrays.equals((float[])t, (float[])t2)) continue;
                return false;
            }
            if (t instanceof byte[]) {
                if (!(t2 instanceof byte[])) {
                    return false;
                }
                if (Arrays.equals((byte[])t, (byte[])t2)) continue;
                return false;
            }
            if (t == null || t2 == null) {
                return t == t2;
            }
            if (t.equals(t2)) continue;
            return false;
        }
        return true;
    }

    private static boolean zza(Asset asset, Asset asset2) {
        if (asset == null || asset2 == null) {
            return asset == asset2;
        }
        if (!TextUtils.isEmpty((CharSequence)asset.getDigest())) {
            return asset.getDigest().equals(asset2.getDigest());
        }
        return Arrays.equals(asset.getData(), asset2.getData());
    }

    private static void zza(DataMap dataMap, String string, Object object) {
        if (object instanceof String) {
            dataMap.putString(string, (String)object);
        } else if (object instanceof Integer) {
            dataMap.putInt(string, (Integer)object);
        } else if (object instanceof Long) {
            dataMap.putLong(string, (Long)object);
        } else if (object instanceof Double) {
            dataMap.putDouble(string, (Double)object);
        } else if (object instanceof Float) {
            dataMap.putFloat(string, ((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            dataMap.putBoolean(string, (Boolean)object);
        } else if (object instanceof Byte) {
            dataMap.putByte(string, (Byte)object);
        } else if (object instanceof byte[]) {
            dataMap.putByteArray(string, (byte[])object);
        } else if (object instanceof String[]) {
            dataMap.putStringArray(string, (String[])object);
        } else if (object instanceof long[]) {
            dataMap.putLongArray(string, (long[])object);
        } else if (object instanceof float[]) {
            dataMap.putFloatArray(string, (float[])object);
        } else if (object instanceof Asset) {
            dataMap.putAsset(string, (Asset)object);
        } else if (object instanceof Bundle) {
            dataMap.putDataMap(string, DataMap.fromBundle((Bundle)object));
        } else if (object instanceof ArrayList) {
            switch (DataMap.zzd((ArrayList)object)) {
                case 0: {
                    dataMap.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 1: {
                    dataMap.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 3: {
                    dataMap.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 2: {
                    dataMap.putIntegerArrayList(string, (ArrayList)object);
                    break;
                }
                case 5: {
                    dataMap.putDataMapArrayList(string, DataMap.arrayListFromBundleArrayList((ArrayList)object));
                }
            }
        }
    }

    private static void zza(Bundle bundle, String string, Object object) {
        if (object instanceof String) {
            bundle.putString(string, (String)object);
        } else if (object instanceof Integer) {
            bundle.putInt(string, ((Integer)object).intValue());
        } else if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
        } else if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
        } else if (object instanceof Float) {
            bundle.putFloat(string, ((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            bundle.putBoolean(string, ((Boolean)object).booleanValue());
        } else if (object instanceof Byte) {
            bundle.putByte(string, ((Byte)object).byteValue());
        } else if (object instanceof byte[]) {
            bundle.putByteArray(string, (byte[])object);
        } else if (object instanceof String[]) {
            bundle.putStringArray(string, (String[])object);
        } else if (object instanceof long[]) {
            bundle.putLongArray(string, (long[])object);
        } else if (object instanceof float[]) {
            bundle.putFloatArray(string, (float[])object);
        } else if (object instanceof Asset) {
            bundle.putParcelable(string, (Parcelable)((Asset)object));
        } else if (object instanceof DataMap) {
            bundle.putParcelable(string, (Parcelable)((DataMap)object).toBundle());
        } else if (object instanceof ArrayList) {
            switch (DataMap.zzd((ArrayList)object)) {
                case 0: {
                    bundle.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 1: {
                    bundle.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 3: {
                    bundle.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 2: {
                    bundle.putIntegerArrayList(string, (ArrayList)object);
                    break;
                }
                case 4: {
                    ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                    for (DataMap dataMap : (ArrayList)object) {
                        arrayList.add(dataMap.toBundle());
                    }
                    bundle.putParcelableArrayList(string, arrayList);
                }
            }
        }
    }

    private static int zzd(ArrayList<?> arrayList) {
        if (arrayList.isEmpty()) {
            return 0;
        }
        for (Object obj : arrayList) {
            if (obj == null) continue;
            if (obj instanceof Integer) {
                return 2;
            }
            if (obj instanceof String) {
                return 3;
            }
            if (obj instanceof DataMap) {
                return 4;
            }
            if (!(obj instanceof Bundle)) continue;
            return 5;
        }
        return 1;
    }
}

