/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CreateFileRequest;
import com.google.android.gms.drive.internal.CreateFolderRequest;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.zzal;
import com.google.android.gms.drive.internal.zzq;
import com.google.android.gms.drive.internal.zzr;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;

public class zzw
extends zzz
implements DriveFolder {
    public zzw(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient apiClient) {
        return this.queryChildren(apiClient, null);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient apiClient, Query query) {
        return new zzq().query(apiClient, this.zza(query));
    }

    private Query zza(Query query) {
        Query.Builder builder = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, this.getDriveId()));
        if (query != null) {
            if (query.getFilter() != null) {
                builder.addFilter(query.getFilter());
            }
            builder.setPageToken(query.getPageToken());
            builder.setSortOrder(query.getSortOrder());
        }
        return builder.build();
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, DriveContents driveContents) {
        return this.createFile(apiClient, changeSet, driveContents, null);
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        if (executionOptions == null) {
            executionOptions = new ExecutionOptions.Builder().build();
        }
        if (executionOptions.zzpk() != 0) {
            throw new IllegalStateException("May not set a conflict strategy for calls to createFile.");
        }
        return this.zza(apiClient, changeSet, driveContents, executionOptions);
    }

    private PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        int n;
        if (driveContents != null) {
            if (!(driveContents instanceof zzt)) {
                throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            }
            if (driveContents.getDriveId() != null) {
                throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            }
            if (driveContents.zzpg()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
            n = driveContents.zzpe().getRequestId();
            driveContents.zzpf();
        } else {
            n = 1;
        }
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if ("application/vnd.google-apps.folder".equals(metadataChangeSet.getMimeType())) {
            throw new IllegalArgumentException("May not create folders (mimetype: application/vnd.google-apps.folder) using this method. Use DriveFolder.createFolder() instead.");
        }
        return this.zza(googleApiClient, metadataChangeSet, n, 0, executionOptions);
    }

    private PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet, final int n, final int n2, final ExecutionOptions executionOptions) {
        ExecutionOptions.zza(googleApiClient, executionOptions);
        return googleApiClient.zzb((zza.zza)new zzd(googleApiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                metadataChangeSet.zzpm().setContext(zzs2.getContext());
                CreateFileRequest createFileRequest = new CreateFileRequest(zzw.this.getDriveId(), metadataChangeSet.zzpm(), n, n2, executionOptions);
                zzs2.zzpB().zza(createFileRequest, (zzal)new zza((zza.zzb<DriveFolder.DriveFileResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (changeSet.getMimeType() != null && !changeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return apiClient.zzb((zza.zza)new zzf(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                changeSet.zzpm().setContext(zzs2.getContext());
                zzs2.zzpB().zza(new CreateFolderRequest(zzw.this.getDriveId(), changeSet.zzpm()), (zzal)new zzb((zza.zzb<DriveFolder.DriveFolderResult>)this));
            }
        });
    }

    private static class zzb
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveFolder.DriveFolderResult> zzOs;

        public zzb(zza.zzb<DriveFolder.DriveFolderResult> zzb2) {
            this.zzOs = zzb2;
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzOs.zzm((Object)new zze(Status.zzXP, new zzw(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void zzt(Status status) throws RemoteException {
            this.zzOs.zzm((Object)new zze(status, null));
        }
    }

    private static class zze
    implements DriveFolder.DriveFolderResult {
        private final Status zzOt;
        private final DriveFolder zzafs;

        public zze(Status status, DriveFolder driveFolder) {
            this.zzOt = status;
            this.zzafs = driveFolder;
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public DriveFolder getDriveFolder() {
            return this.zzafs;
        }
    }

    static abstract class zzf
    extends zzr<DriveFolder.DriveFolderResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFolderResult zzy(Status status) {
            return new zze(status, null);
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzy(x0);
        }
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveFolder.DriveFileResult> zzOs;

        public zza(zza.zzb<DriveFolder.DriveFileResult> zzb2) {
            this.zzOs = zzb2;
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzOs.zzm((Object)new zzc(Status.zzXP, new zzu(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void zzt(Status status) throws RemoteException {
            this.zzOs.zzm((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveFolder.DriveFileResult {
        private final Status zzOt;
        private final DriveFile zzafr;

        public zzc(Status status, DriveFile driveFile) {
            this.zzOt = status;
            this.zzafr = driveFile;
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public DriveFile getDriveFile() {
            return this.zzafr;
        }
    }

    static abstract class zzd
    extends zzr<DriveFolder.DriveFileResult> {
        zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFileResult zzx(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzx(x0);
        }
    }
}

