/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.zzal;
import com.google.android.gms.drive.internal.zzbi;
import com.google.android.gms.drive.internal.zzbq;
import com.google.android.gms.drive.internal.zzq;
import com.google.android.gms.drive.internal.zzr;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzx;
import com.google.android.gms.internal.zzlg;
import java.io.InputStream;
import java.io.OutputStream;

public class zzt
implements DriveContents {
    private final Contents zzafa;
    private boolean mClosed = false;
    private boolean zzafb = false;
    private boolean zzafc = false;

    public zzt(Contents contents) {
        this.zzafa = (Contents)zzu.zzu((Object)contents);
    }

    @Override
    public DriveId getDriveId() {
        return this.zzafa.getDriveId();
    }

    @Override
    public int getMode() {
        return this.zzafa.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.zzpg()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzafa.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        if (this.zzpg()) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzafa.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzafb) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzafb = true;
        return this.zzafa.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.zzpg()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzafa.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzafc) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzafc = true;
        return this.zzafa.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient apiClient) {
        if (this.zzpg()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzafa.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzpf();
        return apiClient.zza((zza.zza)new zzq.zzb(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new OpenContentsRequest(zzt.this.getDriveId(), 0x20000000, zzt.this.zzafa.getRequestId()), (zzal)new zzbi((zza.zzb<DriveApi.DriveContentsResult>)this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet) {
        return this.commit(apiClient, changeSet, null);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet, ExecutionOptions executionOptions) {
        if (executionOptions == null) {
            executionOptions = new ExecutionOptions.Builder().build();
        }
        if (this.zzafa.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzbX(executionOptions.zzpk()) && !this.zzafa.zzpc()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        ExecutionOptions.zza(apiClient, executionOptions);
        if (this.zzpg()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet = changeSet != null ? changeSet : MetadataChangeSet.zzads;
        final ExecutionOptions executionOptions2 = executionOptions;
        this.zzpf();
        return apiClient.zzb((zza.zza)new zzr.zza(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                metadataChangeSet.zzpm().setContext(zzs2.getContext());
                zzs2.zzpB().zza(new CloseContentsAndUpdateMetadataRequest(zzt.this.zzafa.getDriveId(), metadataChangeSet.zzpm(), zzt.this.zzafa.getRequestId(), zzt.this.zzafa.zzpc(), executionOptions2), (zzal)new zzbq((zza.zzb<Status>)this));
            }
        });
    }

    @Override
    public void discard(GoogleApiClient apiClient) {
        if (this.zzpg()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzpf();
        (apiClient.zzb((zza.zza)new zzr.zza(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new CloseContentsRequest(zzt.this.zzafa.getRequestId(), false), (zzal)new zzbq((zza.zzb<Status>)this));
            }
        })).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzm(Status status) {
                if (!status.isSuccess()) {
                    zzx.zzv("DriveContentsImpl", "Error discarding contents");
                } else {
                    zzx.zzt("DriveContentsImpl", "Contents discarded");
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zzm((Status)x0);
            }
        });
    }

    @Override
    public Contents zzpe() {
        return this.zzafa;
    }

    @Override
    public void zzpf() {
        zzlg.zza((ParcelFileDescriptor)this.zzafa.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public boolean zzpg() {
        return this.mClosed;
    }
}

