/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableOptions;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.internal.AddEventListenerRequest;
import com.google.android.gms.drive.internal.CancelPendingActionsRequest;
import com.google.android.gms.drive.internal.DisconnectRequest;
import com.google.android.gms.drive.internal.RemoveEventListenerRequest;
import com.google.android.gms.drive.internal.zzac;
import com.google.android.gms.drive.internal.zzak;
import com.google.android.gms.drive.internal.zzal;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzbq;
import com.google.android.gms.drive.internal.zzq;
import com.google.android.gms.drive.internal.zzr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzs
extends zzi<zzak> {
    private final String zzOe;
    private final Bundle zzaeM;
    private final boolean zzaeN;
    private DriveId zzaeO;
    private DriveId zzaeP;
    final GoogleApiClient.ConnectionCallbacks zzaar;
    final Map<DriveId, Map<ChangeListener, zzac>> zzaeQ = new HashMap<DriveId, Map<ChangeListener, zzac>>();
    final Map<zzc, zzac> zzaeR = new HashMap<zzc, zzac>();
    final Map<DriveId, Map<com.google.android.gms.drive.events.zzi, zzac>> zzaeS = new HashMap<DriveId, Map<com.google.android.gms.drive.events.zzi, zzac>>();
    final Map<DriveId, Map<com.google.android.gms.drive.events.zzi, zzac>> zzaeT = new HashMap<DriveId, Map<com.google.android.gms.drive.events.zzi, zzac>>();

    public zzs(Context context, Looper looper, zze zze2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, connectionCallbacks, onConnectionFailedListener, zze2);
        this.zzOe = zze2.zzny();
        this.zzaar = connectionCallbacks;
        this.zzaeM = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzaeN = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    throw new IllegalStateException("Drive event service " + serviceInfo.name + " must be exported in AndroidManifest.xml");
                }
                this.zzaeN = true;
                break;
            }
            default: {
                throw new IllegalStateException("AndroidManifest.xml can only define one service that handles the " + intent.getAction() + " action");
            }
        }
    }

    public boolean requiresSignIn() {
        return true;
    }

    protected zzak zzaN(IBinder iBinder) {
        return zzak.zza.zzaO(iBinder);
    }

    protected String getServiceDescriptor() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected Bundle zzkR() {
        String string = this.getContext().getPackageName();
        zzu.zzu((Object)string);
        zzu.zzU((!this.zznK().zznw().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzOe)) {
            bundle.putString("proxy_package_name", this.zzOe);
        }
        bundle.putAll(this.zzaeM);
        return bundle;
    }

    protected String getStartServiceAction() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public zzak zzpB() throws DeadObjectException {
        return (zzak)this.zznM();
    }

    public DriveId zzpC() {
        return this.zzaeO;
    }

    public DriveId zzpD() {
        return this.zzaeP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Map<Object, Object> map;
        if (this.isConnected()) {
            try {
                map = (zzak)this.zznM();
                map.zza(new DisconnectRequest());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.disconnect();
        map = this.zzaeQ;
        synchronized (map) {
            this.zzaeQ.clear();
        }
        map = this.zzaeR;
        synchronized (map) {
            this.zzaeR.clear();
        }
        map = this.zzaeS;
        synchronized (map) {
            this.zzaeS.clear();
        }
        map = this.zzaeT;
        synchronized (map) {
            this.zzaeT.clear();
        }
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzaeO = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzaeP = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public boolean zzpE() {
        return this.zzaeN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzu.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzu.zzb((Object)changeListener, (Object)"listener");
        zzu.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzac>> map = this.zzaeQ;
        synchronized (map) {
            zzac zzac2;
            Map<ChangeListener, zzac> map2 = this.zzaeQ.get(driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzac>();
                this.zzaeQ.put(driveId, map2);
            }
            if ((zzac2 = map2.get(changeListener)) == null) {
                zzac2 = new zzac(this.getLooper(), this.getContext(), n, changeListener);
                map2.put(changeListener, zzac2);
            } else if (zzac2.zzcB(n)) {
                return new zzq.zzj(googleApiClient, Status.zzXP);
            }
            zzac2.zzcA(n);
            return this.zza(googleApiClient, n, driveId, zzac2, null);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final zzac zzac2, final ChangesAvailableOptions changesAvailableOptions) {
        return googleApiClient.zzb((zza.zza)new zzr.zza(googleApiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new AddEventListenerRequest(driveId, n, changesAvailableOptions), (zzam)zzac2, null, (zzal)new zzbq((zza.zzb<Status>)this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzu.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzu.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzu.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzac>> map = this.zzaeQ;
        synchronized (map) {
            Map<ChangeListener, zzac> map2 = this.zzaeQ.get(driveId);
            if (map2 == null) {
                return new zzq.zzj(googleApiClient, Status.zzXP);
            }
            zzac zzac2 = map2.remove(changeListener);
            if (zzac2 == null) {
                return new zzq.zzj(googleApiClient, Status.zzXP);
            }
            if (map2.isEmpty()) {
                this.zzaeQ.remove(driveId);
            }
            return this.zza(googleApiClient, n, driveId, zzac2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final zzac zzac2) {
        return googleApiClient.zzb((zza.zza)new zzr.zza(googleApiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new RemoveEventListenerRequest(driveId, n), (zzam)zzac2, null, (zzal)new zzbq((zza.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId, (ChangesAvailableOptions)null);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final ChangesAvailableOptions changesAvailableOptions) {
        zzu.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzu.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        if (!this.zzaeN) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.zzb((zza.zza)new zzr.zza(googleApiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new AddEventListenerRequest(driveId, n, changesAvailableOptions), null, null, (zzal)new zzbq((zza.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId) {
        zzu.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzu.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzb((zza.zza)new zzr.zza(googleApiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new RemoveEventListenerRequest(driveId, n), null, null, (zzal)new zzbq((zza.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, final List<String> pendingTags) {
        zzu.zzV((pendingTags != null ? 1 : 0) != 0);
        zzu.zzV((!pendingTags.isEmpty() ? 1 : 0) != 0);
        zzu.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return apiClient.zzb((zza.zza)new zzr.zza(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new CancelPendingActionsRequest(pendingTags), (zzal)new zzbq((zza.zzb<Status>)this));
            }
        });
    }

    protected /* synthetic */ IInterface zzT(IBinder iBinder) {
        return this.zzaN(iBinder);
    }
}

