/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzt;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
implements SafeParcelable {
    private final int zzCY;
    private final int zzakB;
    private boolean zzakR;
    private float zzakF;
    private String zzakS;
    private Map<String, MapValue> zzakT;
    public static final Parcelable.Creator<Value> CREATOR = new zzt();

    public Value(int format) {
        this(2, format, false, 0.0f, null, null);
    }

    Value(int versionCode, int format, boolean isSet, float value, String stringValue, Bundle mapValue) {
        this.zzCY = versionCode;
        this.zzakB = format;
        this.zzakR = isSet;
        this.zzakF = value;
        this.zzakS = stringValue;
        this.zzakT = Value.zzr(mapValue);
    }

    public void setInt(int value) {
        zzu.zza((this.zzakB == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzakR = true;
        this.zzakF = Float.intBitsToFloat(value);
    }

    public void setFloat(float value) {
        zzu.zza((this.zzakB == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzakR = true;
        this.zzakF = value;
    }

    public void setString(String value) {
        zzu.zza((this.zzakB == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzakR = true;
        this.zzakS = value;
    }

    public void setKeyValue(String key, float value) {
        zzu.zza((this.zzakB == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzakR = true;
        if (this.zzakT == null) {
            this.zzakT = new HashMap<String, MapValue>();
        }
        this.zzakT.put(key, MapValue.zzc(value));
    }

    public void clearKey(String key) {
        zzu.zza((this.zzakB == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zzakT != null) {
            this.zzakT.remove(key);
        }
    }

    public void setActivity(String activity) {
        this.setInt(FitnessActivities.zzcF(activity));
    }

    public boolean isSet() {
        return this.zzakR;
    }

    public int getFormat() {
        return this.zzakB;
    }

    public int asInt() {
        zzu.zza((this.zzakB == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.zzakF);
    }

    public float asFloat() {
        zzu.zza((this.zzakB == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.zzakF;
    }

    public String asString() {
        zzu.zza((this.zzakB == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzakS;
    }

    public Float getKeyValue(String key) {
        zzu.zza((this.zzakB == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zzakT != null && this.zzakT.containsKey(key)) {
            return Float.valueOf(this.zzakT.get(key).asFloat());
        }
        return null;
    }

    public Map<String, MapValue> zzpT() {
        zzu.zza((this.zzakB == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        return this.zzakT == null ? Collections.emptyMap() : this.zzakT;
    }

    public String asActivity() {
        return FitnessActivities.getName(this.asInt());
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Value && this.zza((Value)o);
    }

    private boolean zza(Value value) {
        if (this.zzakB == value.zzakB && this.zzakR == value.zzakR) {
            switch (this.zzakB) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.asFloat() == value.asFloat();
                }
                case 3: {
                    return this.asString().equals(value.asString());
                }
                case 4: {
                    return this.zzpT().equals(value.zzpT());
                }
            }
            return this.zzakF == value.zzakF;
        }
        return false;
    }

    public int hashCode() {
        return com.google.android.gms.common.internal.zzt.hashCode((Object[])new Object[]{Float.valueOf(this.zzakF), this.zzakS, this.zzakT});
    }

    public String toString() {
        if (!this.zzakR) {
            return "unset";
        }
        switch (this.zzakB) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.asFloat());
            }
            case 3: {
                return this.zzakS;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zzakT).toString();
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.zzCY;
    }

    float zzqI() {
        return this.zzakF;
    }

    String zzqO() {
        return this.zzakS;
    }

    Bundle zzqP() {
        if (this.zzakT == null) {
            return null;
        }
        Bundle bundle = new Bundle(this.zzakT.size());
        for (Map.Entry<String, MapValue> entry : this.zzakT.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
        }
        return bundle;
    }

    private static Map<String, MapValue> zzr(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(MapValue.class.getClassLoader());
        ArrayMap arrayMap = new ArrayMap(bundle.size());
        for (String string : bundle.keySet()) {
            arrayMap.put(string, bundle.getParcelable(string));
        }
        return arrayMap;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzt.zza(this, dest, flags);
    }
}

