/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzld;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzal;
import com.google.android.gms.tagmanager.zzbg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

class zzw
implements DataLayer.zzc {
    private static final String zzaLp = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' STRING NOT NULL, '%s' BLOB NOT NULL, '%s' INTEGER NOT NULL);", "datalayer", "ID", "key", "value", "expires");
    private final Executor zzaLq;
    private final Context mContext;
    private zza zzaLr;
    private zzlb zzpw;
    private int zzaLs;

    public zzw(Context context) {
        this(context, zzld.zzoQ(), "google_tagmanager.db", 2000, Executors.newSingleThreadExecutor());
    }

    zzw(Context context, zzlb zzlb2, String string, int n, Executor executor) {
        this.mContext = context;
        this.zzpw = zzlb2;
        this.zzaLs = n;
        this.zzaLq = executor;
        this.zzaLr = new zza(this.mContext, string);
    }

    @Override
    public void zza(List<DataLayer.zza> list, final long l) {
        final List<zzb> list2 = this.zzq(list);
        this.zzaLq.execute(new Runnable(){

            @Override
            public void run() {
                zzw.this.zzb(list2, l);
            }
        });
    }

    @Override
    public void zza(final DataLayer.zzc.zza zza2) {
        this.zzaLq.execute(new Runnable(){

            @Override
            public void run() {
                zza2.zzo(zzw.this.zzyC());
            }
        });
    }

    @Override
    public void zzep(final String string) {
        this.zzaLq.execute(new Runnable(){

            @Override
            public void run() {
                zzw.this.zzeq(string);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataLayer.zza> zzyC() {
        try {
            this.zzS(this.zzpw.currentTimeMillis());
            List<DataLayer.zza> list = this.zzp(this.zzyD());
            return list;
        }
        finally {
            this.zzyF();
        }
    }

    private List<DataLayer.zza> zzp(List<zzb> list) {
        ArrayList<DataLayer.zza> arrayList = new ArrayList<DataLayer.zza>();
        for (zzb zzb2 : list) {
            arrayList.add(new DataLayer.zza(zzb2.zztw, this.zzq(zzb2.zzaLy)));
        }
        return arrayList;
    }

    private List<zzb> zzq(List<DataLayer.zza> list) {
        ArrayList<zzb> arrayList = new ArrayList<zzb>();
        for (DataLayer.zza zza2 : list) {
            arrayList.add(new zzb(zza2.zztw, this.zzA(zza2.zzGK)));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object zzq(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (IOException iOException) {
            Object var5_8 = null;
            return var5_8;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object var5_9 = null;
            return var5_9;
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zzA(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void zzb(List<zzb> list, long l) {
        try {
            long l2 = this.zzpw.currentTimeMillis();
            this.zzS(l2);
            this.zziS(list.size());
            this.zzc(list, l2 + l);
        }
        finally {
            this.zzyF();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<zzb> zzyD() {
        SQLiteDatabase sQLiteDatabase = this.zzer("Error opening database for loadSerialized.");
        ArrayList<zzb> arrayList = new ArrayList<zzb>();
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        String[] stringArray = new String[]{"key", "value"};
        try (Cursor cursor = sQLiteDatabase.query("datalayer", stringArray, null, null, null, null, "ID", null);){
            while (cursor.moveToNext()) {
                arrayList.add(new zzb(cursor.getString(0), cursor.getBlob(1)));
            }
        }
        return arrayList;
    }

    private void zzc(List<zzb> list, long l) {
        SQLiteDatabase sQLiteDatabase = this.zzer("Error opening database for writeEntryToDatabase.");
        if (sQLiteDatabase == null) {
            return;
        }
        for (zzb zzb2 : list) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("expires", Long.valueOf(l));
            contentValues.put("key", zzb2.zztw);
            contentValues.put("value", zzb2.zzaLy);
            sQLiteDatabase.insert("datalayer", null, contentValues);
        }
    }

    private void zziS(int n) {
        int n2 = this.zzyE() - this.zzaLs + n;
        if (n2 > 0) {
            List<String> list = this.zziT(n2);
            zzbg.zzaA("DataLayer store full, deleting " + list.size() + " entries to make room.");
            this.zze(list.toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzeq(String string) {
        SQLiteDatabase sQLiteDatabase = this.zzer("Error opening database for clearKeysWithPrefix.");
        if (sQLiteDatabase == null) {
            return;
        }
        try {
            int n = sQLiteDatabase.delete("datalayer", "key = ? OR key LIKE ?", new String[]{string, string + ".%"});
            zzbg.zzaB("Cleared " + n + " items");
        }
        catch (SQLiteException sQLiteException) {
            zzbg.zzaC("Error deleting entries with key prefix: " + string + " (" + (Object)((Object)sQLiteException) + ").");
        }
        finally {
            this.zzyF();
        }
    }

    private void zzS(long l) {
        SQLiteDatabase sQLiteDatabase = this.zzer("Error opening database for deleteOlderThan.");
        if (sQLiteDatabase == null) {
            return;
        }
        try {
            int n = sQLiteDatabase.delete("datalayer", "expires <= ?", new String[]{Long.toString(l)});
            zzbg.zzaB("Deleted " + n + " expired items");
        }
        catch (SQLiteException sQLiteException) {
            zzbg.zzaC("Error deleting old entries.");
        }
    }

    private void zze(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.zzer("Error opening database for deleteEntries.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("%s in (%s)", "ID", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("datalayer", string, stringArray);
        }
        catch (SQLiteException sQLiteException) {
            zzbg.zzaC("Error deleting entries " + Arrays.toString(stringArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> zziT(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n <= 0) {
            zzbg.zzaC("Invalid maxEntries specified. Skipping.");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.zzer("Error opening database for peekEntryIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("datalayer", new String[]{"ID"}, null, null, null, null, String.format("%s ASC", "ID"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzyE() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzer("Error opening database for getNumStoredEntries.");
        if (sQLiteDatabase == null) {
            return n;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from datalayer", null);
            if (cursor.moveToFirst()) {
                n = (int)cursor.getLong(0);
            }
        }
        return n;
    }

    private SQLiteDatabase zzer(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.zzaLr.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            zzbg.zzaC(string);
            return null;
        }
        return sQLiteDatabase;
    }

    private void zzyF() {
        try {
            this.zzaLr.close();
        }
        catch (SQLiteException sQLiteException) {
            // empty catch block
        }
    }

    private static class zzb {
        final String zztw;
        final byte[] zzaLy;

        zzb(String string, byte[] byArray) {
            this.zztw = string;
            this.zzaLy = byArray;
        }

        public String toString() {
            return "KeyAndSerialized: key = " + this.zztw + " serialized hash = " + Arrays.hashCode(this.zzaLy);
        }
    }

    class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string) {
            super(context, string, null, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(String string, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            SQLiteDatabase sQLiteDatabase = null;
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzw.this.mContext.getDatabasePath("google_tagmanager.db").delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = db.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza("datalayer", db)) {
                db.execSQL(zzaLp);
            } else {
                this.zzc(db);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zzc(SQLiteDatabase sQLiteDatabase) {
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM datalayer WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            if (!(hashSet.remove("key") && hashSet.remove("value") && hashSet.remove("ID") && hashSet.remove("expires"))) {
                throw new SQLiteException("Database column missing");
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase db) {
            zzal.zzbe(db.getPath());
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

