/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzql;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzs;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class zzcl
implements Runnable {
    private final Context mContext;
    private final zzqm zzaMS;
    private final String zzaKy;
    private final String zzaMT;
    private zzbf<zzaf.zzj> zzaMU;
    private volatile zzs zzaMV;
    private volatile String zzaKV;
    private volatile String zzaMW;

    public zzcl(Context context, String string, zzs zzs2) {
        this(context, string, new zzqm(), zzs2);
    }

    zzcl(Context context, String string, zzqm zzqm2, zzs zzs2) {
        this.mContext = context;
        this.zzaMS = zzqm2;
        this.zzaKy = string;
        this.zzaMV = zzs2;
        this.zzaKV = this.zzaMT = "/r?id=" + string;
        this.zzaMW = null;
    }

    @Override
    public void run() {
        if (this.zzaMU == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.zzaMU.zzyv();
        this.zzzj();
    }

    private boolean zzzi() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbg.zzaB("...no network connectivity");
            return false;
        }
        return true;
    }

    void zza(zzbf<zzaf.zzj> zzbf2) {
        this.zzaMU = zzbf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zzzj() {
        block12: {
            if (!this.zzzi()) {
                this.zzaMU.zza(zzbf.zza.zzaMi);
                return;
            }
            zzbg.zzaB("Start loading resource from network ...");
            String string = this.zzzk();
            InputStream inputStream = null;
            try (zzql zzql2 = this.zzaMS.zzAG();){
                try {
                    inputStream = zzql2.zzfd(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zzbg.zzaC("No data is retrieved from the given url: " + string + ". Make sure container_id: " + this.zzaKy + " is correct.");
                    this.zzaMU.zza(zzbf.zza.zzaMk);
                    zzql2.close();
                    return;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when loading resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaMU.zza(zzbf.zza.zzaMj);
                    zzql2.close();
                    return;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    zzqf.zzc(inputStream, byteArrayOutputStream);
                    zzaf.zzj zzj2 = zzaf.zzj.zzd(byteArrayOutputStream.toByteArray());
                    zzbg.zzaB("Successfully loaded supplemented resource: " + (Object)((Object)zzj2));
                    if (zzj2.zziO == null && zzj2.zziN.length == 0) {
                        zzbg.zzaB("No change for container: " + this.zzaKy);
                    }
                    this.zzaMU.zzz(zzj2);
                    break block12;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when parsing downloaded resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaMU.zza(zzbf.zza.zzaMk);
                    zzql2.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        zzbg.zzaB("Load resource from network finished.");
    }

    String zzzk() {
        String string = this.zzaMV.zzyx() + this.zzaKV + "&v=a65833898";
        if (this.zzaMW != null && !this.zzaMW.trim().equals("")) {
            string = string + "&pv=" + this.zzaMW;
        }
        if (zzcb.zzzf().zzzg().equals((Object)zzcb.zza.zzaMK)) {
            string = string + "&gtm_debug=x";
        }
        return string;
    }

    void zzem(String string) {
        if (string == null) {
            this.zzaKV = this.zzaMT;
        } else {
            zzbg.zzay("Setting CTFE URL path: " + string);
            this.zzaKV = string;
        }
    }

    void zzeB(String string) {
        zzbg.zzay("Setting previous container version: " + string);
        this.zzaMW = string;
    }
}

