/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import com.google.android.gms.tagmanager.zzbg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataLayer {
    public static final Object OBJECT_NOT_PRESENT = new Object();
    public static final String EVENT_KEY = "event";
    static final String[] zzaLf = "gtm.lifetime".toString().split("\\.");
    private static final Pattern zzaLg = Pattern.compile("(\\d+)\\s*([smhd]?)");
    private final ConcurrentHashMap<zzb, Integer> zzaLh;
    private final Map<String, Object> zzaLi;
    private final ReentrantLock zzaLj;
    private final LinkedList<Map<String, Object>> zzaLk;
    private final zzc zzaLl;
    private final CountDownLatch zzaLm;

    DataLayer() {
        this(new zzc(){

            @Override
            public void zza(List<zza> list, long l) {
            }

            @Override
            public void zza(zzc.zza zza2) {
                zza2.zzo(new ArrayList<zza>());
            }

            @Override
            public void zzep(String string) {
            }
        });
    }

    DataLayer(zzc persistentStore) {
        this.zzaLl = persistentStore;
        this.zzaLh = new ConcurrentHashMap();
        this.zzaLi = new HashMap<String, Object>();
        this.zzaLj = new ReentrantLock();
        this.zzaLk = new LinkedList();
        this.zzaLm = new CountDownLatch(1);
        this.zzyy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<String, Object> map = this.zzaLi;
        synchronized (map) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : this.zzaLi.entrySet()) {
                stringBuilder.append(String.format("{\n\tKey: %s\n\tValue: %s\n}\n", entry.getKey(), entry.getValue()));
            }
            return stringBuilder.toString();
        }
    }

    public void pushEvent(String eventName, Map<String, Object> update) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(update);
        hashMap.put(EVENT_KEY, eventName);
        this.push(hashMap);
    }

    public void push(String key, Object value) {
        Map<String, Object> map = this.zzj(key, value);
        this.push(map);
    }

    public void push(Map<String, Object> update) {
        try {
            this.zzaLm.await();
        }
        catch (InterruptedException interruptedException) {
            zzbg.zzaC("DataLayer.push: unexpected InterruptedException");
        }
        this.zzH(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzH(Map<String, Object> map) {
        this.zzaLj.lock();
        try {
            this.zzaLk.offer(map);
            if (this.zzaLj.getHoldCount() == 1) {
                this.zzyz();
            }
            this.zzI(map);
        }
        finally {
            this.zzaLj.unlock();
        }
    }

    private void zzyy() {
        this.zzaLl.zza(new zzc.zza(){

            @Override
            public void zzo(List<zza> list) {
                for (zza zza2 : list) {
                    DataLayer.this.zzH(DataLayer.this.zzj(zza2.zztw, zza2.zzGK));
                }
                DataLayer.this.zzaLm.countDown();
            }
        });
    }

    private void zzI(Map<String, Object> map) {
        Long l = this.zzJ(map);
        if (l == null) {
            return;
        }
        List<zza> list = this.zzL(map);
        list.remove("gtm.lifetime");
        this.zzaLl.zza(list, l);
    }

    private Long zzJ(Map<String, Object> map) {
        Object object = this.zzK(map);
        if (object == null) {
            return null;
        }
        return DataLayer.zzeo(object.toString());
    }

    private Object zzK(Map<String, Object> map) {
        Object object = map;
        for (String string : zzaLf) {
            if (!(object instanceof Map)) {
                return null;
            }
            Map<String, Object> map2 = object;
            object = map2.get(string);
        }
        return object;
    }

    void zzen(String string) {
        this.push(string, null);
        this.zzaLl.zzep(string);
    }

    private List<zza> zzL(Map<String, Object> map) {
        ArrayList<zza> arrayList = new ArrayList<zza>();
        this.zza(map, "", arrayList);
        return arrayList;
    }

    private void zza(Map<String, Object> map, String string, Collection<zza> collection) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = string + (string.length() == 0 ? "" : ".") + entry.getKey();
            if (entry.getValue() instanceof Map) {
                Map map2 = (Map)entry.getValue();
                this.zza(map2, string2, collection);
                continue;
            }
            if (string2.equals("gtm.lifetime")) continue;
            collection.add(new zza(string2, entry.getValue()));
        }
    }

    static Long zzeo(String string) {
        Matcher matcher = zzaLg.matcher(string);
        if (!matcher.matches()) {
            zzbg.zzaA("unknown _lifetime: " + string);
            return null;
        }
        long l = 0L;
        try {
            l = Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            zzbg.zzaC("illegal number in _lifetime value: " + string);
        }
        if (l <= 0L) {
            zzbg.zzaA("non-positive _lifetime: " + string);
            return null;
        }
        String string2 = matcher.group(2);
        if (string2.length() == 0) {
            return l;
        }
        switch (string2.charAt(0)) {
            case 's': {
                return l * 1000L;
            }
            case 'm': {
                return l * 1000L * 60L;
            }
            case 'h': {
                return l * 1000L * 60L * 60L;
            }
            case 'd': {
                return l * 1000L * 60L * 60L * 24L;
            }
        }
        zzbg.zzaC("unknown units in _lifetime: " + string);
        return null;
    }

    private void zzyz() {
        Map<String, Object> map;
        int n = 0;
        while ((map = this.zzaLk.poll()) != null) {
            this.zzM(map);
            if (++n <= 500) continue;
            this.zzaLk.clear();
            throw new RuntimeException("Seems like an infinite loop of pushing to the data layer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzM(Map<String, Object> map) {
        Map<String, Object> map2 = this.zzaLi;
        synchronized (map2) {
            for (String string : map.keySet()) {
                this.zzc(this.zzj(string, map.get(string)), this.zzaLi);
            }
        }
        this.zzN(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Map<String, Object> map = this.zzaLi;
        synchronized (map) {
            String[] stringArray;
            Object object = this.zzaLi;
            for (String string : stringArray = key.split("\\.")) {
                if (!(object instanceof Map)) {
                    return null;
                }
                Object object2 = object;
                Object object3 = object2.get(string);
                if (object3 == null) {
                    return null;
                }
                object = object3;
            }
            return object;
        }
    }

    public static Map<String, Object> mapOf(Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("expected even number of key-value pairs");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            if (!(objects[i] instanceof String)) {
                throw new IllegalArgumentException("key is not a string: " + objects[i]);
            }
            hashMap.put((String)objects[i], objects[i + 1]);
        }
        return hashMap;
    }

    public static List<Object> listOf(Object ... objects) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            arrayList.add(objects[i]);
        }
        return arrayList;
    }

    void zza(zzb zzb2) {
        this.zzaLh.put(zzb2, 0);
    }

    private void zzN(Map<String, Object> map) {
        for (zzb zzb2 : this.zzaLh.keySet()) {
            zzb2.zzF(map);
        }
    }

    Map<String, Object> zzj(String string, Object object) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap = new HashMap<String, Object>();
        String[] stringArray = string.toString().split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            HashMap hashMap3 = new HashMap();
            hashMap2.put(stringArray[i], hashMap3);
            hashMap2 = hashMap3;
        }
        hashMap2.put(stringArray[stringArray.length - 1], object);
        return hashMap;
    }

    void zzc(Map<String, Object> map, Map<String, Object> map2) {
        for (String string : map.keySet()) {
            Object object;
            Object object2;
            Object object3 = map.get(string);
            if (object3 instanceof List) {
                if (!(map2.get(string) instanceof List)) {
                    map2.put(string, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)map2.get(string);
                this.zzb((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(map2.get(string) instanceof Map)) {
                    map2.put(string, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)map2.get(string);
                this.zzc((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            map2.put(string, object3);
        }
    }

    void zzb(List<Object> list, List<Object> list2) {
        while (list2.size() < list.size()) {
            list2.add(null);
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            Object object3 = list.get(i);
            if (object3 instanceof List) {
                if (!(list2.get(i) instanceof List)) {
                    list2.set(i, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)list2.get(i);
                this.zzb((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(list2.get(i) instanceof Map)) {
                    list2.set(i, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)list2.get(i);
                this.zzc((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            if (object3 == OBJECT_NOT_PRESENT) continue;
            list2.set(i, object3);
        }
    }

    static interface zzc {
        public void zza(List<com.google.android.gms.tagmanager.DataLayer$zza> var1, long var2);

        public void zza(zza var1);

        public void zzep(String var1);

        public static interface zza {
            public void zzo(List<com.google.android.gms.tagmanager.DataLayer$zza> var1);
        }
    }

    static final class zza {
        public final String zztw;
        public final Object zzGK;

        zza(String string, Object object) {
            this.zztw = string;
            this.zzGK = object;
        }

        public String toString() {
            return "Key: " + this.zztw + " value: " + this.zzGK.toString();
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])new Integer[]{this.zztw.hashCode(), this.zzGK.hashCode()});
        }

        public boolean equals(Object o) {
            if (!(o instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)o;
            return this.zztw.equals(zza2.zztw) && this.zzGK.equals(zza2.zzGK);
        }
    }

    static interface zzb {
        public void zzF(Map<String, Object> var1);
    }
}

