/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.LocationRequestUpdateData;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzn;
import com.google.android.gms.location.zzc;
import com.google.android.gms.location.zzd;
import java.util.HashMap;
import java.util.Map;

public class zzi {
    private final zzn<zzg> zzayq;
    private final Context mContext;
    private ContentProviderClient zzayL = null;
    private boolean zzayM = false;
    private Map<LocationListener, zzc> zzakE = new HashMap<LocationListener, zzc>();
    private Map<LocationCallback, zza> zzayN = new HashMap<LocationCallback, zza>();

    public zzi(Context context, zzn<zzg> zzn2) {
        this.mContext = context;
        this.zzayq = zzn2;
    }

    public Location getLastLocation() {
        this.zzayq.zznL();
        try {
            return this.zzayq.zznM().zzdl(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public LocationAvailability zzuw() {
        this.zzayq.zznL();
        try {
            return this.zzayq.zznM().zzdm(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper) throws RemoteException {
        this.zzayq.zznL();
        zzc zzc2 = this.zza(locationListener, looper);
        this.zzayq.zznM().zza(LocationRequestUpdateData.zzb(LocationRequestInternal.zzb(locationRequest), zzc2));
    }

    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper) throws RemoteException {
        this.zzayq.zznL();
        zza zza2 = this.zza(locationCallback, looper);
        this.zzayq.zznM().zza(LocationRequestUpdateData.zza(locationRequestInternal, zza2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zza(LocationListener locationListener, Looper looper) {
        Map<LocationListener, zzc> map = this.zzakE;
        synchronized (map) {
            zzc zzc2 = this.zzakE.get(locationListener);
            if (zzc2 == null) {
                zzc2 = new zzc(locationListener, looper);
            }
            this.zzakE.put(locationListener, zzc2);
            return zzc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zza zza(LocationCallback locationCallback, Looper looper) {
        Map<LocationListener, zzc> map = this.zzakE;
        synchronized (map) {
            zza zza2 = this.zzayN.get(locationCallback);
            if (zza2 == null) {
                zza2 = new zza(locationCallback, looper);
            }
            this.zzayN.put(locationCallback, zza2);
            return zza2;
        }
    }

    public void zzb(LocationRequest locationRequest, PendingIntent pendingIntent) throws RemoteException {
        this.zzayq.zznL();
        this.zzayq.zznM().zza(LocationRequestUpdateData.zzb(LocationRequestInternal.zzb(locationRequest), pendingIntent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationListener locationListener) throws RemoteException {
        this.zzayq.zznL();
        zzu.zzb((Object)locationListener, (Object)"Invalid null listener");
        Map<LocationListener, zzc> map = this.zzakE;
        synchronized (map) {
            zzc zzc2 = this.zzakE.remove(locationListener);
            if (this.zzayL != null && this.zzakE.isEmpty()) {
                this.zzayL.release();
                this.zzayL = null;
            }
            if (zzc2 != null) {
                zzc2.release();
                this.zzayq.zznM().zza(LocationRequestUpdateData.zzb(zzc2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationCallback locationCallback) throws RemoteException {
        this.zzayq.zznL();
        zzu.zzb((Object)locationCallback, (Object)"Invalid null callback");
        Map<LocationCallback, zza> map = this.zzayN;
        synchronized (map) {
            zza zza2 = this.zzayN.remove(locationCallback);
            if (zza2 != null) {
                zza2.release();
                this.zzayq.zznM().zza(LocationRequestUpdateData.zza(zza2));
            }
        }
    }

    public void zzd(PendingIntent pendingIntent) throws RemoteException {
        this.zzayq.zznL();
        this.zzayq.zznM().zza(LocationRequestUpdateData.zze(pendingIntent));
    }

    public void zzac(boolean bl) throws RemoteException {
        this.zzayq.zznL();
        this.zzayq.zznM().zzac(bl);
        this.zzayM = bl;
    }

    public void zzb(Location location) throws RemoteException {
        this.zzayq.zznL();
        this.zzayq.zznM().zzb(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            Map<LocationListener, zzc> map = this.zzakE;
            synchronized (map) {
                for (zzc binder : this.zzakE.values()) {
                    if (binder == null) continue;
                    this.zzayq.zznM().zza(LocationRequestUpdateData.zzb(binder));
                }
                this.zzakE.clear();
                for (zza zza2 : this.zzayN.values()) {
                    if (zza2 == null) continue;
                    this.zzayq.zznM().zza(LocationRequestUpdateData.zza(zza2));
                }
                this.zzayN.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zzux() {
        if (this.zzayM) {
            try {
                this.zzac(false);
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    private static class zzb
    extends Handler {
        private final LocationListener zzayQ;

        public zzb(LocationListener locationListener) {
            this.zzayQ = locationListener;
        }

        public zzb(LocationListener locationListener, Looper looper) {
            super(looper);
            this.zzayQ = locationListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.zzayQ.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    private static class zza
    extends zzc.zza {
        private Handler zzayO;

        zza(final LocationCallback locationCallback, Looper looper) {
            if (looper == null) {
                looper = Looper.myLooper();
                zzu.zza((looper != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzayO = new Handler(looper){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            locationCallback.onLocationResult((LocationResult)msg.obj);
                            break;
                        }
                        case 1: {
                            locationCallback.onLocationAvailability((LocationAvailability)msg.obj);
                        }
                    }
                }
            };
        }

        @Override
        public void onLocationResult(LocationResult locationResult) {
            this.zzb(0, locationResult);
        }

        @Override
        public void onLocationAvailability(LocationAvailability state) {
            this.zzb(1, state);
        }

        public void release() {
            this.zzayO = null;
        }

        private void zzb(int n, Object object) {
            if (this.zzayO == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a data in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = n;
            message.obj = object;
            this.zzayO.sendMessage(message);
        }
    }

    private static class zzc
    extends zzd.zza {
        private Handler zzayO;

        zzc(LocationListener locationListener, Looper looper) {
            if (looper == null) {
                zzu.zza((Looper.myLooper() != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzayO = looper == null ? new zzb(locationListener) : new zzb(locationListener, looper);
        }

        @Override
        public void onLocationChanged(Location location) {
            if (this.zzayO == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.zzayO.sendMessage(message);
        }

        public void release() {
            this.zzayO = null;
        }
    }
}

