/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.Dialog;
import android.content.Context;
import android.content.IntentSender;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.support.v7.app.MediaRouterThemeHelper;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.support.v7.mediarouter.R;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;

public class MediaRouteControllerDialog
extends Dialog {
    private static final String TAG = "MediaRouteControllerDialog";
    private final MediaRouter mRouter;
    private final MediaRouterCallback mCallback;
    private final MediaRouter.RouteInfo mRoute;
    private boolean mCreated;
    private boolean mAttachedToWindow;
    private Drawable mMediaRouteConnectingDrawable;
    private Drawable mMediaRouteOnDrawable;
    private Drawable mCurrentIconDrawable;
    private Drawable mSettingsDrawable;
    private View mControlView;
    private Button mDisconnectButton;
    private Button mStopCastingButton;
    private ImageButton mPlayPauseButton;
    private ImageButton mSettingsButton;
    private ImageView mArtView;
    private TextView mTitleView;
    private TextView mSubtitleView;
    private TextView mRouteNameView;
    private View mTitlesWrapper;
    private MediaControllerCompat mMediaController;
    private MediaControllerCallback mControllerCallback;
    private PlaybackStateCompat mState;
    private MediaDescriptionCompat mDescription;

    public MediaRouteControllerDialog(Context context) {
        this(context, 0);
    }

    public MediaRouteControllerDialog(Context context, int theme) {
        super(MediaRouterThemeHelper.createThemedContext(context), theme);
        context = this.getContext();
        this.mControllerCallback = new MediaControllerCallback();
        this.mRouter = MediaRouter.getInstance(context);
        this.mCallback = new MediaRouterCallback();
        this.mRoute = this.mRouter.getSelectedRoute();
        this.setMediaSession(this.mRouter.getMediaSessionToken());
    }

    public MediaRouter.RouteInfo getRoute() {
        return this.mRoute;
    }

    public View onCreateMediaControlView(Bundle savedInstanceState) {
        return null;
    }

    public View getMediaControlView() {
        return this.mControlView;
    }

    private void setMediaSession(MediaSessionCompat.Token sessionToken) {
        if (this.mMediaController != null) {
            this.mMediaController.unregisterCallback((MediaControllerCompat.Callback)this.mControllerCallback);
            this.mMediaController = null;
        }
        if (sessionToken == null) {
            return;
        }
        if (!this.mAttachedToWindow) {
            return;
        }
        try {
            this.mMediaController = new MediaControllerCompat(this.getContext(), sessionToken);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error creating media controller in setMediaSession.", (Throwable)e);
        }
        if (this.mMediaController != null) {
            this.mMediaController.registerCallback((MediaControllerCompat.Callback)this.mControllerCallback);
        }
        MediaMetadataCompat metadata = this.mMediaController == null ? null : this.mMediaController.getMetadata();
        this.mDescription = metadata == null ? null : metadata.getDescription();
        this.mState = this.mMediaController == null ? null : this.mMediaController.getPlaybackState();
        this.update();
    }

    public MediaSessionCompat.Token getMediaSession() {
        return this.mMediaController == null ? null : this.mMediaController.getSessionToken();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().requestFeature(1);
        this.setContentView(R.layout.mr_media_route_controller_material_dialog_b);
        ClickListener listener = new ClickListener();
        this.mDisconnectButton = (Button)this.findViewById(R.id.disconnect);
        this.mDisconnectButton.setOnClickListener((View.OnClickListener)listener);
        this.mStopCastingButton = (Button)this.findViewById(R.id.stop);
        this.mStopCastingButton.setOnClickListener((View.OnClickListener)listener);
        this.mSettingsButton = (ImageButton)this.findViewById(R.id.settings);
        this.mSettingsButton.setOnClickListener((View.OnClickListener)listener);
        this.mArtView = (ImageView)this.findViewById(R.id.art);
        this.mTitleView = (TextView)this.findViewById(R.id.title);
        this.mSubtitleView = (TextView)this.findViewById(R.id.subtitle);
        this.mTitlesWrapper = this.findViewById(R.id.text_wrapper);
        this.mPlayPauseButton = (ImageButton)this.findViewById(R.id.play_pause);
        this.mPlayPauseButton.setOnClickListener((View.OnClickListener)listener);
        this.mRouteNameView = (TextView)this.findViewById(R.id.route_name);
        this.mCreated = true;
        if (this.update()) {
            this.mControlView = this.onCreateMediaControlView(savedInstanceState);
            FrameLayout controlFrame = (FrameLayout)this.findViewById(R.id.media_route_control_frame);
            if (this.mControlView != null) {
                controlFrame.findViewById(R.id.default_control_frame).setVisibility(8);
                controlFrame.addView(this.mControlView);
            }
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        this.mRouter.addCallback(MediaRouteSelector.EMPTY, this.mCallback, 2);
        this.setMediaSession(this.mRouter.getMediaSessionToken());
    }

    public void onDetachedFromWindow() {
        this.mRouter.removeCallback(this.mCallback);
        this.setMediaSession(null);
        this.mAttachedToWindow = false;
        super.onDetachedFromWindow();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 25 || keyCode == 24) {
            this.mRoute.requestUpdateVolume(keyCode == 25 ? -1 : 1);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 25 || keyCode == 24) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private boolean update() {
        if (!this.mRoute.isSelected() || this.mRoute.isDefault()) {
            this.dismiss();
            return false;
        }
        if (!this.mCreated) {
            return false;
        }
        this.mRouteNameView.setText((CharSequence)this.mRoute.getName());
        if (this.mRoute.canDisconnect()) {
            this.mDisconnectButton.setVisibility(0);
        } else {
            this.mDisconnectButton.setVisibility(8);
        }
        if (this.mRoute.getSettingsIntent() != null) {
            this.mSettingsButton.setVisibility(0);
        } else {
            this.mSettingsButton.setVisibility(8);
        }
        if (this.mControlView == null) {
            if (this.mDescription != null) {
                if (this.mDescription.getIconBitmap() != null) {
                    this.mArtView.setImageBitmap(this.mDescription.getIconBitmap());
                    this.mArtView.setVisibility(0);
                } else if (this.mDescription.getIconUri() != null) {
                    this.mArtView.setImageURI(this.mDescription.getIconUri());
                    this.mArtView.setVisibility(0);
                } else {
                    this.mArtView.setImageDrawable(null);
                    this.mArtView.setVisibility(8);
                }
                boolean haveText = false;
                CharSequence text = this.mDescription.getTitle();
                if (!TextUtils.isEmpty((CharSequence)text)) {
                    this.mTitleView.setText(text);
                    haveText = true;
                } else {
                    this.mTitleView.setText(null);
                    this.mTitleView.setVisibility(8);
                }
                text = this.mDescription.getSubtitle();
                if (!TextUtils.isEmpty((CharSequence)text)) {
                    this.mSubtitleView.setText(this.mDescription.getSubtitle());
                    haveText = true;
                } else {
                    this.mSubtitleView.setText(null);
                    this.mSubtitleView.setVisibility(8);
                }
                if (!haveText) {
                    this.mTitlesWrapper.setVisibility(8);
                } else {
                    this.mTitlesWrapper.setVisibility(0);
                }
            } else {
                this.mArtView.setVisibility(8);
                this.mTitlesWrapper.setVisibility(8);
            }
            if (this.mState != null) {
                boolean supportsPause;
                boolean isPlaying = this.mState.getState() == 6 || this.mState.getState() == 3;
                boolean supportsPlay = (this.mState.getActions() & 0x204L) != 0L;
                boolean bl = supportsPause = (this.mState.getActions() & 0x202L) != 0L;
                if (isPlaying && supportsPause) {
                    this.mPlayPauseButton.setVisibility(0);
                    this.mPlayPauseButton.setImageResource(MediaRouterThemeHelper.getThemeResource(this.getContext(), R.attr.mediaRoutePauseDrawable));
                    this.mPlayPauseButton.setContentDescription(this.getContext().getResources().getText(R.string.mr_media_route_controller_pause));
                } else if (!isPlaying && supportsPlay) {
                    this.mPlayPauseButton.setVisibility(0);
                    this.mPlayPauseButton.setImageResource(MediaRouterThemeHelper.getThemeResource(this.getContext(), R.attr.mediaRoutePlayDrawable));
                    this.mPlayPauseButton.setContentDescription(this.getContext().getResources().getText(R.string.mr_media_route_controller_play));
                } else {
                    this.mPlayPauseButton.setVisibility(8);
                }
            } else {
                this.mPlayPauseButton.setVisibility(8);
            }
        }
        return true;
    }

    private Drawable getIconDrawable() {
        if (this.mRoute.isConnecting()) {
            if (this.mMediaRouteConnectingDrawable == null) {
                this.mMediaRouteConnectingDrawable = MediaRouterThemeHelper.getThemeDrawable(this.getContext(), R.attr.mediaRouteConnectingDrawable);
            }
            return this.mMediaRouteConnectingDrawable;
        }
        if (this.mMediaRouteOnDrawable == null) {
            this.mMediaRouteOnDrawable = MediaRouterThemeHelper.getThemeDrawable(this.getContext(), R.attr.mediaRouteOnDrawable);
        }
        return this.mMediaRouteOnDrawable;
    }

    private final class ClickListener
    implements View.OnClickListener {
        private ClickListener() {
        }

        public void onClick(View v) {
            IntentSender is;
            int id2 = v.getId();
            if (id2 == R.id.stop || id2 == R.id.disconnect) {
                if (MediaRouteControllerDialog.this.mRoute.isSelected()) {
                    MediaRouteControllerDialog.this.mRouter.unselect(id2 == R.id.stop ? 2 : 1);
                }
                MediaRouteControllerDialog.this.dismiss();
            } else if (id2 == R.id.play_pause) {
                if (MediaRouteControllerDialog.this.mMediaController != null && MediaRouteControllerDialog.this.mState != null) {
                    if (MediaRouteControllerDialog.this.mState.getState() == 3) {
                        MediaRouteControllerDialog.this.mMediaController.getTransportControls().pause();
                    } else {
                        MediaRouteControllerDialog.this.mMediaController.getTransportControls().play();
                    }
                }
            } else if (id2 == R.id.settings && (is = MediaRouteControllerDialog.this.mRoute.getSettingsIntent()) != null) {
                try {
                    is.sendIntent(null, 0, null, null, null);
                    MediaRouteControllerDialog.this.dismiss();
                }
                catch (Exception e) {
                    Log.e((String)MediaRouteControllerDialog.TAG, (String)"Error opening route settings.", (Throwable)e);
                }
            }
        }
    }

    private final class MediaControllerCallback
    extends MediaControllerCompat.Callback {
        private MediaControllerCallback() {
        }

        public void onSessionDestroyed() {
            if (MediaRouteControllerDialog.this.mMediaController != null) {
                MediaRouteControllerDialog.this.mMediaController.unregisterCallback((MediaControllerCompat.Callback)MediaRouteControllerDialog.this.mControllerCallback);
                MediaRouteControllerDialog.this.mMediaController = null;
            }
        }

        public void onPlaybackStateChanged(PlaybackStateCompat state) {
            MediaRouteControllerDialog.this.mState = state;
            MediaRouteControllerDialog.this.update();
        }

        public void onMetadataChanged(MediaMetadataCompat metadata) {
            MediaRouteControllerDialog.this.mDescription = metadata == null ? null : metadata.getDescription();
            MediaRouteControllerDialog.this.update();
        }
    }

    private final class MediaRouterCallback
    extends MediaRouter.Callback {
        private MediaRouterCallback() {
        }

        @Override
        public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo route) {
            MediaRouteControllerDialog.this.update();
        }

        @Override
        public void onRouteChanged(MediaRouter router, MediaRouter.RouteInfo route) {
            MediaRouteControllerDialog.this.update();
        }

        @Override
        public void onRouteVolumeChanged(MediaRouter router, MediaRouter.RouteInfo route) {
            if (route == MediaRouteControllerDialog.this.mRoute) {
                // empty if block
            }
        }
    }
}

