/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzauD;
    private final TurnBasedMatchBuffer zzauE;
    private final TurnBasedMatchBuffer zzauF;
    private final TurnBasedMatchBuffer zzauG;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.zza(matchData, 0);
        this.zzauD = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zza(matchData, 1);
        this.zzauE = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zza(matchData, 2);
        this.zzauF = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zza(matchData, 3);
        this.zzauG = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zza(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzfG(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.zzauD;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzauE;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzauF;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzauG;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.zzauD != null) {
            this.zzauD.release();
        }
        if (this.zzauE != null) {
            this.zzauE.release();
        }
        if (this.zzauF != null) {
            this.zzauF.release();
        }
        if (this.zzauG != null) {
            this.zzauG.release();
        }
    }

    public boolean hasData() {
        if (this.zzauD != null && this.zzauD.getCount() > 0) {
            return true;
        }
        if (this.zzauE != null && this.zzauE.getCount() > 0) {
            return true;
        }
        if (this.zzauF != null && this.zzauF.getCount() > 0) {
            return true;
        }
        return this.zzauG != null && this.zzauG.getCount() > 0;
    }
}

