/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.appcontent;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.appcontent.AppContentAction;
import com.google.android.gms.games.appcontent.AppContentActionEntity;
import com.google.android.gms.games.appcontent.AppContentAnnotation;
import com.google.android.gms.games.appcontent.AppContentAnnotationEntity;
import com.google.android.gms.games.appcontent.AppContentCard;
import com.google.android.gms.games.appcontent.AppContentCardEntityCreator;
import com.google.android.gms.games.appcontent.AppContentCondition;
import com.google.android.gms.games.appcontent.AppContentConditionEntity;
import java.util.ArrayList;
import java.util.List;

public final class AppContentCardEntity
implements SafeParcelable,
AppContentCard {
    public static final AppContentCardEntityCreator CREATOR = new AppContentCardEntityCreator();
    private final int zzCY;
    private final ArrayList<AppContentActionEntity> mActions;
    private final ArrayList<AppContentAnnotationEntity> zzaov;
    private final ArrayList<AppContentConditionEntity> zzaol;
    private final String zzaom;
    private final int zzaow;
    private final String zzakM;
    private final Bundle mExtras;
    private final String zzaox;
    private final String zzadv;
    private final int zzaoy;
    private final String zzEl;
    private final String zzKI;

    public AppContentCardEntity(AppContentCard card) {
        this.zzCY = 4;
        this.zzaom = card.zzrP();
        this.zzaow = card.zzsa();
        this.zzakM = card.getDescription();
        this.mExtras = card.getExtras();
        this.zzKI = card.getId();
        this.zzadv = card.getTitle();
        this.zzaox = card.zzsb();
        this.zzaoy = card.zzsc();
        this.zzEl = card.getType();
        List<AppContentAction> list = card.getActions();
        int n = list.size();
        this.mActions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.mActions.add((AppContentActionEntity)list.get(i).freeze());
        }
        List<AppContentAnnotation> list2 = card.zzrZ();
        int n2 = list2.size();
        this.zzaov = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            this.zzaov.add((AppContentAnnotationEntity)list2.get(i).freeze());
        }
        List<AppContentCondition> list3 = card.zzrO();
        int n3 = list3.size();
        this.zzaol = new ArrayList(n3);
        for (int i = 0; i < n3; ++i) {
            this.zzaol.add((AppContentConditionEntity)list3.get(i).freeze());
        }
    }

    AppContentCardEntity(int versionCode, ArrayList<AppContentActionEntity> actions, ArrayList<AppContentAnnotationEntity> annotations, ArrayList<AppContentConditionEntity> conditions, String contentDescription, int currentProgress, String description, Bundle extras, String subtitle, String title, int totalProgress, String type, String id) {
        this.zzCY = versionCode;
        this.mActions = actions;
        this.zzaov = annotations;
        this.zzaol = conditions;
        this.zzaom = contentDescription;
        this.zzaow = currentProgress;
        this.zzakM = description;
        this.mExtras = extras;
        this.zzKI = id;
        this.zzaox = subtitle;
        this.zzadv = title;
        this.zzaoy = totalProgress;
        this.zzEl = type;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public List<AppContentAction> getActions() {
        return new ArrayList<AppContentAction>(this.mActions);
    }

    @Override
    public List<AppContentAnnotation> zzrZ() {
        return new ArrayList<AppContentAnnotation>(this.zzaov);
    }

    @Override
    public List<AppContentCondition> zzrO() {
        return new ArrayList<AppContentCondition>(this.zzaol);
    }

    @Override
    public String zzrP() {
        return this.zzaom;
    }

    @Override
    public int zzsa() {
        return this.zzaow;
    }

    @Override
    public String getDescription() {
        return this.zzakM;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public String getId() {
        return this.zzKI;
    }

    @Override
    public String zzsb() {
        return this.zzaox;
    }

    @Override
    public String getTitle() {
        return this.zzadv;
    }

    @Override
    public int zzsc() {
        return this.zzaoy;
    }

    @Override
    public String getType() {
        return this.zzEl;
    }

    public AppContentCard zzsd() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AppContentCardEntity.zza(this);
    }

    static int zza(AppContentCard appContentCard) {
        return zzt.hashCode((Object[])new Object[]{appContentCard.getActions(), appContentCard.zzrZ(), appContentCard.zzrO(), appContentCard.zzrP(), appContentCard.zzsa(), appContentCard.getDescription(), appContentCard.getExtras(), appContentCard.getId(), appContentCard.zzsb(), appContentCard.getTitle(), appContentCard.zzsc(), appContentCard.getType()});
    }

    public boolean equals(Object obj) {
        return AppContentCardEntity.zza(this, obj);
    }

    static boolean zza(AppContentCard appContentCard, Object object) {
        if (!(object instanceof AppContentCard)) {
            return false;
        }
        if (appContentCard == object) {
            return true;
        }
        AppContentCard appContentCard2 = (AppContentCard)object;
        return zzt.equal(appContentCard2.getActions(), appContentCard.getActions()) && zzt.equal(appContentCard2.zzrZ(), appContentCard.zzrZ()) && zzt.equal(appContentCard2.zzrO(), appContentCard.zzrO()) && zzt.equal((Object)appContentCard2.zzrP(), (Object)appContentCard.zzrP()) && zzt.equal((Object)appContentCard2.zzsa(), (Object)appContentCard.zzsa()) && zzt.equal((Object)appContentCard2.getDescription(), (Object)appContentCard.getDescription()) && zzt.equal((Object)appContentCard2.getExtras(), (Object)appContentCard.getExtras()) && zzt.equal((Object)appContentCard2.getId(), (Object)appContentCard.getId()) && zzt.equal((Object)appContentCard2.zzsb(), (Object)appContentCard.zzsb()) && zzt.equal((Object)appContentCard2.getTitle(), (Object)appContentCard.getTitle()) && zzt.equal((Object)appContentCard2.zzsc(), (Object)appContentCard.zzsc()) && zzt.equal((Object)appContentCard2.getType(), (Object)appContentCard.getType());
    }

    public String toString() {
        return AppContentCardEntity.zzb(this);
    }

    static String zzb(AppContentCard appContentCard) {
        return zzt.zzt((Object)appContentCard).zzg("Actions", appContentCard.getActions()).zzg("Annotations", appContentCard.zzrZ()).zzg("Conditions", appContentCard.zzrO()).zzg("ContentDescription", (Object)appContentCard.zzrP()).zzg("CurrentSteps", (Object)appContentCard.zzsa()).zzg("Description", (Object)appContentCard.getDescription()).zzg("Extras", (Object)appContentCard.getExtras()).zzg("Id", (Object)appContentCard.getId()).zzg("Subtitle", (Object)appContentCard.zzsb()).zzg("Title", (Object)appContentCard.getTitle()).zzg("TotalSteps", (Object)appContentCard.zzsc()).zzg("Type", (Object)appContentCard.getType()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        AppContentCardEntityCreator.zza(this, out, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zzsd();
    }
}

