#include <SdFat.h>
#include <Wire.h>
#include "RTClib.h"

// A simple data logger for the Arduino analog pins
#define LOG_INTERVAL  10000 // 10 sec between entries
//#define LOG_INTERVAL  15000 // 30 secs between entries
#define ECHO_TO_SERIAL   1 // echo data to serial port
#define WAIT_TO_START    0 // Wait for serial input in setup()

// the digital pins that connect to the LEDs
#define redLEDpin 2
#define greenLEDpin 3

/* M. Suzuki
  HSMG20 temperature/RH sensor
  HGM20G Rev.1
  http://sites.google.com/site/measuringstuff
  code added for pedometer on analog 3
 */
 
const byte nsamp=10;

// Analog pins
int humidityPin=1;
int Thgm20Pin=2;
int PedoPin=3;

unsigned int sensorValue2 = 0;  // value coming from the sensor
unsigned int sensorValue3 = 0;  // value coming from the sensor
float TinF=0.0;
int StepCnt=0;	// Pedometer counts between sample intervals
int TotalCnt=0;	// Pedometer total counts since starting sampling

RTC_DS1307 RTC; // define the Real Time Clock object

// Timing counters
unsigned long StartTime;

// The objects to talk to the SD card
Sd2Card card;
SdVolume volume;
SdFile root;
SdFile file;

void error(char *str)
{
  Serial.print("error: ");
  Serial.println(str);
  while(1);
}

void setup(void)
{
  Serial.begin(9600);
  Serial.println();
  
#if WAIT_TO_START
  Serial.println("Type any character to start");
  while (!Serial.available());
#endif //WAIT_TO_START

  // initialize the SD card
  if (!card.init()) error("card.init");
  
  // initialize a FAT volume
  if (!volume.init(card)) error("volume.init");
  
  // open root directory
  if (!root.openRoot(volume)) error("openRoot");
  
  // create a new file
  char name[] = "LOGGER00.CSV";
  for (uint8_t i = 0; i < 100; i++) {
    name[6] = i/10 + '0';
    name[7] = i%10 + '0';
    if (file.open(root, name, O_CREAT | O_EXCL | O_WRITE)) break;
  }
  if (!file.isOpen()) error ("file.create");
  Serial.print("Logging to: ");
  Serial.println(name);

  // write header
  file.writeError = 0;

  Wire.begin();  
  if (!RTC.begin()) {
    file.println("RTC failed");
#if ECHO_TO_SERIAL
    Serial.println("RTC failed");
#endif  //ECHO_TO_SERIAL
  }
  
  file.println("date, time, tempF,RH%, steps, totalsteps");    
#if ECHO_TO_SERIAL
  Serial.println("date, time, tempF,RH%, steps, totalsteps");
#endif //ECHO_TO_SERIAL

  // attempt to write out the header to the file
  if (file.writeError || !file.sync()) {
    error("write header");
  }
  
  StartTime=millis(); //Initialize StartTime
}

void loop(void)
{
	DateTime now;
	// clear print error
	file.writeError = 0;

   digitalWrite(redLEDpin, HIGH);
  
	// MTS Pedometer reads about 1.2V open = 245 counts
	if (analogRead(PedoPin) < 50) // About .245V
		{
			StepCnt +=1;
			TotalCnt +=1;
			delay(300);	//Delay .3 sec
		}

if ((millis()-StartTime)>long(LOG_INTERVAL))
	{
		digitalWrite(redLEDpin, LOW);
		// fetch the time
		now = RTC.now();
		// log time
		//file.print('"');
		file.print(now.month(), DEC);
		file.print("/");
		file.print(now.day(), DEC);
		file.print("/");
		file.print(now.year(), DEC);
		//file.print('"');
		file.print(", ");
		//file.print('"');
		file.print(now.hour(), DEC);
		file.print(":");
		file.print(now.minute(), DEC);
		file.print(":");
		file.print(now.second(), DEC);
		//file.print('"');
	#if ECHO_TO_SERIAL
		//Serial.print('"');
		Serial.print(now.month(), DEC);
		Serial.print("/");
		Serial.print(now.day(), DEC);
		Serial.print("/");
		Serial.print(now.year(), DEC);
		//Serial.print('"');
		Serial.print(", "); 
		//Serial.print('"');
		Serial.print(now.hour(), DEC);
		Serial.print(":");
		Serial.print(now.minute(), DEC);
		Serial.print(":");
		Serial.print(now.second(), DEC);
		//Serial.print('"');
	#endif //ECHO_TO_SERIAL

		// Get humidity and temperature readings
		for (byte j=0;j<nsamp;j++)
		{    
			sensorValue2 += analogRead(humidityPin);    
			sensorValue3 += analogRead(Thgm20Pin); 
		}    
		int sensorValue2Avg=sensorValue2/nsamp;

		// original
		float RH= 0.1515*sensorValue2Avg-12.0;
		
		int sensorValue3Avg=sensorValue3/nsamp;
		float Vt=(float) sensorValue3Avg*5.0/1023.0;
		float R=(5.0-Vt)*10.0/Vt;
		float TinC=281.583*pow(1.0230,(1.0/R))*pow(R,-0.1227)-150.6614; 
		TinF=TinC*(9.0/5.0)+32; 
		
		sensorValue2=0; //Clear Buffers
		sensorValue3=0; //Clear Buffers

		file.print(", ");    
		file.print(TinF,0);
		file.print(", ");    
		file.print(RH,0);
		file.print(", "); 
		file.print(StepCnt);
		file.print(", "); 
		file.print(TotalCnt);
		
	#if ECHO_TO_SERIAL
		Serial.print(", ");   
		Serial.print(TinF,0);
		Serial.print(", ");    
		Serial.print(RH,0);
		Serial.print(", ");    
		Serial.print(StepCnt);
		Serial.print(", ");    
		Serial.print(TotalCnt);
	#endif //ECHO_TO_SERIAL
	
		StepCnt=0;
		StartTime=millis();
		file.println();
	#if ECHO_TO_SERIAL
		Serial.println();
	#endif // ECHO_TO_SERIAL

		if (file.writeError) error("write data");
		digitalWrite(redLEDpin, LOW);
	  
		StepCnt=0;	//Clear StepCnt
		StartTime = millis();	//Get StartTime for next LOG_INTERVAL
	  
		// blink LED to show we are syncing data to the card & updating FAT!
		digitalWrite(greenLEDpin, HIGH);
		if (!file.sync()) error("sync");
		digitalWrite(greenLEDpin, LOW);
	}
}