#include <SM.h>//state machine library
#include <SPI.h>
#include <Ethernet.h>
#include "Mudbus.h"

Mudbus Mb;

SM Master(&State10);//add & before the initial state on IDE 1.6.8 and above
SM Machine1(&State20);
SM Machine2(&State30);
SM Machine3(&State40);

int etat = 0;
int I1mb=0;//virtual mushroom button
int value1;
int value2;

void setup() {
  uint8_t mac[]     = { 0x90, 0xA2, 0xDA, 0x00, 0x51, 0x06 };
  uint8_t ip[]      = { 192, 168, 1, 144 };
  uint8_t gateway[] = { 192, 168, 1, 1 };
  uint8_t subnet[]  = { 255, 255, 255, 0 };
  Ethernet.begin(mac, ip, gateway, subnet); //Avoid SPI pins, pin 4 and pin 10 when using ethernet shield
  delay(5000);  //Time to open the terminal
  //Serial.begin(9600); NO!! IF YOU USE tx d0 AS INPUT!!!!!
  pinMode(24, OUTPUT);//pin 4 is disconnected and replace by pin 24 owing to a switch
  pinMode(5, OUTPUT);
  pinMode(6, OUTPUT);
  pinMode(7, OUTPUT);
  pinMode(26, OUTPUT);
  pinMode(28, OUTPUT);
  pinMode(30, OUTPUT);
  pinMode(32, OUTPUT);
  pinMode(34, OUTPUT);
  pinMode(A0, OUTPUT);
  pinMode(A1, OUTPUT);
  pinMode(A7, OUTPUT);

  DDRE = DDRE | B00001001; //D0 as output and then input, unless: not running
  DDRE = DDRE | B00001000;
  pinMode(14, INPUT);
  pinMode(9, INPUT);
  pinMode(8, INPUT);
  pinMode(15, INPUT);
  pinMode(16, INPUT);
  pinMode(17, INPUT);
  DDRD = DDRD | B00001111; //d18 d19 d20 d21 as output and then input, unless: not running
  DDRD = DDRD | B00000000;
  //pinMode(18, INPUT);//not needed!!!!!
  //pinMode(19, INPUT);
  //pinMode(20, INPUT);
  //pinMode(21, INPUT);
  pinMode(A15, INPUT);
  pinMode(A2, INPUT);
  pinMode(A3, INPUT);
  pinMode(A4, INPUT);
  pinMode(A5, INPUT);
  pinMode(A6, INPUT);
  //Mb.R[20] = 1500;
  
}

void loop() {
  Mb.Run();
   Mb.R[400] = 0;//hide a Pilotlight4 on HMI
  /*Mb.R[20] -> digitalRead(0);I1
  Mb.R[30] -> digitalRead(1);I2
  Mb.R[40] -> digitalRead(18);I11
  Mb.R[50] -> digitalRead(A4);I18
  Mb.R[60] <- digitalWrite(24, LOW);O1
  Mb.R[70] <- digitalWrite(5, LOW);O2
  Mb.R[80] <- digitalWrite(28, LOW);O6
  Mb.R[90] <- digitalWrite(A7, LOW);O12
  Mb.R[100] <- digitalWrite(6, LOW);O3
  */
  EXEC(Master);
  I1mb=Mb.R[20];
  if (digitalRead(0) == LOW || I1mb==0) {
    Machine1.Finish(); Machine2.Finish(); Machine3.Finish();
  }

  if (((digitalRead(0) == HIGH) && (I1mb==1) ) && Machine1.Finished && Machine2.Finished && Machine3.Finished) {
    EXEC(Machine1);
    Machine1.Set(State20);
    EXEC(Machine2);
    Machine2.Set(State30);
    EXEC(Machine3);
    Machine3.Set(State40);
  }
}

//The Master machine////////////////////////////////////////////////
State State10() {
  digitalWrite(24, LOW);
  Mb.R[60] = 0;
  digitalWrite(5, LOW);
  Mb.R[70] = 0;
  digitalWrite(28, LOW);
  Mb.R[80] = 0;
  digitalWrite(A7, LOW);
  Mb.R[90] = 0;
  digitalWrite(6, LOW);
  Mb.R[101] = 0;
  Mb.R[100] = 1;
  analogWrite(44,0);
  Mb.R[110] = 0;
  analogWrite(46,0);
  Mb.R[120] = 0;
  if ((digitalRead(0) == HIGH) && (I1mb==1)) Master.Set(State11);
}
State State11() {
  digitalWrite(6, HIGH);
  Mb.R[101] = 1;
  Mb.R[100] = 0;
  value1=analogRead(A9);
  Mb.R[130] = value1;
  analogWrite(44,value1/4);
  Mb.R[110] = value1/4;
  value2=analogRead(A8);
  Mb.R[140] = value2;
  analogWrite(46,value2/4);
  Mb.R[120] = value2/4;
  EXEC(Machine1);
  EXEC(Machine2);
  EXEC(Machine3);
  if (digitalRead(0) == LOW || (I1mb==0)) Master.Set(State10);
}

//The Machine1////////////////////////////////////////////////////
State State20() {
  digitalWrite(24, LOW);
  Mb.R[60] = 0;
  if (Machine1.Timeout(300)) Machine1.Set(State21) ;
}
State State21() {
  digitalWrite(24, HIGH);
  Mb.R[60] = 1;
  if (Machine1.Timeout(500)) Machine1.Set(State20) ;
}

//The Machine2////////////////////////////////////////////////////////
State State30() {
  digitalWrite(5, LOW);
  Mb.R[70] = 0;
  if (Machine2.Timeout(700)) Machine2.Set(State31) ;
}
State State31() {
  digitalWrite(5, HIGH);
  Mb.R[70] = 1;
  if (Machine2.Timeout(700)) Machine2.Set(State30) ;
}

//The Machine3////////////////////////////////////////////////////////
State State40() {
  digitalWrite(28, LOW);
  Mb.R[80] = 0;
  Mb.R[90] = 0;
  if ((RE(digitalRead(1), etat) == 1) || (RE(Mb.R[30], etat) == 1)) Machine3.Set(State41) ;
}
State State41() {
  digitalWrite(28, HIGH);
  Mb.R[80] = 1;
  if ((digitalRead(A4) == HIGH) || Mb.R[50] == 1)
  { digitalWrite(A7, HIGH);
    Mb.R[90] = 1;
  }
  else {
    digitalWrite(A7, LOW);
    Mb.R[90] = 0;
  }
  if ((RE(digitalRead(18), etat) == 1) || (RE(Mb.R[40], etat) == 1)) Machine3.Set(State40) ;
}

